/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.aircert.sdk.data;

import android.text.TextUtils;
import com.alibaba.fastjson.JSON;
import com.xdja.aircert.sdk.AirCertSdk;
import com.xdja.aircert.sdk.bean.CertApplyBean;
import com.xdja.aircert.sdk.bean.CertDetailInfoBean;
import com.xdja.aircert.sdk.bean.CommonResponse;
import com.xdja.aircert.sdk.bean.VerifyInfoBean;
import com.xdja.aircert.sdk.cert.PKCS10Utils;
import com.xdja.aircert.sdk.data.HttpCallBack;
import com.xdja.aircert.sdk.device.DeviceCache;
import com.xdja.aircert.sdk.device.DeviceWrapper;
import com.xdja.aircert.sdk.device.NetVHSMHandle;
import com.xdja.aircert.sdk.net.HttpClientManager;
import com.xdja.aircert.sdk.net.Params;
import com.xdja.aircert.sdk.util.ResponseUtil;
import com.xdja.cryptodev.CryptoDevManager;
import com.xdja.cryptodev.CryptoDevType;
import com.xdja.cryptodev.driver.IDevDriver;
import com.xdja.cryptodev.driver.chipmanager.ChipManagerDriver;
import okhttp3.Request;
import okhttp3.Response;
import org.json.JSONObject;

class CertRepository {
    CertRepository() {
    }

    static void applyCert(String phone, HttpCallBack<CertDetailInfoBean> callBack) {
        try {
            JSONObject object = new JSONObject();
            object.put("phone", (Object)phone);
            Request requestBody = HttpClientManager.initRequest("/airIssue-api/v1/identity/phone", object.toString());
            Response response = HttpClientManager.getInstance().getHttpClient().newCall(requestBody).execute();
            if (!response.isSuccessful()) {
                if (callBack != null) {
                    callBack.onException(23, new Exception("phone identity error"));
                }
                return;
            }
            CommonResponse commonResponse = ResponseUtil.parseResponse(response);
            if (commonResponse.getResult() != 0) {
                if (callBack != null) {
                    callBack.onException(23, new Exception("phone identity error"));
                }
                return;
            }
            VerifyInfoBean bean = Params.getVerifyInfoBean();
            bean.getChipInfo().setPhone(phone);
            Request request = HttpClientManager.initRequest("/airIssue-api/v1/identify/authentication", JSON.toJSONString((Object)bean));
            Response identityResponse = HttpClientManager.getInstance().getHttpClient().newCall(request).execute();
            CommonResponse identityCommonResponse = CertRepository.checkResponse(identityResponse, callBack, 23, "identity error");
            if (AirCertSdk.getsInstance().getAirCertConfig().getCardType() == 4) {
                boolean initSuccess = true;
                if (!NetVHSMHandle.isNetVHSMCanUse()) {
                    initSuccess = NetVHSMHandle.initVHSM(AirCertSdk.getsInstance().getContext(), AirCertSdk.getsInstance().getAirCertConfig().getVhsmIpPort());
                }
                if (initSuccess) {
                    CryptoDevManager.getInstance().onDriverDeviceAdded((IDevDriver)new ChipManagerDriver(), CryptoDevType.DEV_TYPE_Soft, NetVHSMHandle.getNetVhsmCardId(AirCertSdk.getsInstance().getContext()));
                    DeviceWrapper.getDevInfo();
                } else {
                    if (callBack != null) {
                        callBack.onException(23, new Exception("vhsm init error"));
                    }
                    return;
                }
            }
            String result = identityCommonResponse.getMessage();
            String p10ReqestBC = PKCS10Utils.getInstance().getP10RequestBC(DeviceCache.getsInstance().getCacheCryptoDevInfo().getType(), AirCertSdk.getsInstance().getAirCertConfig().getContainerNum(), result, true);
            if (TextUtils.isEmpty((CharSequence)p10ReqestBC) || p10ReqestBC.startsWith("errorCode")) {
                if (callBack != null) {
                    callBack.onException(23, new Exception(" p10 error"));
                }
                return;
            }
            CertApplyBean certApplyBean = Params.getCertApplyBean(p10ReqestBC, phone);
            Request certApplyRequest = HttpClientManager.initRequest("/airIssue-api/v1/cert/application", JSON.toJSONString((Object)certApplyBean));
            Response certApplyResponse = HttpClientManager.getInstance().getHttpClient().newCall(certApplyRequest).execute();
            String string = certApplyResponse.body().string();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void writeCert() {
    }

    private static CommonResponse checkResponse(Response response, HttpCallBack<CertDetailInfoBean> callBack, int errorCode, String errorMsg) {
        if (!response.isSuccessful()) {
            if (callBack != null) {
                callBack.onException(errorCode, new Exception(errorMsg));
            }
            return null;
        }
        CommonResponse commonResponse = ResponseUtil.parseResponse(response);
        if (!(commonResponse != null && commonResponse.isSuccess() || callBack == null)) {
            callBack.onException(errorCode, new Exception(errorMsg));
        }
        return commonResponse;
    }
}

