package com.xdja.aircert.sdk.bean;

import org.jetbrains.annotations.NotNull;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;

/**
 * @author admin
 */
public class CertDetailInfoBean implements Serializable {
    /**
     * 拥有者CN
     */
    private String subjectCn = "";
    /**
     * 颁发者CN
     */
    private String issuerCn = "";
    /**
     * 拥有者组织
     */
    private String subjectOrg = "";
    /**
     * 颁发者组织
     */
    private String issuerOrg = "";
    /**
     * 证书SN
     */
    private String sn = "";
    /**
     * 证书有效期 2013-10-9 / 2013-10-10
     */
    private String indate = "";
    /**
     * 容器编号
     */
    private int ctnNo = 0;
    private String alg = "";
    /**
     * 证书ID
     */
    private byte[] certId = new byte[2];
    /**
     * 证书长度
     */
    private int[] certLen = new int[1];
    private int ver = 0;
    /**
     * 起始时间
     */
    private Date notBefore = null;
    /**
     * 终止时间
     */
    private Date notAfter = null;

    public String getSubjectCn() {
        return subjectCn;
    }

    public void setSubjectCn(String subjectCn) {
        this.subjectCn = subjectCn;
    }

    public String getIssuerCn() {
        return issuerCn;
    }

    public void setIssuerCn(String issuerCn) {
        this.issuerCn = issuerCn;
    }

    public String getSubjectOrg() {
        return subjectOrg;
    }

    public void setSubjectOrg(String subjectOrg) {
        this.subjectOrg = subjectOrg;
    }

    public String getIssuerOrg() {
        return issuerOrg;
    }

    public void setIssuerOrg(String issuerOrg) {
        this.issuerOrg = issuerOrg;
    }

    public String getSn() {
        return sn;
    }

    public void setSn(String sn) {
        this.sn = sn;
    }

    public String getIndate() {
        return indate;
    }

    public void setIndate(String indate) {
        this.indate = indate;
    }

    public int getCtnNo() {
        return ctnNo;
    }

    public void setCtnNo(int ctnNo) {
        this.ctnNo = ctnNo;
    }

    public String getAlg() {
        return alg;
    }

    public void setAlg(String alg) {
        this.alg = alg;
    }

    public byte[] getCertId() {
        return certId;
    }

    public void setCertId(byte[] certId) {
        this.certId = certId;
    }

    public int[] getCertLen() {
        return certLen;
    }

    public void setCertLen(int[] certLen) {
        this.certLen = certLen;
    }

    public int getVer() {
        return ver;
    }

    public void setVer(int ver) {
        this.ver = ver;
    }

    public Date getNotBefore() {
        return notBefore;
    }

    public void setNotBefore(Date notBefore) {
        this.notBefore = notBefore;
    }

    public Date getNotAfter() {
        return notAfter;
    }

    public void setNotAfter(Date notAfter) {
        this.notAfter = notAfter;
    }

    @NotNull
    @Override
    public String toString() {
        return "{" +
                "subjectCn='" + subjectCn + '\'' +
                ",issuerCn='" + issuerCn + '\'' +
                ",subjectOrg='" + subjectOrg + '\'' +
                ",issuerOrg='" + issuerOrg + '\'' +
                ",sn='" + sn + '\'' +
                ",indate='" + indate + '\'' +
                ",notBefore='" + notBefore + '\'' +
                ",notAfter='" + notAfter + '\'' +
                ",ctnNo=" + ctnNo +
                ",alg='" + alg + '\'' +
                ",ver='" + ver + '\'' +
                ",certId=" + Arrays.toString(certId) +
                ",certLen=" + Arrays.toString(certLen) +
                '}';
    }
}
