package com.xdja.aircert.sdk.config;

import android.support.annotation.IntDef;
import android.support.annotation.StringDef;

/**
 * @author: lyl
 * desc:
 * 2020/11/2
 */
public class AirCertConstant {
    /**
     * 内置芯片类型
     */
    public static final int DEV_TYPE_CHIP = 1;
    /**
     * TF卡
     */
    public static final int DEV_TYPE_TF_CARD = 2;
    /**
     * 贴膜卡
     */
    public static final int DEV_TYPE_SIM_CARD = 3;
    /**
     * VHSM
     */
    public static final int DEV_TYPE_VHSM = 4;
    /**
     * SM2证书类型单证
     */
    public static final int ALG_TYPE_SM2 = 1;
    /**
     * SM2证书类型双证
     */
    public static final int ALG_TYPE_SM2_DOUBLE = 2;
    /**
     * RSA证书类型
     */
    public static final int ALG_TYPE_RSA = 3;
    /**
     * 证书类型-签名证书
     */
    public static final String CERT_TYPE_SIGNATURE = "签名证书";
    /**
     * 证书类型-加密证书
     */
    public static final String CERT_TYPE_ENCRYPTION = "加密证书";
    /**
     * 默认PIN码
     */
    public static final String PIN="111111";

    @IntDef({DEV_TYPE_CHIP, DEV_TYPE_TF_CARD, DEV_TYPE_SIM_CARD, DEV_TYPE_VHSM})
    public @interface DEV_TYPE {
    }

    @IntDef({ALG_TYPE_SM2, ALG_TYPE_SM2_DOUBLE, ALG_TYPE_RSA})
    public @interface ALG_TYPE {

    }

    @StringDef({CERT_TYPE_SIGNATURE, CERT_TYPE_ENCRYPTION})
    public @interface CERT_TYPE {

    }
}
