package com.xdja.aircert.sdk.data;

import android.text.TextUtils;

import com.alibaba.fastjson.JSON;
import com.xdja.aircert.sdk.AirCertSdk;
import com.xdja.aircert.sdk.bean.CertApplyBean;
import com.xdja.aircert.sdk.bean.CertDetailInfoBean;
import com.xdja.aircert.sdk.bean.CommonResponse;
import com.xdja.aircert.sdk.bean.VerifyInfoBean;
import com.xdja.aircert.sdk.bean.WriteFailBean;
import com.xdja.aircert.sdk.cert.PKCS10Utils;
import com.xdja.aircert.sdk.config.AirCertConstant;
import com.xdja.aircert.sdk.config.HttpErrorCode;
import com.xdja.aircert.sdk.device.CertHelper;
import com.xdja.aircert.sdk.device.DeviceCache;
import com.xdja.aircert.sdk.device.DeviceWrapper;
import com.xdja.aircert.sdk.device.NetVHSMHandle;
import com.xdja.aircert.sdk.device.OperateCertHelper;
import com.xdja.aircert.sdk.net.HttpClientManager;
import com.xdja.aircert.sdk.net.HttpUrl;
import com.xdja.aircert.sdk.net.Params;
import com.xdja.aircert.sdk.util.ResponseUtil;
import com.xdja.cryptodev.CryptoDevManager;
import com.xdja.cryptodev.CryptoDevType;
import com.xdja.cryptodev.driver.chipmanager.ChipManagerDriver;

import org.json.JSONObject;

import okhttp3.Request;
import okhttp3.Response;

/**
 * @author: lyl
 * desc:证书仓库
 * 2020/11/6
 */
class CertRepository {
    static void applyCert(String phone, final HttpCallBack<CertDetailInfoBean> callBack) {
        try {
            //校验手机号
            JSONObject object = new JSONObject();
            object.put("phone", phone);
            Request requestBody = HttpClientManager.initRequest(HttpUrl.IDENTITY_PHONE, object.toString());
            Response response = HttpClientManager.getInstance().getHttpClient().newCall(requestBody).execute();
            if (!response.isSuccessful()) {
                if (callBack != null) {
                    callBack.onException(HttpErrorCode.ERROR_CODE_IDENTITY, new Exception("phone identity error"));
                }
                return;
            }
            CommonResponse commonResponse = ResponseUtil.parseResponse(response, CommonResponse.class);
            if (commonResponse == null || commonResponse.getResult() != 0) {
                if (callBack != null) {
                    callBack.onException(HttpErrorCode.ERROR_CODE_IDENTITY, new Exception("phone identity error"));
                }
                return;
            }
            //身份认证
            VerifyInfoBean bean = Params.getVerifyInfoBean();
            bean.getChipInfo().setPhone(phone);
            Request request = HttpClientManager.initRequest(HttpUrl.IDENTITY_AUTH, JSON.toJSONString(bean));
            Response identityResponse = HttpClientManager.getInstance().getHttpClient().newCall(request).execute();
            CommonResponse identityCommonResponse = checkResponse(identityResponse, callBack, HttpErrorCode.ERROR_CODE_IDENTITY, "identity error");
            if (identityCommonResponse == null) {
                return;
            }
            if (AirCertSdk.getsInstance().getAirCertConfig().getCardType() == AirCertConstant.DEV_TYPE_VHSM) {
                boolean initSuccess = true;
                if (!NetVHSMHandle.isNetVHSMCanUse()) {
                    /*当前为VHSM,并不可用,初始化*/
                    initSuccess = NetVHSMHandle.initVHSM(AirCertSdk.getsInstance().getContext(), AirCertSdk.getsInstance().getAirCertConfig().getVhsmIpPort());
                }
                if (initSuccess) {
                    CryptoDevManager.getInstance().onDriverDeviceAdded(
                            new ChipManagerDriver(), CryptoDevType.DEV_TYPE_Soft,
                            NetVHSMHandle.getNetVhsmCardId(AirCertSdk.getsInstance().getContext()));
                    DeviceWrapper.getDevInfo();
                } else {
                    /*vhsm初始化失败*/
                    if (callBack != null) {
                        callBack.onException(HttpErrorCode.ERROR_CODE_IDENTITY, new Exception("vhsm init error"));
                    }
                    return;
                }
            }
            /*生成P10*/
            String result = identityCommonResponse.getMessage();
            String p10RequestBC = PKCS10Utils.getInstance().getP10RequestBC(DeviceCache.getsInstance().getCacheCryptoDevInfo().getType(),
                    AirCertSdk.getsInstance().getAirCertConfig().getContainerNum(), result, true);
            if (TextUtils.isEmpty(p10RequestBC) || p10RequestBC.startsWith("errorCode")) {
                if (callBack != null) {
                    callBack.onException(HttpErrorCode.ERROR_CODE_IDENTITY, new Exception(" p10 error"));
                }
                return;
            }
            /*申请证书*/
            CertApplyBean certApplyBean = Params.getCertApplyBean(p10RequestBC, phone);
            Request certApplyRequest = HttpClientManager.initRequest(HttpUrl.APPLY, JSON.toJSONString(certApplyBean));
            Response certApplyResponse = HttpClientManager.getInstance().getHttpClient().newCall(certApplyRequest).execute();
            CommonResponse certApplyCommonResponse = checkResponse(certApplyResponse, callBack, HttpErrorCode.ERROR_CODE_IDENTITY, " cert apply error");
            if (certApplyCommonResponse == null) {
                return;
            }
            int resultCode = writeCert(certApplyCommonResponse);
            if (resultCode != 0) {
                //写入卡失败
                if (callBack != null) {
                    callBack.onException(HttpErrorCode.ERROR_CODE_IDENTITY, new Exception(" operate cert error"));
                }
                //上报写证书失败
                WriteFailBean writeFailBean = Params.getWriteFailBean(certApplyCommonResponse.getCert());
                Request writeFailRequest = HttpClientManager.initRequest(HttpUrl.WRITE_STATUS, JSON.toJSONString(writeFailBean));
                Response writeFailResponse = HttpClientManager.getInstance().getHttpClient().newCall(writeFailRequest).execute();
                return;
            }
            if (callBack != null) {
                CertDetailInfoBean certDetailInfoBean = CertHelper.readCertInfo();
                callBack.onSuccessResponse(certDetailInfoBean);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * 写证书
     */
    private static int writeCert( CommonResponse certInfoBean) {
        OperateCertHelper helper = new OperateCertHelper();
        return helper.importCert(DeviceCache.getsInstance().getCacheCryptoDevInfo().getType(), AirCertSdk.getsInstance().getAirCertConfig().getContainerNum(), certInfoBean.getCert());
    }

    private static CommonResponse checkResponse(Response response, HttpCallBack<CertDetailInfoBean> callBack, int errorCode, String errorMsg) {
        if (!response.isSuccessful()) {
            if (callBack != null) {
                callBack.onException(errorCode, new Exception(errorMsg));
            }
            return null;
        }
        CommonResponse commonResponse = ResponseUtil.parseResponse(response, CommonResponse.class);
        if (commonResponse == null || !commonResponse.isSuccess()) {
            if (callBack != null) {
                callBack.onException(errorCode, new Exception(errorMsg));
            }
            return null;
        }
        return commonResponse;
    }
}
