package com.xdja.aircert.sdk.device;

import android.text.TextUtils;

import com.xdja.aircert.sdk.AirCertSdk;
import com.xdja.aircert.sdk.bean.CertDetailInfoBean;
import com.xdja.aircert.sdk.cert.CertSKF;
import com.xdja.aircert.sdk.config.AirCertConfig;
import com.xdja.aircert.sdk.config.AirCertConstant;
import com.xdja.aircert.sdk.config.AlgType;
import com.xdja.aircert.sdk.config.CertRule;
import com.xdja.aircert.sdk.config.ContainerNum;
import com.xdja.aircert.sdk.config.XDJAAlgParams;
import com.xdja.cryptodev.CryptoDevType;
import com.xdja.cryptodev.devapi.CryptoInstance;
import com.xdja.multichip.param.CertBean;

import static com.xdja.aircert.sdk.device.DeviceWrapper.getCryptoInstance;

/**
 * @author: lyl
 * desc:
 * 2020/11/6
 */
public class CertHelper {
    /**
     * 获取算法类型
     *
     * @return
     */
    public static String getAlgType() {
        String defaultAlgType = AlgType.getDefault();
        AirCertConfig certConfig = AirCertSdk.getsInstance().getAirCertConfig();
        if (certConfig.getAlgType() == AirCertConstant.ALG_TYPE_RSA) {
            return transAlgType(AlgType.RSA);
        }
        return transAlgType(defaultAlgType);
    }

    private static String transAlgType(String algType) {
        return algType.equals(AlgType.RSA) ? XDJAAlgParams.CA_ALG_RSA : XDJAAlgParams.CA_ALG_SM2;
    }

    /**
     * 单证书还是双证书
     *
     * @return
     */
    public static String getCertRule(@AirCertConstant.ALG_TYPE int algType) {
        return algType == AirCertConstant.ALG_TYPE_SM2_DOUBLE ? CertRule.DOUBLE_CERT : CertRule.SINGLE;
    }

    /*  *//**
     * 获取证书类型  签名证书/加密证书
     * @param certType
     * @return
     *//*
    public static String getCertType(@AirCertConstant.CERT_TYPE int certType) {

    }*/

    /**
     * 获取容器角色
     *
     * @param containerNum
     * @return
     */
    public static int getRole(int containerNum) {
//        4、6号容器是0x11，其余是0x01
        if (String.valueOf(containerNum).equals(ContainerNum.FOUR) || String.valueOf(containerNum).equals(ContainerNum.SIX)) {
            return 0x11;
        } else {
            return 0x01;
        }
    }

    /**
     * 获取pin码
     *
     * @return
     */
    public static String getPin() {
        return AirCertConstant.PIN;
    }

    /**
     * 读取卡信息
     *
     * @return
     */
    public static CertDetailInfoBean readCertInfo() {
        return OperateCertHelper.readCertFromContainer(DeviceCache.getsInstance().getCacheCryptoDevInfo().getType(),
                AirCertSdk.getsInstance().getAirCertConfig().getContainerNum(), AirCertSdk.getsInstance().getAirCertConfig().getCertType());
    }
}
