/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safeclient.certcreation.activity;

import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import com.aircert.util.ModuleLog;
import com.alibaba.android.arouter.facade.annotation.Autowired;
import com.alibaba.android.arouter.facade.annotation.Route;
import com.xdja.cryptodev.CryptoDevType;
import com.xdja.safeclient.certcreation.AppConfig;
import com.xdja.safeclient.certcreation.HttpResponseCallBack;
import com.xdja.safeclient.certcreation.R;
import com.xdja.safeclient.certcreation.activity.BaseActivity;
import com.xdja.safeclient.certcreation.bean.request.VerifyPhoneRequest;
import com.xdja.safeclient.certcreation.bean.response.BaseErrorResponse;
import com.xdja.safeclient.certcreation.bean.response.CommonResponse;
import com.xdja.safeclient.certcreation.bean.response.CompareResult;
import com.xdja.safeclient.certcreation.bean.result.PhoneAuthResult;
import com.xdja.safeclient.certcreation.bean.result.PhoneResult;
import com.xdja.safeclient.certcreation.device.DeviceWrapper;
import com.xdja.safeclient.certcreation.device.NetVHSMHandle;
import com.xdja.safeclient.certcreation.util.ApplyCertUtil;
import com.xdja.safeclient.certcreation.util.EditTextUtil;
import com.xdja.safeclient.certcreation.util.KeyboardUtils;
import com.xdja.safeclient.certcreation.util.ModuleToast;
import com.xdja.safeclient.certcreation.util.OttoUtil;
import com.xdja.safeclient.certcreation.util.SharePreferencesUtil;
import com.xdja.safeclient.certcreation.view.NoDoubleClickListener;
import com.xdja.safeclient.certcreation.view.PinDialog;
import java.io.IOException;
import okhttp3.Call;

@Route(path="/cert/phone_apply_cert", name="\u8f93\u5165\u624b\u673a\u53f7\u53d1\u8bc1")
public class PhoneApplyActivity
extends BaseActivity {
    private Button btn_submit;
    private EditText etPhone;
    private PinDialog pinDialog;
    @Autowired(name="cardType")
    public CryptoDevType cardType;
    @Autowired(name="containerNum")
    public int containerNum;
    @Autowired(name="cardNum")
    public String cardNum;
    @Autowired(name="certType")
    public String certType;
    private boolean isVerifying = false;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.cert_creation_activity_phone_apply_cert);
        this.verifyPin();
        this.initView();
    }

    protected int getTitleRes() {
        return -1;
    }

    @Override
    protected void getIntentData() {
        super.getIntentData();
        this.cardType = (CryptoDevType)this.getIntent().getSerializableExtra("cardType");
        this.cardNum = this.getIntent().getStringExtra("cardNum");
        this.containerNum = this.getIntent().getIntExtra("containerNum", 0);
        this.certType = this.getIntent().getStringExtra("certType");
    }

    private void initView() {
        this.etPhone = (EditText)this.findViewById(R.id.et_phone);
        this.etPhone.setFilters(EditTextUtil.getDisableEmojFilter());
        this.btn_submit = (Button)this.findViewById(R.id.btn_submit);
        this.btn_submit.setOnClickListener((View.OnClickListener)new NoDoubleClickListener(){

            @Override
            public void onNoDoubleClick(View v) {
                PhoneApplyActivity.this.submit();
            }
        });
    }

    private void verifyPin() {
        if (this.cardType != CryptoDevType.DEV_TYPE_Soft || NetVHSMHandle.isNetVHSMCanUse()) {
            DeviceWrapper.getInstance();
            int pinResult = DeviceWrapper.verifyPin(this.cardType, this.containerNum, AppConfig.getInstance().getDefaultConfig().getPin());
            if (pinResult != 0) {
                this.pinDialog = new PinDialog((Context)this, this.cardType);
                this.pinDialog.show();
            }
        }
    }

    private void submit() {
        KeyboardUtils.hideKeyboard((View)this.etPhone);
        if (!DeviceWrapper.getInstance().isApplyCertEnd()) {
            DeviceWrapper.getInstance().setApplyCertEnd(true);
            String phone = this.etPhone.getText().toString();
            if (TextUtils.isEmpty((CharSequence)phone)) {
                ModuleToast.showNoRepeat((Context)this, R.string.cert_creation_not_null_phone_num);
                return;
            }
            this.verifyPhoneNum(phone);
            this.isVerifying = true;
        }
    }

    private void verifyPhoneNum(String phone) {
        VerifyPhoneRequest request = new VerifyPhoneRequest(phone);
        this.showLoading();
        this.service.verifyPhoneNum(request, this.cardNum, new HttpResponseCallBack<CommonResponse>(){

            @Override
            public void onOtherException(Exception e) {
                DeviceWrapper.getInstance().setApplyCertEnd(false);
                e.printStackTrace();
                PhoneApplyActivity.this.isVerifying = false;
            }

            @Override
            public void onIoExceptionFailure(Call call, IOException e) {
                DeviceWrapper.getInstance().setApplyCertEnd(false);
                PhoneApplyActivity.this.showRequestError();
                PhoneApplyActivity.this.isVerifying = false;
            }

            @Override
            public void onSuccessfulResponse(Call call, CommonResponse commonResponse) {
                PhoneApplyActivity.this.isVerifying = false;
                String resultCode = commonResponse.getResult();
                if (resultCode.equals("0")) {
                    PhoneApplyActivity.this.startVerify();
                } else {
                    PhoneResult phoneResult = PhoneApplyActivity.this.buildPhoneResult(PhoneApplyActivity.this.getCardType(), PhoneApplyActivity.this.getCardNum(), commonResponse, null);
                    PhoneAuthResult authResult = new PhoneAuthResult();
                    authResult.setContainerNum(PhoneApplyActivity.this.containerNum);
                    authResult.setPhoneResult(phoneResult);
                    OttoUtil.postPhoneAuthResult(authResult);
                    PhoneApplyActivity.this.finish();
                }
            }

            @Override
            public void onFailResponse(Call call, BaseErrorResponse baseErrorResponse) {
                DeviceWrapper.getInstance().setApplyCertEnd(false);
                PhoneApplyActivity.this.isVerifying = false;
            }

            @Override
            public void dismissDialog() {
                PhoneApplyActivity.this.dismissLoading();
            }
        });
    }

    private PhoneResult buildPhoneResult(CryptoDevType type, String cardNum, CommonResponse response, BaseErrorResponse errorResponse) {
        CompareResult result = new CompareResult();
        if (response == null && errorResponse == null) {
            result.setResult("");
            result.setMessage("");
            result.setErrCode("");
            result.setSuccess(false);
        } else if (errorResponse != null) {
            result.setResult(errorResponse.getErrCode());
            result.setErrCode(errorResponse.getErrCode());
            if (!TextUtils.isEmpty((CharSequence)errorResponse.getMessage())) {
                result.setMessage(errorResponse.getMessage());
            }
            result.setSuccess(false);
        } else {
            result.setResult(response.getResult());
            result.setMessage(response.getMessage());
            result.setSuccess(true);
        }
        result.setIdentity(cardNum);
        PhoneResult phoneResult = new PhoneResult(type, result);
        return phoneResult;
    }

    private void startVerify() {
        if (this.cardType == null || TextUtils.isEmpty((CharSequence)this.cardNum)) {
            return;
        }
        String phoneNum = this.etPhone.getText().toString();
        SharePreferencesUtil.savePhone((Context)this, phoneNum);
        ModuleLog.e((Object)"PhoneInput 531");
        ApplyCertUtil.start((Context)this, this.containerNum, new ApplyCertUtil.WhatHappen(){

            @Override
            public void showDialog() {
                PhoneApplyActivity.this.showLoading();
            }

            @Override
            public void cancelDialog() {
                PhoneApplyActivity.this.dismissLoading();
            }

            @Override
            public void IOError() {
                DeviceWrapper.getInstance().setApplyCertEnd(false);
                PhoneApplyActivity.this.dismissLoading();
                PhoneApplyActivity.this.showRequestError();
            }

            @Override
            public void handleResult(CommonResponse response) {
                PhoneApplyActivity.this.finish();
            }

            @Override
            public void handleError(BaseErrorResponse baseErrorResponse) {
                PhoneApplyActivity.this.handleError(baseErrorResponse);
            }
        });
    }

    private void handleError(BaseErrorResponse baseErrorResponse) {
        OttoUtil.postAuthResult(ApplyCertUtil.buildAuthResult(this.getCardType(), this.containerNum, this.getCardNum(), null, baseErrorResponse));
        OttoUtil.postFinishActivity();
        this.finish();
    }
}

