/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safeclient.certcreation.cache;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.support.v4.content.FileProvider;
import android.util.Base64;
import cn.cloudwalk.libproject.util.Util;
import com.aircert.util.ModuleLog;
import com.zxy.tiny.Tiny;
import com.zxy.tiny.callback.FileWithBitmapCallback;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;

public class ImageCache {
    public static final int PHOTO_REQUEST_TAKEPHOTO = 1;
    private static String path;
    private static Uri PATH_SELFIE;
    private static Uri PATH_ID_IMG;
    private String id;
    private String selfie;
    private Bitmap nfcFaceImg;
    private static ImageCache cache;

    public String getSelfie() {
        return this.selfie;
    }

    public static Uri getSelfieURI() {
        return PATH_SELFIE;
    }

    public static Uri getIDImageURI() {
        return PATH_ID_IMG;
    }

    public static void init(Context context) {
        if (Build.VERSION.SDK_INT >= 24) {
            File selfie = new File(context.getExternalCacheDir(), "img.jpg");
            String authority = "com.xdja.aircert.fileprovider";
            PATH_SELFIE = FileProvider.getUriForFile((Context)context, (String)authority, (File)selfie);
            File id2 = new File(context.getExternalCacheDir(), "id.jpg");
            PATH_ID_IMG = FileProvider.getUriForFile((Context)context, (String)authority, (File)id2);
        } else {
            path = Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DCIM).getAbsolutePath() + File.separator;
            File file = new File(path);
            if (!file.exists() && file.isDirectory()) {
                boolean success = file.mkdir();
                if (success) {
                    ModuleLog.e((Object)"selfie path has been created successfully");
                } else {
                    ModuleLog.e((Object)"selfie path has not been created");
                }
            }
            PATH_SELFIE = Uri.fromFile((File)new File(path, "img.jpg"));
            PATH_ID_IMG = Uri.fromFile((File)new File(path, "id.img"));
        }
    }

    public static void compressSelfie(int type, Bitmap bitmap) {
        ImageCache.compressFile(type, bitmap);
    }

    public static void compressIDImage(int type, Bitmap bitmap) {
        ImageCache.compressFile(type, bitmap);
    }

    private static void compressFile(final int type, Bitmap originBitmap) {
        ModuleLog.e((Object)("\u538b\u7f29\u524d\u5927\u5c0f" + originBitmap.getByteCount()));
        Tiny.FileCompressOptions options = new Tiny.FileCompressOptions();
        options.isKeepSampling = false;
        options.width = 480;
        options.height = 720;
        Tiny.getInstance().source(originBitmap).asFile().withOptions(options).compress(new FileWithBitmapCallback(){

            public void callback(boolean b, Bitmap bitmap, String s) {
                ModuleLog.e((Object)("\u538b\u7f29\u540e\u5927\u5c0f" + bitmap.getByteCount()));
                byte[] bitmapBytes = ImageCache.getBytesByBitmap(bitmap);
                String base64 = Base64.encodeToString((byte[])bitmapBytes, (int)0);
                String encodeBase64 = URLEncoder.encode(base64);
                if (type == 0) {
                    ImageCache.getInstance().setSelfie("\u76f8\u673a\u81ea\u62cd", base64, true);
                } else {
                    ImageCache.getInstance().setId("\u76f8\u673a\u81ea\u62cd", encodeBase64);
                }
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Bitmap compressFile(File file) {
        try (FileInputStream inputStream = new FileInputStream(file);){
            Bitmap bitmap2;
            BitmapFactory.Options opts = new BitmapFactory.Options();
            opts.inJustDecodeBounds = true;
            BitmapFactory.decodeStream((InputStream)inputStream, null, (BitmapFactory.Options)opts);
            int bitmapHeight = opts.outHeight;
            int bitmapWidth = opts.outWidth;
            int windowHeight = 480;
            int windowWidth = 720;
            int scaley = bitmapHeight / windowHeight;
            int scalex = bitmapWidth / windowWidth;
            if (scalex > scaley && scaley > 1) {
                opts.inSampleSize = scalex;
            }
            if (scaley > scalex && scalex > 1) {
                opts.inSampleSize = scaley;
            }
            opts.inJustDecodeBounds = false;
            Bitmap bitmap = bitmap2 = BitmapFactory.decodeStream((InputStream)new FileInputStream(file), null, (BitmapFactory.Options)opts);
            return bitmap;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static byte[] getBytesByBitmap(Bitmap bitmap) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(bitmap.getByteCount());
        bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)outputStream);
        return outputStream.toByteArray();
    }

    public void setSelfie(String selfieType, String selfie, boolean encode) {
        this.selfie = encode ? URLEncoder.encode(selfie) : selfie;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String idType, String id2) {
        this.id = id2;
    }

    private ImageCache() {
    }

    public static ImageCache getInstance() {
        if (cache == null) {
            cache = new ImageCache();
        }
        return cache;
    }

    public void clear() {
        cache = null;
    }

    public void clearID(Context context) {
        File yishu = new File(Environment.getExternalStorageDirectory() + File.separator + "yishu");
        ImageCache.deleteDir(yishu);
        ImageCache.deleteYuncongCache(context);
        File delete = new File(Environment.getExternalStorageDirectory() + File.separator + "alpha" + File.separator + "SIDCard");
        ImageCache.deleteDir(delete);
        File ID_IMG = new File(PATH_ID_IMG.getPath());
        ID_IMG.delete();
    }

    private static boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = ImageCache.deleteDir(new File(dir, children[i]));
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }

    private static void deleteYuncongCache(Context context) {
        try {
            String frontPath = Util.getDiskCacheDir((Context)context) + "/frontphoto.jpg";
            String backPath = Util.getDiskCacheDir((Context)context) + "/backphoto.jpg";
            File frontFile = new File(frontPath);
            File backFile = new File(backPath);
            if (frontFile.exists()) {
                frontFile.delete();
            }
            if (backFile.exists()) {
                backFile.delete();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyBase64ToFile(String base64, File dstFile) {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(dstFile);
            ((OutputStream)out).write(Base64.decode((String)base64, (int)0));
            out.flush();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (out != null) {
                try {
                    ((OutputStream)out).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public Bitmap getNfcFaceImg() {
        return this.nfcFaceImg;
    }

    public void setNfcFaceImg(Bitmap nfcFaceImg) {
        this.nfcFaceImg = nfcFaceImg;
    }

    static {
        PATH_SELFIE = null;
        PATH_ID_IMG = null;
    }
}

