/*
 * Decompiled with CFR 0.152.
 */
package ocr.activity;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Parcelable;
import android.text.TextUtils;
import android.view.View;
import android.widget.RelativeLayout;
import com.aircert.dialog.BindIdentifyDialog;
import com.aircert.util.ModuleLog;
import com.alibaba.android.arouter.facade.annotation.Autowired;
import com.alibaba.android.arouter.facade.annotation.Route;
import com.alibaba.android.arouter.launcher.ARouter;
import com.alibaba.fastjson.JSON;
import com.squareup.otto.Subscribe;
import com.xdja.a3rdplugin.R;
import com.xdja.a3rdplugin.demo.ModuleToast;
import com.xdja.a3rdplugin.demo.OCRCompany;
import com.xdja.a3rdplugin.demo.activity.ANRONGOCRActivity;
import com.xdja.a3rdplugin.demo.event.IDCardHeadResult;
import com.xdja.a3rdplugin.demo.event.IDCardTailResult;
import com.xdja.a3rdplugin.demo.ocr.XDJAOCR;
import com.xdja.cryptodev.CryptoDevType;
import com.xdja.safeclient.certcreation.AppConfig;
import com.xdja.safeclient.certcreation.R;
import com.xdja.safeclient.certcreation.activity.BaseActivity;
import com.xdja.safeclient.certcreation.activity.BasicInfoActivity;
import com.xdja.safeclient.certcreation.cache.ImageCache;
import com.xdja.safeclient.certcreation.event.ChooseBindwayEvent;
import com.xdja.safeclient.certcreation.event.ClearIDEvent;
import com.xdja.safeclient.certcreation.event.FinishActivity;
import com.xdja.safeclient.certcreation.event.FinishChooseEvent;
import com.xdja.safeclient.certcreation.event.InvokeXDJAOCREvent;
import com.xdja.safeclient.certcreation.event.SpecificActivity;
import com.xdja.safeclient.certcreation.util.DialogUtil;
import com.xdja.safeclient.certcreation.util.IntentUtil;
import ocr.activity.AnrongOCRIDActivity;
import ocr.activity.OcrActivity;
import ocr.activity.XDJANFCActivity;
import ocr.activity.XDJAOCRFailActivity;
import ocr.activity.XDJAOCRIDCardActivity;
import ocr.activity.XiZangYishuNFCActivity;
import ocr.bean.IDCardInfo;

@Route(name="\u9009\u62e9\u8eab\u4efd\u8ba4\u8bc1\u65b9\u5f0f", path="/cert/choose_bind_way")
public class ChooseBindWayActivity
extends BaseActivity {
    public static final int REQUEST_XDJA_OCR = 11;
    private String name;
    private String sex;
    private String birthDay;
    private String nation;
    private String address;
    private String idNum;
    private String procedure = AppConfig.getInstance().getServerSettingConfig().getProcedure();
    private String ocrCompany = AppConfig.getInstance().getServerSettingConfig().getOcrCompany();
    @Autowired(name="containerNum")
    public int containerNum;
    private String faceImg = "";
    private CryptoDevType cardType;
    private String cardNo;
    private String phone;
    private IDCardInfo id = new IDCardInfo();

    protected boolean hasActionBar() {
        return true;
    }

    protected int getToolbarType() {
        return 0;
    }

    protected int getTitleRes() {
        return R.string.cert_creation_choose_way;
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.choose_idenfity_way);
        this.cardType = IntentUtil.getCardType(this.getIntent());
        this.cardNo = IntentUtil.getCardNum(this.getIntent());
        this.phone = IntentUtil.getPhone(this.getIntent());
        this.onBindView();
        if (AppConfig.getInstance().getServerSettingConfig().getProcedure().equals("\u6807\u51c6\u6d41\u7a0b\uff08\u65e0NFC\uff09")) {
            this.gotoBasicInfoActivity();
        }
        this.init();
        if (this.ocrCompany.equals("\u4fe1\u5927\u6377\u5b89")) {
            if (!XDJAOCR.isInstall((Context)this)) {
                XDJAOCR.copyFile((Context)this);
            } else if (!XDJAOCR.isVersionOK((Context)this)) {
                XDJAOCR.copyFile((Context)this);
            }
        }
    }

    @Override
    protected void getData() {
        super.getData();
        this.faceImg = ImageCache.getInstance().getSelfie();
    }

    @Override
    protected void getIntentData() {
        super.getIntentData();
        this.containerNum = this.getIntent().getIntExtra("containerNum", 0);
    }

    @Subscribe
    public void handleSpecificActivity(SpecificActivity activity) {
        if (((Object)((Object)this)).getClass().getName().equals(activity.getTag())) {
            this.finish();
        }
    }

    private void init() {
        RelativeLayout iv_nfc = (RelativeLayout)this.findViewById(R.id.layout_nfc);
        RelativeLayout iv_ocr = (RelativeLayout)this.findViewById(R.id.layout_ocr);
        RelativeLayout iv_manual_input = (RelativeLayout)this.findViewById(R.id.layout_manual_input);
        iv_nfc.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ChooseBindWayActivity.this.gotoNFC();
            }
        });
        iv_ocr.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ChooseBindWayActivity.this.gotoOCR();
            }
        });
        iv_manual_input.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ChooseBindWayActivity.this.gotoBasicInfoActivity();
            }
        });
        iv_ocr.setVisibility(8);
        iv_nfc.setVisibility(8);
        iv_manual_input.setVisibility(8);
        if (!this.procedure.equals("\u6807\u51c6\u6d41\u7a0b\uff08\u65e0OCR\uff09")) {
            iv_ocr.setVisibility(0);
        }
        if (!this.procedure.equals("\u6807\u51c6\u6d41\u7a0b\uff08\u65e0NFC\uff09")) {
            iv_nfc.setVisibility(0);
        }
        if (AppConfig.getInstance().getServerSettingConfig().getProcedure().equals("\u6807\u51c6\u6d41\u7a0b\uff08\u65e0OCR\uff09")) {
            iv_manual_input.setVisibility(0);
        }
        if (this.ocrCompany.equals("\u767e\u5ea6")) {
            // empty if block
        }
    }

    private void gotoBasicInfoActivity() {
        Intent intent = new Intent((Context)this, BasicInfoActivity.class);
        intent = IntentUtil.putInfo(intent, this.cardType, this.cardNo);
        intent = IntentUtil.putPhone(intent, this.phone);
        Bundle bundle = new Bundle();
        bundle.putInt("containerNum", this.containerNum);
        intent.putExtras(bundle);
        this.startActivity(intent);
        this.finish();
    }

    private void gotoOCR() {
        this.doIdentify(false);
    }

    private void onBindView() {
        Bundle bundle = this.getIntent().getExtras();
        if (bundle != null && bundle.containsKey("faceImg")) {
            this.faceImg = bundle.getString("faceImg");
        }
    }

    private void gotoNFC() {
        this.doIdentify(true);
    }

    @SuppressLint(value={"StringFormatMatches"})
    private void doIdentify(boolean isNFC) {
        if (isNFC) {
            String nfcCompany;
            switch (nfcCompany = AppConfig.getInstance().getServerSettingConfig().getNfcCompany()) {
                case "\u4fe1\u5927\u6377\u5b89": {
                    Intent intentXdja = new Intent((Context)this, XDJANFCActivity.class);
                    Bundle othersXdja = new Bundle();
                    othersXdja.putInt("containerNum", this.containerNum);
                    intentXdja.putExtras(othersXdja);
                    this.startActivity(intentXdja);
                    break;
                }
                case "\u4ebf\u6570": {
                    Intent intent = new Intent((Context)this, XiZangYishuNFCActivity.class);
                    Bundle bundle = new Bundle();
                    bundle.putInt("containerNum", this.containerNum);
                    intent.putExtras(bundle);
                    this.startActivity(intent);
                }
            }
        } else {
            String ocrCompany;
            switch (ocrCompany = AppConfig.getInstance().getServerSettingConfig().getOcrCompany()) {
                case "\u5b89\u8363": {
                    if (!ANRONGOCRActivity.isApplicationInstalled((Context)this, (String)"com.anrongtec.ocr")) {
                        this.showAnrongDialog(this.getString(R.string.not_install_anrong_ocr));
                        return;
                    }
                    if (!ANRONGOCRActivity.isVersionOK((Context)this)) {
                        String targetVersion = "1.8";
                        String currentVersion = ANRONGOCRActivity.getVersion((Context)this, (String)"com.anrongtec.ocr");
                        this.showAnrongDialog(String.format(this.getString(R.string.wrong_ocr_version_1), targetVersion, currentVersion));
                        return;
                    }
                    OCRCompany.ANRONG((Context)this, (int)1);
                    break;
                }
                case "\u4fe1\u5927\u6377\u5b89": {
                    this.startXDJAOCR();
                    break;
                }
                case "\u4e91\u4ece": {
                    Intent intent = new Intent((Context)this, OcrActivity.class);
                    intent.putExtra("containerNum", this.containerNum);
                    this.startActivity(intent);
                    break;
                }
            }
        }
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        ModuleLog.e((Object)("requestCode: " + requestCode));
        ModuleLog.e((Object)("resultCode: " + resultCode));
        if (resultCode == -1 && requestCode == 11) {
            String json = data.getStringExtra("json");
            ModuleLog.e((Object)json);
            if (json.contains("blzd")) {
                IDCardHeadResult result = (IDCardHeadResult)JSON.parseObject((String)json, IDCardHeadResult.class);
                if (result.getXb().equals("\u7537") || result.getXb().equals("\u5973")) {
                    this.testXDJAOCRForward(result);
                } else {
                    this.testXDJAErrorForward();
                }
            }
        }
    }

    private void testXDJAOCRForward(IDCardHeadResult result) {
        ARouter.getInstance().build("/cert/xdja_ocr_id_card").withInt("containerNum", this.containerNum).withString("name", result.getXm()).withString("gender", result.getXb()).withString("idNum", result.getSfzh()).withString("faceImg", this.faceImg).navigation((Context)this);
    }

    private void testXDJAErrorForward() {
        Intent intent = new Intent((Context)this, XDJAOCRFailActivity.class);
        this.startActivity(intent);
    }

    private void showAnrongDialog(String text) {
        DialogUtil.install((Context)this, text, new DialogUtil.DialogInterface(){

            @Override
            public void onSuccess(Object ... objects) {
                ANRONGOCRActivity.goToAppStore((Context)ChooseBindWayActivity.this.getContext());
            }
        });
    }

    public static Intent buildIntent(Context context, int containerNum, String faceImg) {
        Intent intent = new Intent(context, ChooseBindWayActivity.class);
        Bundle bundle = new Bundle();
        bundle.putString("faceImg", faceImg);
        bundle.putInt("containerNum", containerNum);
        intent.putExtras(bundle);
        return intent;
    }

    @Override
    protected boolean setDialogCancelable() {
        return false;
    }

    @Subscribe
    public void handleIDCardHeadResult(IDCardHeadResult result) {
        if (this.id == null) {
            this.id = new IDCardInfo();
        }
        this.id.setName(result.getXm());
        this.id.setSex(result.getXb().equals("\u7537") ? 1 : 2);
        this.id.setBirthDate(result.getCsrq());
        this.id.setNation(result.getMz());
        this.id.setAddr(result.getCsdz());
        this.id.setIdNum(result.getSfzh());
        this.next();
    }

    @Subscribe
    public void handleIDCardTailResult(IDCardTailResult result) {
        this.id.setIssueOffice(result.getDepartment());
        this.id.setValidDate(result.getValidDate());
        this.next();
    }

    @Subscribe
    public void handleFinishChooseEvent(FinishChooseEvent event) {
        this.finish();
    }

    private void scan(final int side) {
        this.showLoading();
        new Handler().postDelayed(new Runnable(){

            @Override
            public void run() {
                ChooseBindWayActivity.this.dismissLoading();
                OCRCompany.ANRONG((Context)ChooseBindWayActivity.this.getContext(), (int)side);
            }
        }, 2000L);
    }

    @Override
    public void next() {
        if (!TextUtils.isEmpty((CharSequence)this.faceImg) && this.id != null) {
            if (TextUtils.isEmpty((CharSequence)this.id.getName()) && this.ocrCompany.equals("\u5b89\u8363")) {
                this.scan(1);
                return;
            }
            if (TextUtils.isEmpty((CharSequence)this.id.getIssueOffice())) {
                if (this.ocrCompany.equals("\u5b89\u8363")) {
                    this.scan(2);
                }
                return;
            }
            if (this.ocrCompany.equals("\u5b89\u8363")) {
                Bundle others = new Bundle();
                others.putString("faceImg", this.faceImg);
                others.putParcelable("identify_info", (Parcelable)this.id);
                Intent intent = new Intent((Context)this, AnrongOCRIDActivity.class);
                intent.putExtras(others);
                this.startActivity(intent);
            } else if (this.ocrCompany.equals("\u4fe1\u5927\u6377\u5b89")) {
                Bundle others = new Bundle();
                others.putString("faceImg", this.faceImg);
                others.putParcelable("identify_info", (Parcelable)this.id);
                Intent intent = new Intent((Context)this, XDJAOCRIDCardActivity.class);
                others.putInt("containerNum", this.containerNum);
                intent.putExtras(others);
                this.startActivity(intent);
            }
        }
    }

    @Subscribe
    public void handleClearID(ClearIDEvent event) {
        this.id = null;
        this.id = new IDCardInfo();
    }

    protected boolean isOCRActivity() {
        return true;
    }

    @Subscribe
    public void handleChooseBindway(ChooseBindwayEvent event) {
        this.finish();
    }

    @Subscribe
    public void handleFinishActivity(FinishActivity event) {
        this.finish();
    }

    @Subscribe
    public void handleInvokeXDJAOCREvent(InvokeXDJAOCREvent event) {
        this.startXDJAOCR();
    }

    private void startXDJAOCR() {
        if (XDJAOCR.isInstall((Context)this)) {
            if (XDJAOCR.isVersionOK((Context)this)) {
                try {
                    Intent intent = new Intent("com.xdja.zdsb.newsfzsb.action");
                    intent.putExtra("packagename", this.getPackageName());
                    intent.putExtra("sfzbs", 2);
                    this.startActivityForResult(intent, 11);
                }
                catch (Exception e) {
                    ModuleToast.show((Context)this, (int)R.string.not_install_xdja_ocr);
                }
            } else {
                this.showInstallOCRDialog();
            }
        } else {
            this.showInstallOCRDialog();
        }
    }

    private void showInstallOCRDialog() {
        final BindIdentifyDialog bindIdentifyDialog = new BindIdentifyDialog((Context)this);
        bindIdentifyDialog.setTitle(R.string.cert_creation_install_confirm_notice);
        bindIdentifyDialog.setMessage(R.string.cert_creation_install_message);
        bindIdentifyDialog.setModel(2);
        bindIdentifyDialog.setNegativeButtonText(R.string.cert_creation_cancel);
        bindIdentifyDialog.setPositiveButtonText(R.string.cert_creation_ok);
        bindIdentifyDialog.setCancelable(false);
        bindIdentifyDialog.setCanceledOnTouchOutside(false);
        bindIdentifyDialog.show();
        bindIdentifyDialog.setClickListener(new BindIdentifyDialog.ClickListenerInterface(){

            public void doConfirm() {
                if (XDJAOCR.apkFileExist()) {
                    XDJAOCR.install((Context)ChooseBindWayActivity.this.getContext(), (boolean)true);
                    bindIdentifyDialog.dismiss();
                } else {
                    XDJAOCR.copyFileTellMe((Context)ChooseBindWayActivity.this.getContext());
                    bindIdentifyDialog.dismiss();
                }
            }

            public void doCancel() {
                bindIdentifyDialog.dismiss();
            }
        });
    }

    @Subscribe
    public void handleOCREvent(XDJAOCR event) {
        XDJAOCR.install((Context)this, (boolean)true);
    }
}

