/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.sync.handler;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xdja.sync.bean.common.Consts;
import com.xdja.sync.dao.BasicSyncCommonDao;
import com.xdja.sync.enums.InterfaceCodeEnum;
import com.xdja.sync.enums.TableEnum;
import com.xdja.sync.handler.ISyncHandler;
import com.xdja.sync.service.BasicInfoSyncService;
import com.xdja.sync.util.CredentialUtil;
import com.xdja.sync.util.HttpUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Component
public class AppSyncHandler
implements ISyncHandler {
    private static final Logger logger = LoggerFactory.getLogger(AppSyncHandler.class);
    @Autowired
    private BasicSyncCommonDao basicSyncCommonDao;
    @Autowired
    private BasicInfoSyncService basicInfoSyncService;
    private int pageSize = 200;
    String insertAppSql = "INSERT INTO t_sync_app (id, app_id, app_name, app_package, app_description, app_type, app_version, app_status, network_area_code, app_file_size, create_time, version_code, app_url, regionalism_Code, update_time, power_type) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    String updateAppSql = "UPDATE uas.t_sync_app SET app_name=?, app_package=?, app_description=?, app_type=?, app_version=?, app_status=?, network_area_code=?, app_file_size=?, create_time=?, version_code=?, app_url=?, update_time=?, power_type=?  where app_id = ?  and regionalism_Code = ? ";

    @Override
    public void handler(List<TableEnum> tableEnums) {
        for (TableEnum tableEnum : tableEnums) {
            if (!TableEnum.TABLE_APP.getTableName().equals(tableEnum.getTableName())) continue;
            this.syncApp();
        }
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public int syncApp() {
        int syncAppTotal = 0;
        String sql = "SELECT code FROM t_sync_regionalism WHERE status = 1";
        List<?> listRegionalismCode = this.basicSyncCommonDao.selectList(sql, null, String.class);
        if (CollectionUtils.isEmpty(listRegionalismCode)) {
            return syncAppTotal;
        }
        String localRegionalismCode = Consts.local_regionalismCode;
        String localNetworkCode = Consts.local_networkAreaCode;
        block2: for (String regionalismCode : listRegionalismCode) {
            try {
                sql = "SELECT MAX(update_time) from t_sync_app";
                Long lastUpdateTime = (Long)this.basicSyncCommonDao.selectOne(sql, null, Long.class);
                lastUpdateTime = null == lastUpdateTime ? 0L : lastUpdateTime;
                HashMap<String, Object> mapReqParam = new HashMap<String, Object>();
                int pageNo = 1;
                mapReqParam.put("pageNo", pageNo);
                mapReqParam.put("pageSize", Consts.SYNC_DEFAULT_PAGE_SIZE);
                mapReqParam.put("updateTime", lastUpdateTime);
                mapReqParam.put("fromRegionalismCode", localRegionalismCode);
                mapReqParam.put("appRegionalismCode", regionalismCode);
                while (true) {
                    JSONArray appList = this.queryOffsiteAppList(regionalismCode, localNetworkCode, mapReqParam);
                    for (int i = 0; i < appList.size(); ++i) {
                        JSONObject jsonObject = appList.getJSONObject(i);
                        String appId = jsonObject.getString("appId");
                        String networkAreaCode = jsonObject.getString("networkAreaCode");
                        String powerType = jsonObject.getString("powerType");
                        String appRegionalismCode = jsonObject.getString("appRegionalismCode");
                        String appName = jsonObject.getString("appName");
                        String appVersion = jsonObject.getString("appVersion");
                        int versionCode = jsonObject.getIntValue("versionCode");
                        String appLogoUrl = jsonObject.getString("appLogoUrl");
                        String appDescription = jsonObject.getString("appDescription");
                        String appType = jsonObject.getString("appType");
                        String appUrl = jsonObject.getString("appUrl");
                        String appPackage = jsonObject.getString("appPackage");
                        int appFileSize = jsonObject.getIntValue("appFileSize");
                        String appFileMD5 = jsonObject.getString("appFileMD5");
                        String updateNote = jsonObject.getString("updateNote");
                        JSONArray appPictures = jsonObject.getJSONArray("appPictures");
                        String appVideoUrl = jsonObject.getString("appVideoUrl");
                        String appVideoImage = jsonObject.getString("appVideoImage");
                        long createTime = jsonObject.getLongValue("createTime");
                        long updateTime = jsonObject.getLongValue("updateTime");
                        int appStatus = 1;
                        sql = "SELECT count(1) FROM t_sync_app  where app_id = ?  and regionalism_Code = ? ";
                        Long count = (long)((Long)this.basicSyncCommonDao.selectOne(sql, new Object[]{appId, regionalismCode}, Long.class));
                        Object[] args = null;
                        String id = UUID.randomUUID().toString().replaceAll("-", "");
                        if (!Objects.isNull(count) && count > 0L) {
                            sql = this.updateAppSql;
                            args = new Object[]{appName, appPackage, appDescription, appType, appVersion, appStatus, networkAreaCode, appFileSize, createTime, versionCode, appUrl, updateTime, powerType, appId, appRegionalismCode};
                        } else {
                            sql = this.insertAppSql;
                            args = new Object[]{id, appId, appName, appPackage, appDescription, appType, appVersion, appStatus, networkAreaCode, appFileSize, createTime, versionCode, appUrl, appRegionalismCode, updateTime, powerType};
                        }
                        this.basicSyncCommonDao.updateBySql(sql, args);
                    }
                    syncAppTotal += appList.size();
                    if (CollectionUtils.isEmpty((Collection)appList) || appList.size() < this.pageSize) {
                        if (!logger.isDebugEnabled()) continue block2;
                        logger.debug("\u672c\u6b21\u5206\u9875\u62c9\u53d6\u7684\u6570\u636e\u4e0d\u591f\u4e0b\u4e00\u6b21\u5206\u9875\uff0c\u62c9\u53d6\u7ed3\u675f");
                        continue block2;
                    }
                    mapReqParam.put("pageNo", pageNo + 1);
                }
            }
            catch (Exception e) {
                logger.error("\u540c\u6b65\u884c\u653f\u533a\u5212\u3010{}\u3011\u5e94\u7528\u5f02\u5e38", (Object)regionalismCode, (Object)e);
            }
        }
        return syncAppTotal;
    }

    private JSONArray queryOffsiteAppList(String regionalismCode, String localNetworkCode, Map<String, Object> mapReqParam) {
        JSONArray resultList;
        HttpUtils.ResponseWrap responseWrap;
        String interfaceUrl = this.basicInfoSyncService.getServiceAddress(regionalismCode, localNetworkCode, InterfaceCodeEnum.IF_MAM_SVC_01);
        if (interfaceUrl == null) {
            logger.error("\u672a\u627e\u5230\u884c\u653f\u533a\u5212\u3010{}\u3011\u7684\u5e94\u7528\u7b80\u9879\u63a5\u53e3\u5730\u5740", (Object)regionalismCode);
            throw new RuntimeException("\u672a\u627e\u5230\u884c\u653f\u533a\u5212" + regionalismCode + "\u7684\u5e94\u7528\u7b80\u9879\u63a5\u53e3\u5730\u5740");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("\u884c\u653f\u533a\u5212\u3010{}\u3011\u7684\u5e94\u7528\u7b80\u9879\u63a5\u53e3\u5730\u5740:\u3010{}\u3011", (Object)regionalismCode, (Object)interfaceUrl);
        }
        if ((responseWrap = HttpUtils.createPost(interfaceUrl).addHeader(Consts.MESSAGE_ID, UUID.randomUUID().toString().replaceAll("-", "")).addHeader(Consts.APP_CREDENTIAL, CredentialUtil.getSodAppCredential()).addHeader(Consts.USER_CREDENTIAL, CredentialUtil.getSodUserCredential()).addJsonBody(mapReqParam).execute()) == null) {
            logger.error("\u62c9\u53d6\u5f02\u5730\u3010{}\u3011\u5e94\u7528\u5217\u8868\u5f02\u5e38,\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a", (Object)regionalismCode);
            throw new RuntimeException("\u62c9\u53d6\u5f02\u5730\u5e94\u7528\u5217\u8868\u5f02\u5e38,\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a");
        }
        if (200 != responseWrap.statusCode()) {
            logger.error("\u62c9\u53d6\u5f02\u5730\u3010{}\u3011\u5e94\u7528\u5217\u8868\u5f02\u5e38,\u8fd4\u56deHTTP\u72b6\u6001\u7801\u3010{}\u3011, \u8fd4\u56de\u5185\u5bb9\u3010{}\u3011", new Object[]{regionalismCode, responseWrap.statusCode(), responseWrap.getString()});
            throw new RuntimeException(String.format("\u62c9\u53d6\u5e94\u7528\u5217\u8868\u5f02\u5e38,\u8fd4\u56deHTTP\u72b6\u6001\u7801 %s, \u8fd4\u56de\u5185\u5bb9%s", responseWrap.statusCode(), responseWrap.getString()));
        }
        String code = responseWrap.getHeaderValue(Consts.CODE);
        if (!String.valueOf(Consts.SUCCESS_CODE).equals(code)) {
            logger.error("\u62c9\u53d6\u5f02\u5730\u3010{}\u3011\u5e94\u7528\u5217\u8868\u5f02\u5e38,\u8fd4\u56de\u72b6\u6001\u7801\u3010{}\u3011, \u8fd4\u56de\u9519\u8bef\u6d88\u606f\u3010{}\u3011", new Object[]{regionalismCode, code, responseWrap.getHeaderValue(Consts.MESSAGE)});
            throw new RuntimeException(String.format("\u62c9\u53d6\u5f02\u5730\u5e94\u7528\u5217\u8868\u5931\u8d25,\u8fd4\u56de\u72b6\u6001\u7801 %s, \u8fd4\u56de\u9519\u8bef\u6d88\u606f%s", code, responseWrap.getHeaderValue(Consts.MESSAGE)));
        }
        try {
            JSONObject result = (JSONObject)JSON.toJavaObject((JSON)JSON.parseObject((String)responseWrap.getString()), JSONObject.class);
            resultList = result.getJSONArray("roamAppList");
        }
        catch (Exception e) {
            logger.error("\u63a5\u6536\u62c9\u53d6\u5f02\u5730\u3010{}\u3011\u5e94\u7528\u5217\u8868\u7ed3\u679c\u8f6c\u5316\u5f02\u5e38,\u539f\u6570\u636e\u3010{}\u3011", (Object)regionalismCode, (Object)responseWrap.getString());
            throw new RuntimeException("\u63a5\u6536\u62c9\u53d6\u5f02\u5730\u5e94\u7528\u5217\u8868\u7ed3\u679c\u8f6c\u5316\u5f02\u5e38, \u539f\u6570\u636e\uff1a" + responseWrap.getString());
        }
        for (int i = 0; i < resultList.size(); ++i) {
            JSONObject simpleApp = resultList.getJSONObject(i);
            String appId = simpleApp.getString("appId");
            try {
                JSONObject detail = this.httpQueryAppDetail(appId, regionalismCode, localNetworkCode);
                if (Objects.isNull(detail)) continue;
                simpleApp.putAll((Map)detail);
                continue;
            }
            catch (Exception e) {
                logger.error("\u83b7\u53d6\u5f02\u5730regionalismCode:\u3010{}\u3011\u5e94\u7528appId:\u3010{}\u3011\u8be6\u60c5\u5931\u8d25:", new Object[]{regionalismCode, appId, e});
            }
        }
        return resultList;
    }

    private JSONObject httpQueryAppDetail(String appId, String regionalismCode, String localNetworkCode) {
        JSONObject result;
        String interfaceUrl = this.basicInfoSyncService.getServiceAddress(regionalismCode, localNetworkCode, InterfaceCodeEnum.IF_MAM_SVC_02);
        if (interfaceUrl == null) {
            logger.error("\u672a\u627e\u5230\u884c\u653f\u533a\u5212" + regionalismCode + "\u7684\u5e94\u7528\u8be6\u60c5\u63a5\u53e3\u5730\u5740");
            throw new RuntimeException("\u672a\u627e\u5230\u884c\u653f\u533a\u5212" + regionalismCode + "\u7684\u5e94\u7528\u8be6\u60c5\u63a5\u53e3\u5730\u5740");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("\u884c\u653f\u533a\u5212\u3010{}\u3011\u7684\u5e94\u7528\u8be6\u60c5\u63a5\u53e3\u5730\u5740:\u3010{}\u3011", (Object)regionalismCode, (Object)interfaceUrl);
        }
        HttpUtils.ResponseWrap responseWrap = null;
        HashMap<String, String> query = new HashMap<String, String>();
        query.put("appId", appId);
        query.put("appRegionalismCode", regionalismCode);
        responseWrap = HttpUtils.createPost(interfaceUrl).addHeader(Consts.MESSAGE_ID, UUID.randomUUID().toString().replace("-", "")).addHeader(Consts.APP_CREDENTIAL, CredentialUtil.getSodAppCredential()).addHeader(Consts.USER_CREDENTIAL, CredentialUtil.getSodUserCredential()).addJsonBody(query).execute();
        if (responseWrap == null) {
            logger.error("\u62c9\u53d6\u5f02\u5730\u3010{}\u3011\u6f2b\u6e38\u5e94\u7528\u3010{}\u3011\u8be6\u60c5\u5f02\u5e38,\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a, \u8bf7\u68c0\u67e5\u5730\u5740\u3010{}\u3011\u7f51\u7edc\u662f\u5426\u7545\u901a", new Object[]{regionalismCode, appId, interfaceUrl});
            throw new RuntimeException(String.format("\u62c9\u53d6\u5f02\u5730%s\u6f2b\u6e38\u5e94\u7528%s\u8be6\u60c5\u5f02\u5e38,\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a, \u8bf7\u68c0\u67e5\u5730\u5740%s\u7f51\u7edc\u662f\u5426\u7545\u901a", regionalismCode, appId, interfaceUrl));
        }
        if (200 != responseWrap.statusCode()) {
            logger.error("\u62c9\u53d6\u5f02\u5730\u3010{}\u3011\u6f2b\u6e38\u5e94\u7528\u3010{}\u3011\u8be6\u60c5\u5f02\u5e38,\u8fd4\u56deHTTP\u72b6\u6001\u7801 \u3010{}\u3011, \u8fd4\u56de\u5185\u5bb9\u3010{}\u3011", new Object[]{regionalismCode, appId, responseWrap.statusCode(), responseWrap.getString()});
            throw new RuntimeException(String.format("\u62c9\u53d6\u5f02\u5730%s\u6f2b\u6e38\u5e94\u7528%s\u8be6\u60c5\u5f02\u5e38,\u8fd4\u56deHTTP\u72b6\u6001\u7801 %s, \u8fd4\u56de\u5185\u5bb9%s", regionalismCode, appId, responseWrap.statusCode(), responseWrap.getString()));
        }
        String code = responseWrap.getHeaderValue(Consts.CODE);
        if (!String.valueOf(Consts.SUCCESS_CODE).equals(code)) {
            logger.error("\u62c9\u53d6\u5f02\u5730\u3010{}\u3011\u6f2b\u6e38\u5e94\u7528\u3010{}\u3011\u8be6\u60c5\u4e1a\u52a1\u5931\u8d25,\u8fd4\u56de\u4e1a\u52a1\u72b6\u6001\u7801 \u3010{}\u3011, \u8fd4\u56de\u9519\u8bef\u6d88\u606f\u3010{}\u3011", new Object[]{regionalismCode, appId, code, responseWrap.getHeaderValue(Consts.MESSAGE)});
            throw new RuntimeException(String.format("\u62c9\u53d6\u5f02\u5730%s\u6f2b\u6e38\u5e94\u7528%s\u8be6\u60c5\u4e1a\u52a1\u5931\u8d25,\u8fd4\u56de\u4e1a\u52a1\u72b6\u6001\u7801 %s, \u8fd4\u56de\u9519\u8bef\u6d88\u606f%s", regionalismCode, appId, code, responseWrap.getHeaderValue(Consts.MESSAGE)));
        }
        try {
            result = (JSONObject)JSON.toJavaObject((JSON)JSON.parseObject((String)responseWrap.getString()), JSONObject.class);
        }
        catch (Exception e) {
            logger.error("\u63a5\u6536\u62c9\u53d6\u5f02\u5730\u3010{}\u3011\u6f2b\u6e38\u5e94\u7528\u3010{}\u3011\u8be6\u60c5\u7ed3\u679c\u8f6c\u5316\u5f02\u5e38\uff0c\u539f\u6570\u636e\uff1a\u3010{}\u3011", new Object[]{regionalismCode, appId, responseWrap.getString()});
            throw new RuntimeException(String.format("\u63a5\u6536\u62c9\u53d6\u5f02\u5730%s\u6f2b\u6e38\u5e94\u7528%s\u8be6\u60c5\u7ed3\u679c\u8f6c\u5316\u5f02\u5e38\uff0c\u539f\u6570\u636e\uff1a%s", regionalismCode, appId, responseWrap.getString()));
        }
        return result;
    }

    @Override
    public List<TableEnum> supportType(TableEnum ... tableEnums) {
        ArrayList<TableEnum> listTableEnum = new ArrayList<TableEnum>();
        for (TableEnum tableEnum : tableEnums) {
            if (TableEnum.TABLE_APP != tableEnum) continue;
            listTableEnum.add(tableEnum);
        }
        return listTableEnum;
    }
}

