/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.sync.handler;

import com.xdja.sync.bean.common.Consts;
import com.xdja.sync.dao.BasicSyncCommonDao;
import com.xdja.sync.enums.TableEnum;
import com.xdja.sync.handler.AppSyncHandler;
import com.xdja.sync.handler.CcmSyncHandler;
import com.xdja.sync.handler.PamsSyncHandler;
import com.xdja.sync.handler.ResourceSyncHandler;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component
public class ExecuteScheduleSyncHandler
implements ApplicationContextAware {
    private static final Logger logger = LoggerFactory.getLogger(ExecuteScheduleSyncHandler.class);
    private ApplicationContext applicationContext;
    @Autowired
    private CcmSyncHandler ccmSyncHandler;
    @Autowired
    private PamsSyncHandler pamsSyncHandler;
    @Autowired
    private AppSyncHandler appSyncHandler;
    @Autowired
    private ResourceSyncHandler resourceSyncHandler;
    @Autowired
    private BasicSyncCommonDao basicSyncCommonDao;
    private static AtomicInteger atomicInteger = new AtomicInteger(1);
    private static ScheduledExecutorService executorService;

    public void run(TableEnum ... tableEnums) {
        tableEnums = null == tableEnums ? TableEnum.values() : tableEnums;
        this.checkRequireTableSchema(tableEnums);
        int threadCount = 0;
        List<TableEnum> listCcmTableEnum = this.ccmSyncHandler.supportType(tableEnums);
        threadCount += null == listCcmTableEnum && listCcmTableEnum.isEmpty() ? 0 : 1;
        List<TableEnum> listPamsTableEnum = this.pamsSyncHandler.supportType(tableEnums);
        threadCount += null == listPamsTableEnum && listPamsTableEnum.isEmpty() ? 0 : 1;
        List<TableEnum> listAppTableEnum = this.appSyncHandler.supportType(tableEnums);
        threadCount += null == listAppTableEnum && listAppTableEnum.isEmpty() ? 0 : 1;
        List<TableEnum> listResourceTableEnum = this.resourceSyncHandler.supportType(tableEnums);
        ExecuteScheduleSyncHandler.initScheduledThread(threadCount += null == listResourceTableEnum && listResourceTableEnum.isEmpty() ? 0 : 1);
        if (null != listCcmTableEnum && listCcmTableEnum.size() > 0) {
            executorService.scheduleAtFixedRate(() -> {
                try {
                    this.ccmSyncHandler.handler(listCcmTableEnum);
                }
                catch (Exception e) {
                    logger.error("\u540c\u6b65ccm\u6570\u636e\u5f02\u5e38:", (Throwable)e);
                }
            }, 10L, 300L, TimeUnit.SECONDS);
        }
        if (null != listPamsTableEnum && listPamsTableEnum.size() > 0) {
            executorService.scheduleAtFixedRate(() -> {
                try {
                    this.pamsSyncHandler.handler(listPamsTableEnum);
                }
                catch (Exception e) {
                    logger.error("\u540c\u6b65pams\u6570\u636e\u5f02\u5e38:", (Throwable)e);
                }
            }, 10L, 600L, TimeUnit.SECONDS);
        }
        if (null != listAppTableEnum && listAppTableEnum.size() > 0) {
            executorService.scheduleAtFixedRate(() -> {
                try {
                    this.appSyncHandler.handler(listAppTableEnum);
                }
                catch (Exception e) {
                    logger.error("\u540c\u6b65\u5e94\u7528\u6570\u636e\u5f02\u5e38:", (Throwable)e);
                }
            }, 10L, 300L, TimeUnit.SECONDS);
        }
        if (null != listResourceTableEnum && listResourceTableEnum.size() > 0) {
            executorService.scheduleAtFixedRate(() -> {
                try {
                    this.resourceSyncHandler.handler(listResourceTableEnum);
                }
                catch (Exception e) {
                    logger.error("\u540c\u6b65\u8d44\u6e90\u6570\u636e\u5f02\u5e38:", (Throwable)e);
                }
            }, 10L, 300L, TimeUnit.SECONDS);
        }
    }

    private void checkRequireTableSchema(TableEnum[] tableEnums) {
        try {
            String sql = "SELECT table_name FROM information_schema.TABLES WHERE table_schema = (SELECT DATABASE())";
            List<?> listDbTableName = this.basicSyncCommonDao.selectList(sql, null, String.class);
            Map<String, String> mapDbAllTableName = listDbTableName.stream().collect(Collectors.toMap(s -> s.toLowerCase(), s -> s.toLowerCase()));
            for (TableEnum tableEnum : tableEnums) {
                String tableName = tableEnum.getTableName();
                if (mapDbAllTableName.containsKey(tableName)) continue;
                InputStream inputStream = ExecuteScheduleSyncHandler.class.getClassLoader().getResourceAsStream(tableName + ".sql");
                sql = IOUtils.toString((InputStream)inputStream, (String)"utf-8");
                this.basicSyncCommonDao.updateBySql(sql, null);
            }
        }
        catch (Exception e) {
            logger.error("\u6821\u9a8c\u8868\u7ed3\u6784\u5931\u8d25", (Throwable)e);
        }
    }

    private static void initScheduledThread(int num) {
        executorService = new ScheduledThreadPoolExecutor(num, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = new Thread(r);
                thread.setName("basic-info-sync-thread-" + atomicInteger.getAndIncrement());
                thread.setDaemon(true);
                return thread;
            }
        }, new ThreadPoolExecutor.CallerRunsPolicy());
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
        Consts.applicationContext = applicationContext;
    }
}

