/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.sync.handler;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xdja.sync.bean.common.Consts;
import com.xdja.sync.dao.BasicSyncCommonDao;
import com.xdja.sync.enums.TableEnum;
import com.xdja.sync.handler.ISyncHandler;
import com.xdja.sync.util.HttpUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Component
public class PamsSyncHandler
implements ISyncHandler {
    private static final Logger logger = LoggerFactory.getLogger(PamsSyncHandler.class);
    @Autowired
    private BasicSyncCommonDao basicSyncCommonDao;
    private static String insertDeptSql = "INSERT INTO t_sync_department  (ID, AMOUNT, CODE, CONTACT, DEP_ABB, DEP_TYPE, DIRECT, DISPLAY_STATE, FLAG, GRADE, N_LAST_UPDATE_TIME, NAME, NOTE, ORDER_FIELD, PARENT_ID, PHONE, TREE_CODE, TREE_ID, parent_code)  VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    private static String updateDeptSql = "UPDATE t_sync_department SET AMOUNT=?, CODE=?, CONTACT=?, DEP_ABB=?, DEP_TYPE=?, DIRECT=?, DISPLAY_STATE=?, FLAG=?, GRADE=?, N_LAST_UPDATE_TIME=?, NAME=?, NOTE=?, ORDER_FIELD=?, PARENT_ID=?, PHONE=?, TREE_CODE=?, TREE_ID=?, parent_code=? WHERE ID=?";
    private static String insertPersonSql = "INSERT INTO t_sync_person (id, name, name_brief_spell, sex, code, identifier, dep_id, dep_code, position, position_input, office_phone, note, police, smobile, order_Field, flag, n_last_update_time)  VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    private static String updatePersonSql = "UPDATE t_sync_person SET name=?, name_brief_spell=?, sex=?, code=?, identifier=?, dep_id=?, dep_code=?, position=?, position_input=?, office_phone=?, note=?, police=?, smobile=?, order_Field=?, flag=?, n_last_update_time=? WHERE id=?";
    private int pageSize = 200;
    private String dept_uri = TableEnum.TABLE_DEPARTMENT.getUri();
    private String person_uri = TableEnum.TABLE_PERSON.getUri();

    @Override
    @Transactional
    public void handler(List<TableEnum> tableEnums) {
        for (TableEnum tableEnum : tableEnums) {
            String uri = tableEnum.getUri();
            String tableName = tableEnum.getTableName();
            if (this.dept_uri.equals(uri)) {
                this.syncDept();
                continue;
            }
            if (!this.person_uri.equals(uri)) continue;
            this.syncPerson();
        }
        this.updatePersonTreeIdCode();
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public int syncPerson() {
        String url = Consts.pamsServerUrl + this.person_uri;
        String sql = "select max(n_last_update_time) from t_sync_person";
        Long lastUpdateTime = (Long)this.basicSyncCommonDao.selectOne(sql, null, Long.class);
        lastUpdateTime = null == lastUpdateTime ? 0L : lastUpdateTime;
        logger.debug("\u540c\u6b65pams\u5355\u4f4d\u63a5\u53e3\u7684url\u4e3a:{}, \u4e0a\u6b21\u66f4\u65b0\u6700\u5927\u65f6\u95f4\u6233", (Object)url, (Object)lastUpdateTime);
        JSONArray interfaceDetailList = this.pullPamsData(lastUpdateTime, 1, this.pageSize, url);
        if (CollectionUtils.isEmpty((Collection)interfaceDetailList)) {
            logger.debug("\u672c\u6b21\u7ea7\u8054\u63a5\u53e3\u6ca1\u6709\u66f4\u65b0");
            return 0;
        }
        int pageNum = 1;
        int pageSize = 200;
        JSONArray listDeptResult = new JSONArray();
        while (true) {
            logger.debug("\u4ecepams\u62c9\u53d6\u7b2c{}\u9875\u5355\u4f4d>>>", (Object)pageNum);
            interfaceDetailList = this.pullPamsData(lastUpdateTime, pageNum, pageSize, url);
            logger.debug("\u4ecepams\u62c9\u53d6\u7b2c{}\u9875\u5355\u4f4d<<<", (Object)pageNum);
            if (!CollectionUtils.isEmpty((Collection)interfaceDetailList)) {
                listDeptResult.addAll((Collection)interfaceDetailList);
            }
            if (CollectionUtils.isEmpty((Collection)interfaceDetailList) || interfaceDetailList.size() < pageSize) break;
            ++pageNum;
        }
        logger.debug("\u672c\u6b21\u5171\u540c\u6b65\u5230{}\u6761\u7ea7\u8054\u63a5\u53e3", (Object)listDeptResult.size());
        try {
            String selectOneSql = "SELECT count(1) FROM t_sync_person where id = ?";
            for (int i = 0; i < listDeptResult.size(); ++i) {
                JSONObject jsonObject = listDeptResult.getJSONObject(i);
                String id = jsonObject.getString("id");
                String name = jsonObject.getString("name");
                String nameBriefSpell = jsonObject.getString("name_brief_spell");
                String code = jsonObject.getString("code");
                String depCode = jsonObject.getString("dep_code");
                String depId = jsonObject.getString("dep_id");
                String sex = jsonObject.getString("sex");
                String personType = jsonObject.getString("personType");
                String orderField = jsonObject.getString("seq");
                String police = jsonObject.getString("police");
                String grade = jsonObject.getString("grade");
                String position = jsonObject.getString("position");
                String commType = jsonObject.getString("comm_type");
                String identifier = jsonObject.getString("identifier");
                String mobile = jsonObject.getString("mobile");
                String leaderLevel = jsonObject.getString("leaderLevel");
                String displayFlag = jsonObject.getString("display_flag");
                String flag = jsonObject.getString("delete_flag");
                String lastUpdateTime1 = jsonObject.getString("n_last_update_time");
                String job = jsonObject.getString("job");
                String note = jsonObject.getString("note");
                String officePhone = jsonObject.getString("officePhone");
                String mobilePersonal = jsonObject.getString("mobilePersonal");
                String mobileMultimediaMessage = jsonObject.getString("mobileMultimediaMessage");
                String jxFlag = jsonObject.getString("jxFlag");
                Long count = (Long)this.basicSyncCommonDao.selectOne(selectOneSql, new Object[]{id}, Long.class);
                Object[] args = null;
                if (!Objects.isNull(count) && count > 0L) {
                    sql = updatePersonSql;
                    args = new Object[]{name, nameBriefSpell, sex, code, identifier, depId, depCode, position, position, officePhone, note, police, mobile, orderField, flag, lastUpdateTime1, id};
                } else {
                    sql = insertPersonSql;
                    args = new Object[]{id, name, nameBriefSpell, sex, code, identifier, depId, depCode, position, position, officePhone, note, police, mobile, orderField, flag, lastUpdateTime1};
                }
                this.basicSyncCommonDao.updateBySql(sql, args);
            }
        }
        catch (Throwable e) {
            logger.error("\u4ecepams\u540c\u6b65\u5355\u4f4d\u6570\u636e\u51fa\u9519,", e);
        }
        return listDeptResult.size();
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public int syncDept() {
        String url = Consts.pamsServerUrl + this.dept_uri;
        String sql = "select max(n_last_update_time) from t_sync_department";
        Long lastUpdateTime = (Long)this.basicSyncCommonDao.selectOne(sql, null, Long.class);
        lastUpdateTime = null == lastUpdateTime ? 0L : lastUpdateTime;
        logger.debug("\u540c\u6b65pams\u5355\u4f4d\u63a5\u53e3\u7684url\u4e3a:{}, \u4e0a\u6b21\u66f4\u65b0\u6700\u5927\u65f6\u95f4\u6233", (Object)url, (Object)lastUpdateTime);
        JSONArray interfaceDetailList = this.pullPamsData(lastUpdateTime, 1, this.pageSize, url);
        if (CollectionUtils.isEmpty((Collection)interfaceDetailList)) {
            logger.debug("\u672c\u6b21\u7ea7\u8054\u63a5\u53e3\u6ca1\u6709\u66f4\u65b0");
            return 0;
        }
        int pageNum = 1;
        int pageSize = 200;
        JSONArray listDeptResult = new JSONArray();
        while (true) {
            logger.debug("\u4ecepams\u62c9\u53d6\u7b2c{}\u9875\u5355\u4f4d>>>", (Object)pageNum);
            interfaceDetailList = this.pullPamsData(lastUpdateTime, pageNum, pageSize, url);
            logger.debug("\u4ecepams\u62c9\u53d6\u7b2c{}\u9875\u5355\u4f4d<<<", (Object)pageNum);
            if (!CollectionUtils.isEmpty((Collection)interfaceDetailList)) {
                listDeptResult.addAll((Collection)interfaceDetailList);
            }
            if (CollectionUtils.isEmpty((Collection)interfaceDetailList) || interfaceDetailList.size() < pageSize) break;
            ++pageNum;
        }
        logger.debug("\u672c\u6b21\u5171\u540c\u6b65\u5230{}\u6761\u7ea7\u8054\u63a5\u53e3", (Object)listDeptResult.size());
        try {
            String selectOneSql = "SELECT count(1) FROM t_sync_department where id = ?";
            for (int i = 0; i < listDeptResult.size(); ++i) {
                JSONObject jsonObject = listDeptResult.getJSONObject(i);
                String id = jsonObject.getString("id");
                String parentId = jsonObject.getString("parent_id");
                String name = jsonObject.getString("name");
                String code = jsonObject.getString("code");
                String parentCode = jsonObject.getString("parent_code");
                String depAbb = jsonObject.getString("dep_abb");
                String grade = jsonObject.getString("grade");
                String orderField = jsonObject.getString("seq");
                String displayFlag = jsonObject.getString("display_flag");
                String flag = jsonObject.getString("delete_flag");
                String lastUpdateTime1 = jsonObject.getString("n_last_update_time");
                String phone = jsonObject.getString("phone");
                String treeId = jsonObject.getString("treeId");
                String treeCode = jsonObject.getString("treeCode");
                String amount = jsonObject.getString("amount");
                Long count = (Long)this.basicSyncCommonDao.selectOne(selectOneSql, new Object[]{id}, Long.class);
                Object[] args = null;
                if (!Objects.isNull(count) && count > 0L) {
                    sql = updateDeptSql;
                    args = new Object[]{amount, code, phone, depAbb, "org", "0", displayFlag, flag, grade, lastUpdateTime1, name, "", orderField, parentId, phone, treeCode, treeId, parentCode, id};
                } else {
                    sql = insertDeptSql;
                    args = new Object[]{id, amount, code, phone, depAbb, "org", "0", displayFlag, flag, grade, lastUpdateTime1, name, "", orderField, parentId, phone, treeCode, treeId, parentCode};
                }
                this.basicSyncCommonDao.updateBySql(sql, args);
            }
        }
        catch (Throwable e) {
            logger.error("\u4ecepams\u540c\u6b65\u5355\u4f4d\u6570\u636e\u51fa\u9519,", e);
        }
        return listDeptResult.size();
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void updatePersonTreeIdCode() {
        String sql = "update t_sync_person p, t_sync_department d set p.tree_id = d.tree_id, p.tree_code = d.tree_code where p.dep_id = d.id";
        this.basicSyncCommonDao.updateBySql(sql, null);
    }

    public JSONArray pullPamsData(Long dataMaxVersion, int pageNo, int pageSize, String url) {
        JSONArray listPamsData = new JSONArray();
        HashMap<String, String> requestParam = new HashMap<String, String>(4);
        requestParam.put("thirdId", Consts.systemName);
        requestParam.put("lastTime", dataMaxVersion == null ? "0" : String.valueOf(dataMaxVersion));
        requestParam.put("pageNo", pageNo + "");
        requestParam.put("pageSize", pageSize + "");
        HttpUtils.ResponseWrap responseWrap = null;
        try {
            responseWrap = HttpUtils.createForm(url).addParameters(requestParam).execute();
            if (responseWrap == null) {
                logger.error("\u62c9\u53d6\u4e92\u901a\u4e2d\u5fc3\u4e1a\u52a1\u4ee3\u7801\u5f02\u5e38,\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a");
                return listPamsData;
            }
            if (200 != responseWrap.statusCode()) {
                logger.error("\u62c9\u53d6\u4e92\u901a\u4e2d\u5fc3\u4e1a\u52a1\u4ee3\u7801\u5f02\u5e38,\u8fd4\u56de\u72b6\u6001\u7801" + responseWrap.statusCode());
                return listPamsData;
            }
        }
        catch (Exception e) {
            logger.error("\u62c9\u53d6\u4e92\u901a\u4e2d\u5fc3\u4e1a\u52a1\u4ee3\u7801\u5f02\u5e38" + e.getMessage(), (Throwable)e);
            return listPamsData;
        }
        try {
            String json = responseWrap.getString();
            JSONObject jsonObject = JSONObject.parseObject((String)json);
            String flag = jsonObject.getJSONObject("result").getString("flag");
            if (!"0".equals(flag)) {
                logger.error("\u4ecepams\u62c9\u53d6\u90e8\u95e8\u4fe1\u606f\u5931\u8d25");
                return listPamsData;
            }
            listPamsData = jsonObject.getJSONArray("list");
        }
        catch (Exception e) {
            logger.error("\u63a5\u6536\u7684\u8d44\u6e90\u4e1a\u52a1\u7c7b\u578b\u7ed3\u679c\u8f6c\u5316\u5f02\u5e38" + e.getMessage(), (Throwable)e);
        }
        return listPamsData;
    }

    @Override
    public List<TableEnum> supportType(TableEnum ... tableEnums) {
        ArrayList<TableEnum> listTableEnum = new ArrayList<TableEnum>();
        for (TableEnum tableEnum : tableEnums) {
            if (TableEnum.TABLE_PERSON != tableEnum && TableEnum.TABLE_DEPARTMENT != tableEnum) continue;
            listTableEnum.add(tableEnum);
        }
        return listTableEnum;
    }
}

