/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.sync.init;

import com.xdja.sync.bean.common.Consts;
import com.xdja.sync.enums.NetworkAreaCodeEnum;
import com.xdja.sync.enums.SystemEnum;
import com.xdja.sync.enums.TableEnum;
import com.xdja.sync.handler.ExecuteScheduleSyncHandler;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicInfoSyncSystemInit {
    private static final Logger logger = LoggerFactory.getLogger(BasicInfoSyncSystemInit.class);
    private static volatile boolean isRunning = false;
    private static final long DEFAULT_PERIOD = 300L;

    public static void init(@NotNull SystemEnum systemEnum, @NotNull String regionalismCode, @NotNull NetworkAreaCodeEnum networkAreaCodeEnum, @NotNull String pamsServerUrl, @NotNull String ccmServerUrl) {
        BasicInfoSyncSystemInit.init(systemEnum, regionalismCode, networkAreaCodeEnum, pamsServerUrl, ccmServerUrl, TableEnum.values());
    }

    public static void init(@NotNull SystemEnum systemEnum, @NotNull String regionalismCode, @NotNull NetworkAreaCodeEnum networkAreaCodeEnum, @NotNull String pamsServerUrl, @NotNull String ccmServerUrl, TableEnum ... tableEnums) {
        BasicInfoSyncSystemInit.init(systemEnum, regionalismCode, networkAreaCodeEnum, pamsServerUrl, ccmServerUrl, null, null, null, tableEnums);
    }

    public static void init(@NotNull SystemEnum systemEnum, @NotNull String regionalismCode, @NotNull NetworkAreaCodeEnum networkAreaCodeEnum, @NotNull String pamsServerUrl, @NotNull String ccmServerUrl, String redisHost, Integer redisPort, String redisPassword, TableEnum ... tableEnums) {
        BasicInfoSyncSystemInit.init(systemEnum, regionalismCode, networkAreaCodeEnum, pamsServerUrl, 300L, TimeUnit.SECONDS, ccmServerUrl, 300L, TimeUnit.SECONDS, null, null, null, tableEnums);
    }

    public static void init(@NotNull SystemEnum systemEnum, @NotNull String regionalismCode, @NotNull NetworkAreaCodeEnum networkAreaCodeEnum, @NotNull String pamsServerUrl, long pamsPeriod, TimeUnit pamsPeriodUnit, @NotNull String ccmServerUrl, long ccmPeriod, TimeUnit ccmPeriodUnit, String redisHost, Integer redisPort, String redisPassword, TableEnum ... tableEnums) {
        if (isRunning) {
            logger.error("\u540c\u6b65\u7a0b\u5e8f\u5df2\u7ecf\u542f\u52a8,\u8bf7\u52ff\u91cd\u590d\u542f\u52a8");
            throw new RuntimeException("\u540c\u6b65\u7a0b\u5e8f\u5df2\u7ecf\u542f\u52a8,\u8bf7\u52ff\u91cd\u590d\u542f\u52a8");
        }
        isRunning = true;
        Objects.requireNonNull(systemEnum, "\u7cfb\u7edf\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        Objects.requireNonNull(regionalismCode, "\u884c\u653f\u533a\u5212\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Objects.requireNonNull(networkAreaCodeEnum, "\u7f51\u7edc\u90e8\u7f72\u533a\u57df\u4e0d\u80fd\u4e3a\u7a7a");
        Objects.requireNonNull(pamsServerUrl, "pams\u670d\u52a1\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
        Objects.requireNonNull(ccmServerUrl, "ccm\u670d\u52a1\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
        Objects.requireNonNull(tableEnums, "\u540c\u6b65\u8868\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        Consts.systemName = systemEnum.getName();
        Consts.local_regionalismCode = regionalismCode;
        Consts.local_networkAreaCode = networkAreaCodeEnum.getCode();
        Consts.pamsServerUrl = pamsServerUrl;
        Consts.ccmServerUrl = ccmServerUrl;
        ((ExecuteScheduleSyncHandler)Consts.applicationContext.getBean(ExecuteScheduleSyncHandler.class)).run(tableEnums);
    }

    public static void main(String[] args) {
        BasicInfoSyncSystemInit.init(null, null, null, null, null, null);
    }
}

