/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.sync.util;

import com.alibaba.fastjson.JSONObject;
import com.xdja.sync.bean.common.Consts;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class CredentialUtil {
    private static Logger logger = LoggerFactory.getLogger(CredentialUtil.class);

    public static String getValueFromCredential(String credentialString, String keyTokenizer) {
        if (StringUtils.isEmpty((Object)credentialString) || StringUtils.isEmpty((Object)keyTokenizer)) {
            return null;
        }
        try {
            credentialString = URLDecoder.decode(credentialString, "UTF-8");
            String[] keyTokens = keyTokenizer.split("\\.");
            JSONObject credentialObject = JSONObject.parseObject((String)credentialString);
            for (int i = 0; i < keyTokens.length; ++i) {
                if (i == keyTokens.length - 1) {
                    return credentialObject.getString(keyTokens[i]);
                }
                credentialObject = credentialObject.getJSONObject(keyTokens[i]);
            }
        }
        catch (Exception e) {
            logger.error("\u89e3\u6790\u5e76\u83b7\u53d6\u51ed\u8bc1\u5931\u8d25,credentialString\uff1a{}, keyTokenizer : {}", (Object)credentialString, (Object)keyTokenizer);
            return null;
        }
        return null;
    }

    public static String getRegionalismCodeFromCredential(String appCredential) {
        if (StringUtils.isEmpty((Object)appCredential)) {
            return null;
        }
        return CredentialUtil.getValueFromCredential(appCredential, "credential.head.token.orgId");
    }

    public static String getAppIdFromCredential(String appCredential) {
        if (StringUtils.isEmpty((Object)appCredential)) {
            return null;
        }
        return CredentialUtil.getValueFromCredential(appCredential, "credential.load.appInfo.appId");
    }

    public static String getNetworkCodeFromCredential(String appCredential) {
        if (StringUtils.isEmpty((Object)appCredential)) {
            return null;
        }
        return CredentialUtil.getValueFromCredential(appCredential, "credential.load.appInfo.networkAreaCode");
    }

    public static String getSodAppCredential() {
        return CredentialUtil.getSodAppCredential(null, null);
    }

    public static String getSodAppCredential(String regionalismCode, String appId) {
        if (StringUtils.isEmpty((Object)appId)) {
            appId = "3532b4567eef468f9238a81db2cff0ea";
        }
        if (StringUtils.isEmpty((Object)regionalismCode)) {
            regionalismCode = Consts.local_regionalismCode;
        }
        try {
            String appCredential = "{\"credential\":{\"head\":{\"version\":\"1.0\",\"credType\":\"2\",\"token\":{\"tokenId\":\"a000000120123123123123123ec892ba\",\"orgId\":\"" + regionalismCode + "\",\"exten\":\"\"},\"duration\":{\"startTime\":\"2012312312231\",\"endTime\":\"9012312312290\"}},\"load\":{\"appInfo\":{\"appId\":\"" + appId + "\",\"orgId\":\"" + regionalismCode + "\",\"packageName\":\"com.xdja.rsb\",\"networkAreaCode\":\"3\",\"name\":\"\u5929\u6d25\u670d\u52a1\u603b\u7ebf\u540e\u53f0\",\"csType\":\"1\",\"exten\":\"\"}},\"serverSign\":{\"alg\":\"SM3+SM2\",\"signature\":\"b000000120123123123123123ec892ba\",\"sn\":\"1000000000100211\",\"url\":\"http://20.3.1.166/UAS/Credential.do\"},\"clientSign\":{\"alg\":\"SM3+SM2\",\"signature\":\"b000000120123123123123123ec892ba\",\"sn\":\"1000000000100001\"}}}";
            logger.info("SodAppCredential\u751f\u6210\u7684\u5e94\u7528\u51ed\u8bc1\u3010{}\u3011", (Object)appCredential);
            return URLEncoder.encode(appCredential, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            logger.error("\u751f\u6210\u5e94\u7528\u7968\u636e\u5931\u8d25", (Throwable)e);
            return null;
        }
    }

    public static String getSodUserCredential() {
        return CredentialUtil.getSodUserCredential(null, null);
    }

    public static String getSodUserCredential(String regionalismCode, String userId) {
        if (StringUtils.isEmpty((Object)regionalismCode)) {
            regionalismCode = Consts.local_regionalismCode;
        }
        if (StringUtils.isEmpty((Object)userId)) {
            userId = "b000000120123123123123123ec892ba";
        }
        try {
            String userCredential = "{\"credential\":{\"head\":{\"version\":\"1.0\",\"credType\":\"1\",\"token\":{\"tokenId\":\"a000000120123123123123123ec892ba\",\"orgId\":\"" + regionalismCode + "\",\"exten\":\"\"},\"duration\":{\"startTime\":\"2012312312231\",\"endTime\":\"9012312312290\"}},\"load\":{\"userInfo\":{\"userId\":\"" + userId + "\",\"orgId\":\"" + regionalismCode + "\",\"sfzh\":\"0\",\"jh\":\"0\",\"xm\":\"admin\",\"exten\":\"\"}},\"serverSign\":{\"alg\":\"SM3+SM2\",\"signature\":\"b000000120123123123123123ec892ba\",\"sn\":\"1000000000100211\",\"url\":\"http://20.3.1.166/UAS/Credential.do\"},\"clientSign\":{\"alg\":\"SM3+SM2\",\"signature\":\"b000000120123123123123123ec892ba\",\"sn\":\"1000000000100001\"}}}";
            logger.info("SodUserCredential\u751f\u6210\u7684\u7528\u6237\u51ed\u8bc1\u3010{}\u3011", (Object)userCredential);
            return URLEncoder.encode(userCredential, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            logger.error("\u751f\u6210\u7528\u6237\u7968\u636e\u5931\u8d25", (Throwable)e);
            return null;
        }
    }

    public static void main(String[] args) throws UnsupportedEncodingException {
        String regionalismCode = "410000000000";
        String appId = "3532b4567eef468f9238a81db2cff0ea";
        String sodAppCredential = CredentialUtil.getSodAppCredential(regionalismCode, appId);
        System.out.println(sodAppCredential);
        String decode = URLDecoder.decode(sodAppCredential, "utf-8");
        System.out.println(decode);
    }
}

