/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.sync.handler;

import com.xdja.sync.bean.common.Consts;
import com.xdja.sync.dao.BasicSyncCommonDao;
import com.xdja.sync.enums.TableEnum;
import com.xdja.sync.handler.AbstractSyncHandler;
import com.xdja.sync.handler.AppSyncHandler;
import com.xdja.sync.handler.CcmSyncHandler;
import com.xdja.sync.handler.PamsSyncHandler;
import com.xdja.sync.handler.ResourceSyncHandler;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component
public class ExecuteScheduleSyncHandler
implements ApplicationContextAware {
    private static final Logger logger = LoggerFactory.getLogger(ExecuteScheduleSyncHandler.class);
    private ApplicationContext applicationContext;
    @Autowired
    private CcmSyncHandler ccmSyncHandler;
    @Autowired
    private PamsSyncHandler pamsSyncHandler;
    @Autowired
    private AppSyncHandler appSyncHandler;
    @Autowired
    private ResourceSyncHandler resourceSyncHandler;
    @Autowired
    private BasicSyncCommonDao basicSyncCommonDao;
    @Autowired
    private Map<String, AbstractSyncHandler> syncHandlers;

    public void run(TableEnum ... tableEnums) {
        tableEnums = null == tableEnums ? TableEnum.values() : tableEnums;
        this.checkRequiredTableSchema(tableEnums);
        TableEnum[] finalTableEnums = tableEnums;
        this.syncHandlers.values().forEach(iSyncHandler -> iSyncHandler.doHandler(finalTableEnums));
    }

    private void checkRequiredTableSchema(TableEnum[] tableEnums) {
        try {
            String sql = "SELECT table_name FROM information_schema.TABLES WHERE table_schema = (SELECT DATABASE())";
            List<?> listDbTableName = this.basicSyncCommonDao.selectList(sql, null, String.class);
            Map<String, String> mapDbAllTableName = listDbTableName.stream().collect(Collectors.toMap(s -> s.toLowerCase(), s -> s.toLowerCase()));
            for (TableEnum tableEnum : tableEnums) {
                String tableName = tableEnum.getTableName();
                if (!(!mapDbAllTableName.containsKey(tableName) && (null != Consts.pamsServerUrl && !"".equals(Consts.pamsServerUrl) || !TableEnum.TABLE_PERSON.getTableName().equalsIgnoreCase(tableName) && !TableEnum.TABLE_DEPARTMENT.getTableName().equalsIgnoreCase(tableName)) && (null != Consts.ccmServerUrl && !"".equals(Consts.ccmServerUrl) || !TableEnum.TABLE_REGISIONALISM.getTableName().equalsIgnoreCase(tableName) && !TableEnum.TABLE_BUSINESS_TYPE.getTableName().equalsIgnoreCase(tableName) && !TableEnum.TABLE_SERVICE.getTableName().equalsIgnoreCase(tableName) && !TableEnum.TABLE_SERVICE_INTERFACE.getTableName().equalsIgnoreCase(tableName) && !TableEnum.TABLE_RESOURCE.getTableName().equalsIgnoreCase(tableName) && !TableEnum.TABLE_APP.getTableName().equalsIgnoreCase(tableName)))) continue;
                InputStream inputStream = ExecuteScheduleSyncHandler.class.getClassLoader().getResourceAsStream(tableName + ".sql");
                sql = IOUtils.toString((InputStream)inputStream, (String)"utf-8");
                this.basicSyncCommonDao.updateBySql(sql, null);
            }
        }
        catch (Exception e) {
            logger.error("\u6821\u9a8c\u8868\u7ed3\u6784\u5931\u8d25", (Throwable)e);
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
        Consts.applicationContext = applicationContext;
    }
}

