/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.sync.service.impl;

import com.alibaba.fastjson.JSON;
import com.xdja.sync.bean.Regionalism;
import com.xdja.sync.dao.BasicSyncCommonDao;
import com.xdja.sync.enums.InterfaceCodeEnum;
import com.xdja.sync.enums.NetworkAreaCodeEnum;
import com.xdja.sync.exception.SyncClientException;
import com.xdja.sync.service.BasicInfoSyncService;
import com.xdja.sync.util.HttpUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class BasicInfoSyncServiceImpl
implements BasicInfoSyncService {
    private static final Logger logger = LoggerFactory.getLogger(BasicInfoSyncServiceImpl.class);
    @Autowired
    private BasicSyncCommonDao basicSyncCommonDao;

    @Override
    public String getServiceAddress(String regionalismCode, NetworkAreaCodeEnum networkAreaCodeEnum, InterfaceCodeEnum interfaceCodeEnum) {
        String sql = "SELECT interface_url FROM t_sync_service_interface WHERE  network_area_code = ? AND regionalism_code = ? AND interface_code = ?";
        return (String)this.basicSyncCommonDao.selectOne(sql, new Object[]{networkAreaCodeEnum.getCode(), regionalismCode, interfaceCodeEnum.getCode()}, String.class);
    }

    @Override
    public String getServiceAddress(String regionalismCode, String networkAreaCode, String interfaceCode) {
        return this.getServiceAddress(regionalismCode, networkAreaCode, interfaceCode, null);
    }

    @Override
    public String getServiceAddress(String regionalismCode, String networkAreaCode, String interfaceCode, String version) {
        ArrayList<String> args = new ArrayList<String>();
        String sql = "SELECT interface_url FROM t_sync_service_interface  WHERE  network_area_code = ? AND regionalism_code = ? AND interface_code = ?";
        args.add(networkAreaCode);
        args.add(regionalismCode);
        args.add(interfaceCode);
        if (!StringUtils.isEmpty((Object)version)) {
            sql = sql + " AND version = ?";
            args.add(version);
        }
        return (String)this.basicSyncCommonDao.selectOne(sql, args.toArray(new Object[0]), String.class);
    }

    @Override
    public String getServiceAddress(String regionalismCode, String networkAreaCode, InterfaceCodeEnum interfaceCodeEnum) {
        return this.getServiceAddress(regionalismCode, networkAreaCode, interfaceCodeEnum.getCode(), null);
    }

    @Override
    public String getServiceAddress(String regionalismCode, NetworkAreaCodeEnum networkAreaCodeEnum, InterfaceCodeEnum interfaceCodeEnum, String version) {
        return this.getServiceAddress(regionalismCode, networkAreaCodeEnum.getCode(), interfaceCodeEnum.getCode(), version);
    }

    @Override
    public List<Regionalism> getRegionalismList(Integer status) {
        String sql = "SELECT * FROM t_sync_regionalism WHERE 1 = 1 ";
        ArrayList<Integer> args = new ArrayList<Integer>();
        if (!Objects.isNull(status)) {
            sql = sql + " AND status = ?";
            args.add(status);
        }
        return this.basicSyncCommonDao.selectList(sql, args.toArray(new Object[0]), Regionalism.class);
    }

    @Override
    public List<String> getRegionalismCodeList(Integer status) {
        String sql = "SELECT code FROM t_sync_regionalism WHERE 1 = 1 ";
        ArrayList<Integer> args = new ArrayList<Integer>();
        if (!Objects.isNull(status)) {
            sql = sql + " AND status = ?";
            args.add(status);
        }
        return this.basicSyncCommonDao.selectList(sql, args.toArray(new Object[0]), String.class);
    }

    @Override
    public String executeCallIF(String regionalismCode, String interfaceCode, String networkCode, String messageId, String appCredential, String userCredential, Object bodyParam) throws SyncClientException {
        String interfaceUrl = this.getServiceAddress(regionalismCode, networkCode, interfaceCode);
        if (StringUtils.isEmpty((Object)interfaceUrl)) {
            logger.error("regionalismCode\uff1a\u3010{}\u3011, interfaceCode:\u3010{}\u3011, networkCode:\u3010{}\u3011\u5bf9\u5e94\u7684\u63a5\u53e3\u5730\u5740\u4e3a\u7a7a", new Object[]{regionalismCode, interfaceCode, networkCode});
            throw SyncClientException.operateErrorException("\u884c\u653f\u533a\u5212:" + regionalismCode + ",\u63a5\u53e3\u6807\u8bc6:" + interfaceCode + ",\u7f51\u7edc\u533a\u5212:" + networkCode + ",\u5bf9\u5e94\u7684\u63a5\u53e3\u5730\u5740\u4e0d\u5b58\u5728");
        }
        HashMap<String, String> mapHeader = new HashMap<String, String>();
        mapHeader.put("messageId", StringUtils.isEmpty((Object)messageId) ? UUID.randomUUID().toString().replaceAll("-", "") : messageId);
        if (!StringUtils.isEmpty((Object)appCredential)) {
            mapHeader.put("appCredential", appCredential);
        }
        if (!StringUtils.isEmpty((Object)userCredential)) {
            mapHeader.put("userCredential", userCredential);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("\u8c03\u7528\u63a5\u53e3>>>url:\u3010{}\u3011,Header:\u3010{}\u3011,param:\u3010{}\u3011", new Object[]{interfaceUrl, JSON.toJSONString(mapHeader), Objects.isNull(bodyParam) ? "" : JSON.toJSONString((Object)bodyParam)});
        }
        HttpUtils.ResponseWrap responseWrap = HttpUtils.createPost(interfaceUrl).addHeader(mapHeader).addJsonBody(bodyParam).execute();
        String code = "";
        String message = "";
        if (responseWrap == null) {
            logger.error("\u8c03\u7528\u63a5\u53e3\u5931\u8d25:\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a,url:\u3010{}\u3011,Header:\u3010{}\u3011,param:\u3010{}\u3011", new Object[]{interfaceUrl, JSON.toJSONString(mapHeader), Objects.isNull(bodyParam) ? "" : JSON.toJSONString((Object)bodyParam)});
            throw SyncClientException.operateErrorException("\u8c03\u7528\u63a5\u53e3\u65e0\u54cd\u5e94");
        }
        if (200 != responseWrap.statusCode()) {
            logger.error("\u8c03\u7528\u63a5\u53e3\u5931\u8d25url:\u3010{}\u3011,Header:\u3010{}\u3011,param:\u3010{}\u3011,:\u8fd4\u56deHTTP\u72b6\u6001\u7801\u9519\u8bef{},", new Object[]{interfaceUrl, JSON.toJSONString(mapHeader), Objects.isNull(bodyParam) ? "" : JSON.toJSONString((Object)bodyParam), responseWrap.statusCode()});
            throw SyncClientException.operateErrorException("\u8c03\u7528\u63a5\u53e3\u5931\u8d25\u8fd4\u56destatusCode" + responseWrap.statusCode());
        }
        code = responseWrap.getHeaderValue("code");
        message = responseWrap.getHeaderValue("message");
        if (!"0".equals(code)) {
            logger.error("\u8c03\u7528\u63a5\u53e3\u5931\u8d25url:\u3010{}\u3011,Header:\u3010{}\u3011,param:\u3010{}\u3011,:\u8fd4\u56de\u9519\u8bef\u72b6\u6001\u7801code:\u3010{}\u3011,\u9519\u8bef\u6d88\u606fmessage:\u3010{}\u3011,", new Object[]{interfaceUrl, JSON.toJSONString(mapHeader), Objects.isNull(bodyParam) ? "" : JSON.toJSONString((Object)bodyParam), code, message});
            throw SyncClientException.operateErrorException(message);
        }
        String result = responseWrap.getString();
        if (logger.isDebugEnabled()) {
            logger.debug("\u8c03\u7528\u63a5\u53e3<<<url:\u3010{}\u3011,Header:\u3010{}\u3011,param:\u3010{}\u3011,resultCode:\u3010{}\u3011,resultMessage:\u3010{}\u3011,result:\u3010{}\u3011", new Object[]{interfaceUrl, JSON.toJSONString(mapHeader), Objects.isNull(bodyParam) ? "" : JSON.toJSONString((Object)bodyParam), code, message, result});
        }
        return result;
    }

    @Override
    public String executeCallIF(String regionalismCode, String interfaceCode, String networkCode, String appCredential, String userCredential, Object bodyParam) throws SyncClientException {
        return this.executeCallIF(regionalismCode, interfaceCode, networkCode, null, appCredential, userCredential, bodyParam);
    }

    @Override
    public String executeCallIF(String regionalismCode, String interfaceCode, String networkCode, String appCredential, Object bodyParam) throws SyncClientException {
        return this.executeCallIF(regionalismCode, interfaceCode, networkCode, null, appCredential, null, bodyParam);
    }
}

