CREATE TABLE `t_sync_service_interface` (
  `interface_id` varchar(32) NOT NULL COMMENT '接口id，主键',
  `interface_code` varchar(32) DEFAULT NULL COMMENT '接口代码',
  `interface_name` varchar(128) DEFAULT NULL COMMENT '接口名称',
  `interface_url` varchar(2048) DEFAULT NULL COMMENT '接口地址',
  `network_area_code` varchar(1) DEFAULT NULL COMMENT '服务部署网络区域代码 1 互联网; 2 公安移动信息网; 3 公安网; 4 视频专网',
  `regionalism_code` varchar(100) DEFAULT NULL COMMENT '所属行政区划编码',
  `version` int(11) DEFAULT '1' COMMENT '接口版本号',
  `version_note` varchar(5000) DEFAULT NULL COMMENT '接口版本说明',
  `status` int(1) DEFAULT '1' COMMENT '状态位标识，1：正常，0：禁用',
  `create_time` bigint(20) DEFAULT NULL COMMENT '创建时间',
  `update_time` bigint(20) DEFAULT NULL COMMENT '更新时间',
  `service_id` varchar(32) DEFAULT NULL COMMENT '服务id',
  `service_name` varchar(500) DEFAULT NULL COMMENT '服务名称',
  `public_key` text COMMENT '服务公钥信息',
  `service_type` varchar(100) DEFAULT NULL COMMENT '服务类型',
  PRIMARY KEY (`interface_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='全国服务接口信息表';