/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.sync.handler;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xdja.sync.bean.SyncApp;
import com.xdja.sync.bean.SyncResource;
import com.xdja.sync.bean.common.Consts;
import com.xdja.sync.dao.BasicSyncCommonDao;
import com.xdja.sync.enums.InterfaceCodeEnum;
import com.xdja.sync.enums.TableEnum;
import com.xdja.sync.exception.SyncClientException;
import com.xdja.sync.exception.SyncClientExceptionCode;
import com.xdja.sync.handler.AbstractSyncHandler;
import com.xdja.sync.service.BasicInfoSyncService;
import com.xdja.sync.service.BasicSyncAppService;
import com.xdja.sync.service.BasicSyncResourceService;
import com.xdja.sync.util.CredentialUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Component
public class AppResourceSyncHandler
extends AbstractSyncHandler {
    private static final Logger logger = LoggerFactory.getLogger(AppResourceSyncHandler.class);
    private static AtomicInteger atomicInteger = new AtomicInteger(1);
    private ScheduledExecutorService executorService = null;
    @Autowired
    private BasicSyncCommonDao basicSyncCommonDao;
    @Autowired
    private BasicSyncAppService basicSyncAppService;
    @Autowired
    private BasicSyncResourceService basicSyncResourceService;
    @Autowired
    private BasicInfoSyncService basicInfoSyncService;
    @Value(value="${sync.app.interval:300}")
    private Long syncAppInterval;
    private volatile boolean syncRunning = false;
    private int pageSize = Consts.SYNC_DEFAULT_PAGE_SIZE;

    @Override
    String getPoolName() {
        return "app";
    }

    @Override
    public void handler(TableEnum[] tableEnums, ScheduledExecutorService executorService) {
        executorService.scheduleWithFixedDelay(() -> {
            try {
                for (TableEnum tableEnum : tableEnums) {
                    if (!TableEnum.TABLE_APP_RESOURCE.getTableName().equals(tableEnum.getTableName())) continue;
                    this.syncAppResource();
                }
            }
            catch (Exception e) {
                logger.error("\u540c\u6b65\u5e94\u7528\u8d44\u6e90\u5173\u7cfb\u5f02\u5e38:", (Throwable)e);
            }
        }, 30L, this.syncAppInterval, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int syncAppResource() {
        if (logger.isDebugEnabled()) {
            logger.debug("===============\u5f00\u59cb\u540c\u6b65\u5e94\u7528\u8d44\u6e90\u5173\u7cfb\u4fe1\u606f>>>>>>");
        }
        AppResourceSyncHandler appResourceSyncHandler = this;
        synchronized (appResourceSyncHandler) {
            if (this.syncRunning) {
                logger.error("\u5e94\u7528\u8d44\u6e90\u5173\u7cfb\u4fe1\u606f\u6b63\u5728\u540c\u6b65\u4e2d,\u8bf7\u52ff\u91cd\u590d\u542f\u52a8");
                throw new SyncClientException(SyncClientExceptionCode.REPEAT_START.getCode(), "\u5e94\u7528\u8d44\u6e90\u5173\u7cfb\u4fe1\u606f\u6b63\u5728\u540c\u6b65\u4e2d,\u8bf7\u52ff\u91cd\u590d\u542f\u52a8");
            }
            this.syncRunning = true;
        }
        int syncAppTotal = 0;
        try {
            List<SyncApp> listSyncApp = this.basicSyncAppService.querySyncAppList();
            if (CollectionUtils.isEmpty(listSyncApp)) {
                logger.error("\u5e94\u7528\u4fe1\u606f\u4e3a\u7a7a,\u5e94\u7528\u8d44\u6e90\u5173\u7cfb\u4fe1\u606f\u540c\u6b65\u7ed3\u675f");
                int n = syncAppTotal;
                return n;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("\u9700\u8981\u540c\u6b65\u5e94\u7528\u8d44\u6e90\u5173\u7cfb\u7684\u5e94\u7528\u5217\u8868:\u3010{}\u3011", Arrays.asList(listSyncApp));
            }
            String localRegionalismCode = Consts.local_regionalismCode;
            String localNetworkCode = Consts.local_networkAreaCode;
            for (SyncApp syncApp : listSyncApp) {
                String appId = syncApp.getAppId();
                String appRegionalismCode = syncApp.getRegionalismCode();
                String appNetworkAreaCode = syncApp.getNetworkAreaCode();
                if (logger.isDebugEnabled()) {
                    logger.debug("\u5f00\u59cb\u540c\u6b65\u884c\u653f\u533a\u5212:[{}]\u5e94\u7528\u4fe1\u606f:appId:[{}]\u7684\u5e94\u7528\u8d44\u6e90\u5173\u7cfb\u4fe1\u606f>>>", (Object)appRegionalismCode, (Object)appId);
                }
                HashMap<String, Object> mapReqParam = new HashMap<String, Object>();
                mapReqParam.put("pageNo", 1);
                mapReqParam.put("pageSize", Consts.SYNC_DEFAULT_PAGE_SIZE);
                mapReqParam.put("appId", appId);
                mapReqParam.put("appRegionalismCode", appRegionalismCode);
                JSONArray resourceAllList = new JSONArray();
                int pageNo = 1;
                while (true) {
                    block22: {
                        try {
                            mapReqParam.put("pageNo", pageNo);
                            JSONArray resourceList = this.queryOffsiteAppResourceList(localRegionalismCode, localNetworkCode, mapReqParam);
                            resourceList = Objects.isNull(resourceList) ? new JSONArray() : resourceList;
                            resourceAllList.addAll((Collection)resourceList);
                            if (logger.isDebugEnabled()) {
                                logger.debug("\u540c\u6b65\u5e94\u7528\u8d44\u6e90\u5173\u7cfb\u5e94\u7528id:\u3010{}\u3011, \u5e94\u7528\u884c\u653f\u533a\u5212\u7f16\u7801:\u3010{}\u3011,\u7b2c[{}]\u9875\u6570\u636e:\u3010{}\u3011>>>", new Object[]{appId, appRegionalismCode, pageNo, resourceList.toJSONString()});
                            }
                            syncAppTotal += resourceList.size();
                            if (logger.isDebugEnabled()) {
                                logger.debug("\u540c\u6b65\u5e94\u7528\u8d44\u6e90\u5173\u7cfb\u5e94\u7528id:\u3010{}\u3011, \u5e94\u7528\u884c\u653f\u533a\u5212\u7f16\u7801:\u3010{}\u3011,\u7b2c[{}]\u9875\u6570\u636e\u5b8c\u6210,\u672c\u6b21\u540c\u6b65:[{}]\u6761,\u5171\u540c\u6b65:\u3010{}\u3011<<<", new Object[]{appId, appRegionalismCode, pageNo, resourceList.size(), syncAppTotal});
                            }
                            if (CollectionUtils.isEmpty((Collection)resourceList) || resourceList.size() < this.pageSize) {
                                if (!logger.isDebugEnabled()) break;
                                logger.debug("\u672c\u6b21\u540c\u6b65\u5e94\u7528\u8d44\u6e90\u5173\u7cfb\u6570\u636e\u4e0d\u591f\u4e0b\u4e00\u6b21\u5206\u9875\uff0c\u540c\u6b65\u7ed3\u675f");
                            }
                            break block22;
                        }
                        catch (Exception e) {
                            logger.error("\u540c\u6b65\u5e94\u7528\u8d44\u6e90\u5173\u7cfb\u5e94\u7528id:\u3010{}\u3011, \u5e94\u7528\u884c\u653f\u533a\u5212\u7f16\u7801:\u3010{}\u3011\u7684\u7b2c\u3010{}\u3011\u9875\u5e94\u7528\u8d44\u6e90\u5173\u7cfb\u4fe1\u606f\u5f02\u5e38:", new Object[]{appId, appRegionalismCode, pageNo, e});
                        }
                        break;
                    }
                    ++pageNo;
                }
                this.saveAppResource(appId, appRegionalismCode, appNetworkAreaCode, resourceAllList);
                if (!logger.isDebugEnabled()) continue;
                logger.debug("\u5f00\u59cb\u540c\u6b65\u884c\u653f\u533a\u5212:[{}]\u5e94\u7528\u4fe1\u606f:appId:[{}]\u5e94\u7528\u8d44\u6e90\u5173\u7cfb<<<", (Object)appRegionalismCode, (Object)appId);
            }
        }
        catch (Exception e) {
            logger.error("\u540c\u6b65\u5e94\u7528\u8d44\u6e90\u5173\u7cfb\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
        }
        finally {
            this.syncRunning = false;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("===============\u5f00\u59cb\u540c\u6b65\u5e94\u7528\u8d44\u6e90\u5173\u7cfb\u4fe1\u606f<<<");
        }
        return syncAppTotal;
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW, rollbackFor={Exception.class})
    public void saveAppResource(String appId, String appRegionalismCode, String appNetworkCode, JSONArray resourceList) {
        JSONObject jsonObject = null;
        String sql = "DELETE FROM t_sync_app_resource  where app_id = ?  and app_regionalism_Code = ? ";
        this.basicSyncCommonDao.updateBySql(sql, new Object[]{appId, appRegionalismCode});
        for (int i = 0; i < resourceList.size(); ++i) {
            jsonObject = resourceList.getJSONObject(i);
            String resourceId = jsonObject.getString("resourceId");
            String resourceRegionalismCode = jsonObject.getString("resourceRegionalismCode");
            SyncResource syncResource = this.basicSyncResourceService.querySyncResourceById(resourceId, resourceRegionalismCode);
            Integer resourceNetworkAreaCode = null;
            if (null != syncResource) {
                resourceNetworkAreaCode = syncResource.getNetworkAreaCode();
            }
            String id = UUID.randomUUID().toString().replaceAll("-", "");
            sql = "INSERT INTO t_sync_app_resource (APP_RESOURCE_ID, APP_ID, APP_REGIONALISM_CODE, APP_NETWORK_CODE, RESOURCE_ID, RESOURCE_REGIONALISM_CODE, RESOURCE_NETWORK_CODE, STATUS, CREATE_TIME, LAST_UPDATE_TIME) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
            Object[] args = new Object[]{id, appId, appRegionalismCode, appNetworkCode, resourceId, resourceRegionalismCode, resourceNetworkAreaCode, 1, System.currentTimeMillis(), System.currentTimeMillis()};
            this.basicSyncCommonDao.updateBySql(sql, args);
        }
    }

    private JSONArray queryOffsiteAppResourceList(String regionalismCode, String localNetworkCode, Map<String, Object> mapReqParam) {
        JSONArray resultList;
        String json = this.basicInfoSyncService.executeCallIF(regionalismCode, InterfaceCodeEnum.IF_UPM_SVC_06.getCode(), localNetworkCode, CredentialUtil.getAppCredential(), CredentialUtil.getUserCredential(), mapReqParam);
        if (logger.isDebugEnabled()) {
            logger.debug("\u540c\u6b65\u884c\u653f\u533a\u5212:[{}]\u5e94\u7528\u8d44\u6e90\u5173\u7cfb\u5217\u8868:\u3010{}\u3011", (Object)regionalismCode, (Object)json);
        }
        if (StringUtils.isEmpty((Object)json)) {
            logger.debug("\u540c\u6b65\u884c\u653f\u533a\u5212[{}]\u5e94\u7528\u8d44\u6e90\u5173\u7cfb\u5217\u8868\u4e3a\u7a7a", (Object)regionalismCode);
            return new JSONArray();
        }
        try {
            JSONObject result = JSON.parseObject((String)json);
            resultList = result.getJSONArray("resourceList");
        }
        catch (Exception e) {
            logger.error("\u540c\u6b65\u884c\u653f\u533a\u5212[{}]\u5e94\u7528\u8d44\u6e90\u5173\u7cfb\u5217\u8868\u7ed3\u679c\u8f6c\u5316\u5f02\u5e38,\u539f\u6570\u636e\u3010{}\u3011", (Object)regionalismCode, (Object)json);
            throw SyncClientException.operateErrorException("\u540c\u6b65\u884c\u653f\u533a\u5212" + regionalismCode + "\u5e94\u7528\u8d44\u6e90\u5173\u7cfb\u5217\u8868\u7ed3\u679c\u8f6c\u5316\u5f02\u5e38");
        }
        if (null == resultList) {
            logger.debug("\u540c\u6b65\u884c\u653f\u533a\u5212[{}]\u5e94\u7528\u8d44\u6e90\u5173\u7cfb\u5217\u8868\u4e3a\u7a7a", (Object)regionalismCode);
            return new JSONArray();
        }
        return resultList;
    }

    @Override
    public TableEnum[] supportType(TableEnum[] tableEnums) {
        ArrayList<TableEnum> listTableEnum = new ArrayList<TableEnum>();
        for (TableEnum tableEnum : tableEnums) {
            if (TableEnum.TABLE_APP_RESOURCE != tableEnum) continue;
            listTableEnum.add(tableEnum);
        }
        return listTableEnum.toArray(new TableEnum[listTableEnum.size()]);
    }
}

