/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.sync.handler;

import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.expr.SQLIntegerExpr;
import com.alibaba.druid.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.druid.sql.ast.statement.SQLCreateTableStatement;
import com.alibaba.druid.sql.dialect.mysql.parser.MySqlStatementParser;
import com.alibaba.druid.sql.dialect.oracle.parser.OracleStatementParser;
import com.alibaba.druid.util.StringUtils;
import com.alibaba.fastjson.JSON;
import com.xdja.sync.bean.common.Consts;
import com.xdja.sync.bean.common.DbType;
import com.xdja.sync.bean.common.TableColumn;
import com.xdja.sync.dao.BasicSyncCommonDao;
import com.xdja.sync.enums.TableEnum;
import com.xdja.sync.handler.AbstractSyncHandler;
import com.xdja.sync.handler.AppSyncHandler;
import com.xdja.sync.handler.CcmSyncHandler;
import com.xdja.sync.handler.PamsSyncHandler;
import com.xdja.sync.handler.ResourceSyncHandler;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Component
public class ExecuteScheduleSyncHandler
implements ApplicationContextAware {
    private static final Logger logger = LoggerFactory.getLogger(ExecuteScheduleSyncHandler.class);
    private ApplicationContext applicationContext;
    @Autowired
    private CcmSyncHandler ccmSyncHandler;
    @Autowired
    private PamsSyncHandler pamsSyncHandler;
    @Autowired
    private AppSyncHandler appSyncHandler;
    @Autowired
    private ResourceSyncHandler resourceSyncHandler;
    @Autowired
    private BasicSyncCommonDao basicSyncCommonDao;
    @Autowired
    private Map<String, AbstractSyncHandler> syncHandlers;

    public void run(TableEnum ... tableEnums) {
        tableEnums = null == tableEnums ? TableEnum.values() : tableEnums;
        this.checkRequiredTableSchema(tableEnums);
        TableEnum[] finalTableEnums = tableEnums;
        for (AbstractSyncHandler syncHandler : this.syncHandlers.values()) {
            syncHandler.doHandler(finalTableEnums);
        }
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void checkRequiredTableSchema(TableEnum[] tableEnums) {
        try (Connection connection = this.basicSyncCommonDao.getJdbcTemplate().getDataSource().getConnection();){
            Map<String, String> mapDbAllTableName = this.getDbAllTableName(connection);
            HashMap<String, String> mapFileTableSql = new HashMap<String, String>();
            HashMap<String, List<TableColumn>> mapTableColumn = new HashMap<String, List<TableColumn>>();
            String tableName = "";
            String sql = "";
            for (TableEnum tableEnum : tableEnums) {
                tableName = tableEnum.getTableName().toLowerCase();
                sql = this.getInitTableFileSql(tableName);
                mapFileTableSql.put(tableName, sql);
                if (mapDbAllTableName.containsKey(tableName)) {
                    List<TableColumn> listTableColumn = this.getTableTableColumn(connection, tableName);
                    mapTableColumn.put(tableName, listTableColumn);
                    continue;
                }
                if (!((null != Consts.pamsServerUrl && !"".equals(Consts.pamsServerUrl) || !TableEnum.TABLE_PERSON.getTableName().equalsIgnoreCase(tableName) && !TableEnum.TABLE_DEPARTMENT.getTableName().equalsIgnoreCase(tableName)) && (null != Consts.ccmServerUrl && !"".equals(Consts.ccmServerUrl) || !TableEnum.TABLE_REGISIONALISM.getTableName().equalsIgnoreCase(tableName) && !TableEnum.TABLE_BUSINESS_TYPE.getTableName().equalsIgnoreCase(tableName) && !TableEnum.TABLE_SERVICE.getTableName().equalsIgnoreCase(tableName) && !TableEnum.TABLE_SERVICE_INTERFACE.getTableName().equalsIgnoreCase(tableName) && !TableEnum.TABLE_RESOURCE.getTableName().equalsIgnoreCase(tableName) && !TableEnum.TABLE_APP.getTableName().equalsIgnoreCase(tableName)))) continue;
                sql = (String)mapFileTableSql.get(tableName);
                this.basicSyncCommonDao.updateBySql(sql, null);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("\u6570\u636e\u5e93\u4e2d\u540c\u6b65\u4fe1\u606f\u8868\u7ed3\u6784:\u3010{}\u3011", (Object)JSON.toJSONString(mapTableColumn));
            }
            for (Map.Entry entry : mapTableColumn.entrySet()) {
                try {
                    tableName = (String)entry.getKey();
                    List listTableColumn = (List)entry.getValue();
                    sql = (String)mapFileTableSql.get(tableName);
                    List<TableColumn> listFileTableColumn = this.parseSql(sql);
                    if (listTableColumn.size() != listFileTableColumn.size()) {
                        this.reInitTable(tableName, sql);
                        continue;
                    }
                    Map<String, TableColumn> mapDbTableColumn = listTableColumn.stream().collect(Collectors.toMap(tableColumn -> tableColumn.getColumnName(), tableColumn -> tableColumn, (k1, k2) -> k2));
                    Map<String, TableColumn> mapFileTableColumn = listFileTableColumn.stream().collect(Collectors.toMap(tableColumn -> tableColumn.getColumnName(), tableColumn -> tableColumn, (k1, k2) -> k2));
                    for (Map.Entry<String, TableColumn> entry2 : mapFileTableColumn.entrySet()) {
                        String fileKey = entry2.getKey();
                        TableColumn fileValue = entry2.getValue();
                        TableColumn dbValue = mapDbTableColumn.get(fileKey);
                        if (null != dbValue && null != fileValue && StringUtils.equalsIgnoreCase((String)dbValue.getColumnName(), (String)fileValue.getColumnName()) && StringUtils.equalsIgnoreCase((String)dbValue.getColumnType(), (String)fileValue.getColumnType()) && (StringUtils.equalsIgnoreCase((String)dbValue.getColumnType(), (String)"text") || StringUtils.equalsIgnoreCase((String)dbValue.getColumnType(), (String)"longtext") || fileValue.getColumnLength() == dbValue.getColumnLength())) continue;
                        logger.debug("\u8868[{}]\u7ed3\u6784\u53d1\u751f\u53d8\u66f4.\u91cd\u65b0\u521d\u59cb\u5316\u3002\u53d8\u66f4\u5b57\u6bb5\u524d\u540e:[{}],[{}]", new Object[]{tableName, JSON.toJSONString((Object)dbValue), JSON.toJSONString((Object)fileValue)});
                        this.reInitTable(tableName, sql);
                    }
                }
                catch (Exception e) {
                    logger.error("\u6821\u9a8c\u8868\u7ed3\u6784\u5931\u8d25", (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            logger.error("\u6821\u9a8c\u8868\u7ed3\u6784\u5931\u8d25", (Throwable)e);
        }
    }

    private void reInitTable(String tableName, String createTableSql) {
        String drop = "DROP TABLE " + tableName;
        this.basicSyncCommonDao.updateBySql(drop, null);
        this.basicSyncCommonDao.updateBySql(createTableSql, null);
    }

    private Map<String, String> getDbAllTableName(Connection connection) throws SQLException {
        HashMap<String, String> mapDbAllTableName = new HashMap<String, String>();
        DatabaseMetaData metaData = connection.getMetaData();
        ResultSet rs = metaData.getTables(connection.getCatalog(), null, null, null);
        while (rs.next()) {
            String tableName = rs.getString("TABLE_NAME").toLowerCase();
            mapDbAllTableName.put(tableName, tableName);
        }
        return mapDbAllTableName;
    }

    private String getInitTableFileSql(String tableName) throws IOException {
        String path = tableName + "." + Consts.dbType.getDb().toLowerCase() + ".sql";
        InputStream inputStream = ExecuteScheduleSyncHandler.class.getClassLoader().getResourceAsStream(path);
        String sql = IOUtils.toString((InputStream)inputStream, (String)"utf-8");
        return sql;
    }

    public List<TableColumn> parseSql(String sql) throws IOException {
        ArrayList<TableColumn> list = new ArrayList<TableColumn>();
        MySqlStatementParser sqlStatementParser = null;
        if (Consts.dbType == DbType.MYSQL) {
            sqlStatementParser = new MySqlStatementParser(sql);
        } else if (Consts.dbType == DbType.ORACLE || Consts.dbType == DbType.ORACLE_12C) {
            sqlStatementParser = new OracleStatementParser(sql);
        }
        SQLCreateTableStatement sqlCreateTableStatement = sqlStatementParser.parseCreateTable();
        List sqlObjects = sqlCreateTableStatement.getChildren();
        TableColumn tableColumn = null;
        for (SQLObject sqlObject : sqlObjects) {
            if (!(sqlObject instanceof SQLColumnDefinition)) continue;
            tableColumn = new TableColumn();
            SQLColumnDefinition columnDefinition = (SQLColumnDefinition)sqlObject;
            String columnName = columnDefinition.getNameAsString();
            String columnType = columnDefinition.getDataType().getName();
            List arguments = columnDefinition.getDataType().getArguments();
            if (null != arguments && arguments.size() > 0) {
                Number number = ((SQLIntegerExpr)arguments.get(0)).getNumber();
                tableColumn.setColumnLength(null != number ? number.intValue() : 0);
            }
            String comment = null;
            tableColumn.setColumnName(columnName.toUpperCase());
            tableColumn.setColumnType(columnType.toUpperCase());
            tableColumn.setComment(comment);
            list.add(tableColumn);
        }
        return list;
    }

    public List<TableColumn> getTableTableColumn(Connection connection, String tableName) throws SQLException, IOException {
        DatabaseMetaData metaData = connection.getMetaData();
        if (Consts.dbType == DbType.MYSQL) {
            return this.getMysqlTableTableColumn(connection, tableName);
        }
        if (Consts.dbType == DbType.ORACLE || Consts.dbType == DbType.ORACLE_12C) {
            return this.getOracleTableTableColumn(connection, tableName);
        }
        logger.error("\u4e0d\u652f\u6301\u7684\u6570\u636e\u5e93\u7c7b\u578b");
        return null;
    }

    private List<TableColumn> getMysqlTableTableColumn(Connection connection, String tableName) throws SQLException, IOException {
        ArrayList<TableColumn> listTableColumn = new ArrayList<TableColumn>();
        try (Statement statement = connection.createStatement();){
            ResultSet rs = statement.executeQuery("show create table " + tableName);
            if (null != rs && rs.next()) {
                String sql = rs.getString(2);
                List<TableColumn> list = this.parseSql(sql);
                return list;
            }
        }
        return listTableColumn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<TableColumn> getOracleTableTableColumn(Connection connection, String tableName) throws SQLException, IOException {
        ArrayList<TableColumn> listTableColumn = new ArrayList<TableColumn>();
        ResultSet rs = null;
        try (Statement statement = connection.createStatement();){
            String sql = "SELECT a.owner AS ower,      a.TABLE_NAME as tableName,      a.column_name as columnName,      a.data_type as dataType,      a.data_length as dataLength,      b.comments as comments FROM all_tab_columns a,   all_col_comments b  WHERE a.table_name = b.table_name AND a.column_name  = b.column_name AND a.table_name   = '" + tableName.toUpperCase() + "'" + " AND a.owner        = b.owner" + " AND a.owner        = '" + connection.getMetaData().getUserName() + "'";
            rs = statement.executeQuery(sql);
            TableColumn tableColumn = null;
            while (rs.next()) {
                tableColumn = new TableColumn();
                String columnName = rs.getString("columnName");
                String columnType = rs.getString("dataType");
                int dataSize = rs.getInt("dataLength");
                String remarks = rs.getString("comments");
                tableColumn.setColumnName(columnName.toUpperCase());
                tableColumn.setColumnType(columnType.toUpperCase());
                tableColumn.setColumnLength(dataSize);
                tableColumn.setComment(remarks);
                listTableColumn.add(tableColumn);
            }
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u6570\u636e\u5e93\u8868[{}]\u5b57\u6bb5\u4fe1\u606f\u5931\u8d25:", (Object)tableName, (Object)e);
        }
        finally {
            if (null != rs) {
                rs.close();
            }
        }
        return listTableColumn;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
        Consts.applicationContext = applicationContext;
    }
}

