CREATE TABLE `t_sync_app` (
  "id" varchar2(32) NOT NULL COMMENT '主键',
  "app_id" varchar2(64) NOT NULL COMMENT '应用id\r\n单个平台内唯一,推荐规则为“XXXXXXXXXX(12位服务事权单位机构代码，事权单位为公安机关则按照GA380填写；事权单位为非公安机关则填写18位统一社会信用代码)-X(1位区域类型)-X（1位应用类型）-XXXXX(字母或数字，总长度不超过32)”；其中流水号采取机构单位内小编吗（即不同机构单位内流水号从1开始）。编号一经生成后不可修改（可以删除），且不复用；如：\r\n010000000000-3-1-XXXXX 部级平台Ⅲ类区通用数据查询服务\r\n1级，服务资源事权单位机构代码\r\n2级，系统区域标识\r\n3级，应用类型代码（0未知、1-原生APP、2-Web应用、3-混合应用）\r\n4级，字母或数字，总长度不超过32',
  "app_name" varchar2(200) DEFAULT NULL COMMENT '应用名称',
  "app_package" varchar2(200) DEFAULT NULL COMMENT '应用包名',
  "app_description" varchar2(5000) DEFAULT NULL COMMENT '应用描述',
  "app_type" varchar2(1) DEFAULT NULL COMMENT '应用分类，1：安卓，2：H5',
  "app_version" varchar2(100) DEFAULT NULL COMMENT '应用版本名',
  "app_status" varchar2(1) DEFAULT '1' COMMENT '应用上下架状态【1-上架 0-下架】',
  "network_area_code" varchar2(1) DEFAULT NULL COMMENT '应用所在网络区域,1-Ⅰ类网络 2-Ⅱ类网络 3-Ⅲ类网络',
  "app_file_size" bigint(19) DEFAULT NULL COMMENT '单位Byte,安卓应用必填',
  "create_time" bigint(13) DEFAULT NULL COMMENT '创建时间',
  "version_code" varchar2(100) DEFAULT NULL COMMENT '应用版本值',
  "app_url" varchar2(500) DEFAULT NULL COMMENT '应用地址\r\nH5应用是应用打开地址；安卓应用是应用包下载地址',
  "regionalism_Code" varchar2(32) DEFAULT NULL COMMENT '应用归属机构标识',
  "update_time" bigint(13) DEFAULT NULL COMMENT '更新时间戳',
  "power_type" varchar2(2) DEFAULT NULL COMMENT '应用授权方式\r\n10-全公开、21-需由使用地授权、22-需由归属地授权、23-需由两地授权、31-需向使用地申请、32-需向归属地申请、33-需向两地申请',
  PRIMARY KEY ("id"),
  UNIQUE KEY "t_sync_app_un_appId_regionalismCode" ("app_id","regionalism_Code")
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='应用信息表'