/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.sync.handler;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xdja.sync.bean.Regionalism;
import com.xdja.sync.bean.common.Consts;
import com.xdja.sync.dao.BasicSyncCommonDao;
import com.xdja.sync.enums.InterfaceCodeEnum;
import com.xdja.sync.enums.TableEnum;
import com.xdja.sync.exception.SyncClientException;
import com.xdja.sync.exception.SyncClientExceptionCode;
import com.xdja.sync.handler.AbstractSyncHandler;
import com.xdja.sync.service.BasicInfoSyncService;
import com.xdja.sync.util.CredentialUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Component
public class ResourceSyncHandler
extends AbstractSyncHandler {
    private static final Logger logger = LoggerFactory.getLogger(ResourceSyncHandler.class);
    private static AtomicInteger atomicInteger = new AtomicInteger(1);
    private ScheduledExecutorService executorService = null;
    @Autowired
    private BasicSyncCommonDao basicSyncCommonDao;
    @Autowired
    private BasicInfoSyncService basicInfoSyncService;
    @Value(value="${sync.resource.interval:300}")
    private Long syncResourceInterval;
    private volatile boolean syncResourceRunning = false;
    String insertResourceSql = "INSERT INTO t_sync_resource ( id, resource_id, network_area_Code, resource_type, resource_service_type, resource_operator_type, resource_interface_type, resource_interface_address, power_type, regionalism_code, resource_name, resource_description, status, publish_scope, register_time, update_Time, dep_code, owner_Identifier, approver_Identifier, approve_Time, last_Update_Time) VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    String updateResourceSql = "UPDATE t_sync_resource SET resource_type=?, resource_service_type=?, resource_operator_type=?, resource_interface_type=?, resource_interface_address=?, power_type=?, resource_name=?, resource_description=?, status=?, publish_scope=?, register_time=?, update_Time=?, dep_code=?, owner_Identifier=?,  approver_Identifier=?, approve_Time=?, last_Update_Time=? where resource_id = ? and regionalism_code = ? and network_area_Code=?";

    @Override
    String getPoolName() {
        return "resource";
    }

    @Override
    public void handler(TableEnum[] tableEnums, ScheduledExecutorService executorService) {
        executorService.scheduleWithFixedDelay(() -> {
            try {
                for (TableEnum tableEnum : tableEnums) {
                    if (!TableEnum.TABLE_RESOURCE.getTableName().equals(tableEnum.getTableName())) continue;
                    this.syncResource();
                }
            }
            catch (Exception e) {
                logger.error("\u540c\u6b65\u8d44\u6e90\u6570\u636e\u5f02\u5e38:", (Throwable)e);
            }
        }, 30L, this.syncResourceInterval, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int syncResource() {
        if (logger.isDebugEnabled()) {
            logger.debug("\u540c\u6b65\u8d44\u6e90>>>:\u3010{}\u3011", (Object)System.currentTimeMillis());
        }
        ResourceSyncHandler resourceSyncHandler = this;
        synchronized (resourceSyncHandler) {
            if (this.syncResourceRunning) {
                logger.error("\u8d44\u6e90\u4fe1\u606f\u6b63\u5728\u540c\u6b65\u4e2d,\u8bf7\u52ff\u91cd\u590d\u542f\u52a8");
                throw new SyncClientException(SyncClientExceptionCode.REPEAT_START.getCode(), "\u8d44\u6e90\u4fe1\u606f\u6b63\u5728\u540c\u6b65\u4e2d,\u8bf7\u52ff\u91cd\u590d\u542f\u52a8");
            }
            this.syncResourceRunning = true;
        }
        int syncResourceTotal = 0;
        try {
            List<String> listRegionalismCode = this.basicInfoSyncService.getRegionalismCodeList(Regionalism.STATUS_NORMAL);
            if (CollectionUtils.isEmpty(listRegionalismCode)) {
                logger.error("\u540c\u6b65\u8d44\u6e90\u5168\u56fd\u884c\u653f\u533a\u5212\u7f16\u7801\u4e3a\u7a7a(t_sync_regionalism),\u8d44\u6e90\u4fe1\u606f\u540c\u6b65\u7ed3\u675f");
                int n = syncResourceTotal;
                return n;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("\u540c\u6b65\u8d44\u6e90\u5168\u56fd\u884c\u653f\u533a\u5212\u7f16\u7801:\u3010{}\u3011", Arrays.asList(listRegionalismCode));
            }
            String localRegionalismCode = Consts.local_regionalismCode;
            String localNetworkCode = Consts.local_networkAreaCode;
            int size = listRegionalismCode.size();
            String regionalismCode = null;
            for (int i = 0; i < size; ++i) {
                try {
                    regionalismCode = listRegionalismCode.get(i);
                    if (logger.isDebugEnabled()) {
                        logger.debug("\u540c\u6b65\u8d44\u6e90\u884c\u653f\u533a\u5212\u3010{}\u3011,\u7b2c\u3010{}/{}\u3011>>>", new Object[]{regionalismCode, i + 1, size});
                    }
                    int total = 0;
                    Long lastUpdateTime = this.getResourceLastUpdateTime(regionalismCode);
                    HashMap<String, Object> mapReqParam = new HashMap<String, Object>();
                    mapReqParam.put("pageSize", Consts.SYNC_DEFAULT_PAGE_SIZE);
                    mapReqParam.put("lastUpdateTime", lastUpdateTime);
                    int pageNo = 1;
                    JSONArray result = new JSONArray();
                    JSONArray resourceList = null;
                    do {
                        mapReqParam.put("pageNo", pageNo);
                        resourceList = this.queryOffsiteResourceList(regionalismCode, localNetworkCode, mapReqParam);
                        if (logger.isDebugEnabled()) {
                            logger.debug("\u540c\u6b65\u8d44\u6e90\u884c\u653f\u533a\u5212\u3010{}\u3011\u7b2c[{}]\u9875>>>", (Object)regionalismCode, (Object)pageNo);
                        }
                        if (null != resourceList && !resourceList.isEmpty()) {
                            total += resourceList.size();
                            result.addAll((Collection)resourceList);
                        }
                        if (logger.isDebugEnabled()) {
                            logger.debug("\u540c\u6b65\u8d44\u6e90\u884c\u653f\u533a\u5212\u3010{}\u3011\u7b2c[{}]\u9875,\u672c\u6b21\u540c\u6b65\u3010{}\u3011\u6761,\u5df2\u540c\u6b65\u3010{}\u3011\u6761<<<", new Object[]{regionalismCode, pageNo, null != resourceList ? resourceList.size() : 0, total});
                        }
                        ++pageNo;
                    } while (null != resourceList && !resourceList.isEmpty() && resourceList.size() >= Consts.SYNC_DEFAULT_PAGE_SIZE);
                    if (null != result && !result.isEmpty()) {
                        syncResourceTotal += resourceList.size();
                        this.saveResource(resourceList, regionalismCode);
                    }
                }
                catch (Exception e) {
                    logger.error("\u540c\u6b65\u8d44\u6e90\u884c\u653f\u533a\u5212\u3010{}\u3011\u8d44\u6e90\u5f02\u5e38:", (Object)regionalismCode, (Object)e);
                }
                if (!logger.isDebugEnabled()) continue;
                logger.debug("\u540c\u6b65\u8d44\u6e90\u884c\u653f\u533a\u5212\u3010{}\u3011,\u7b2c\u3010{}/{}\u3011<<<", new Object[]{regionalismCode, i + 1, size});
            }
        }
        catch (Exception e) {
            logger.error("\u540c\u6b65\u8d44\u6e90\u5f02\u5e38", (Throwable)e);
        }
        finally {
            this.syncResourceRunning = false;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("\u540c\u6b65\u8d44\u6e90<<<:\u3010{}\u3011", (Object)System.currentTimeMillis());
        }
        return syncResourceTotal;
    }

    private Long getResourceLastUpdateTime(String regionalismCode) {
        String sql = "SELECT MAX(update_time) FROM t_sync_resource where regionalism_code = ?";
        Long lastUpdateTime2 = (Long)this.basicSyncCommonDao.selectOne(sql, new Object[]{regionalismCode}, Long.class);
        lastUpdateTime2 = null == lastUpdateTime2 ? 0L : lastUpdateTime2;
        if (logger.isDebugEnabled()) {
            logger.debug("\u540c\u6b65\u8d44\u6e90regionalismCode:[{}],lastUpdateTime:[{}]", (Object)regionalismCode, (Object)lastUpdateTime2);
        }
        return lastUpdateTime2;
    }

    private JSONArray queryOffsiteResourceList(String regionalismCode, String localNetworkCode, Map<String, Object> mapReqParam) {
        JSONArray resultList;
        String json = this.basicInfoSyncService.executeCallIF(regionalismCode, InterfaceCodeEnum.IF_RSB_SVC_01.getCode(), localNetworkCode, CredentialUtil.getAppCredential(), CredentialUtil.getUserCredential(), mapReqParam);
        if (logger.isDebugEnabled()) {
            logger.debug("\u62c9\u53d6regionalismCode:[{}]\u8d44\u6e90\u5217\u8868\u4fe1\u606f:\u3010{}\u3011", (Object)regionalismCode, (Object)json);
        }
        if (StringUtils.isEmpty((Object)json)) {
            logger.error("\u62c9\u53d6\u5f02\u5730\u3010{}\u3011\u8d44\u6e90\u5217\u8868\u5f02\u5e38", (Object)regionalismCode);
            throw SyncClientException.operateErrorException("\u62c9\u53d6\u5f02\u5730\u8d44\u6e90\u5217\u8868\u5931\u8d25");
        }
        try {
            JSONObject result = JSON.parseObject((String)json);
            resultList = result.getJSONArray("resourceList");
        }
        catch (Exception e) {
            logger.error("\u63a5\u6536\u62c9\u53d6\u5f02\u5730\u3010{}\u3011\u8d44\u6e90\u5217\u8868\u7ed3\u679c\u8f6c\u5316\u5f02\u5e38,\u539f\u6570\u636e\u3010{}\u3011", (Object)regionalismCode, (Object)json);
            throw SyncClientException.operateErrorException("\u63a5\u6536\u62c9\u53d6\u5f02\u5730\u8d44\u6e90\u5217\u8868\u7ed3\u679c\u8f6c\u5316\u5f02\u5e38, \u539f\u6570\u636e\uff1a" + json);
        }
        for (int i = 0; i < resultList.size(); ++i) {
            JSONObject simpleResource = resultList.getJSONObject(i);
            String resourceId = simpleResource.getString("resourceId");
            try {
                JSONObject detail = this.httpQueryResourceDetail(resourceId, regionalismCode, localNetworkCode);
                if (Objects.isNull(detail)) {
                    logger.debug("\u540c\u6b65\u884c\u653f\u533a\u5212\u7f16\u7801regionalismCode:[{}],resourceId:[{}]\u8fd4\u56de\u6570\u636e\u4e3a\u7a7a", (Object)regionalismCode, (Object)resourceId);
                    continue;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("\u540c\u6b65\u884c\u653f\u533a\u5212\u7f16\u7801regionalismCode:[{}],resourceId:[{}]\u8fd4\u56de\u6570\u636e:\u3010{}\u3011", new Object[]{regionalismCode, resourceId, detail.toJSONString()});
                }
                simpleResource.putAll((Map)detail);
                continue;
            }
            catch (Exception e) {
                logger.error("\u83b7\u53d6\u5f02\u5730regionalismCode:[{}]\u8d44\u6e90resourceId:[{}]\u8be6\u60c5\u5931\u8d25:", new Object[]{regionalismCode, resourceId, e});
            }
        }
        return resultList;
    }

    private JSONObject httpQueryResourceDetail(String resourceId, String regionalismCode, String localNetworkCode) {
        JSONObject result;
        HashMap<String, String> mapReqParam = new HashMap<String, String>();
        mapReqParam.put("resourceId", resourceId);
        mapReqParam.put("regionalismCode", regionalismCode);
        String json = this.basicInfoSyncService.executeCallIF(regionalismCode, InterfaceCodeEnum.IF_RSB_SVC_02.getCode(), localNetworkCode, CredentialUtil.getAppCredential(), CredentialUtil.getUserCredential(), mapReqParam);
        if (logger.isDebugEnabled()) {
            logger.debug("\u62c9\u53d6regionalismCode:[{}]\u8d44\u6e90resourceId:[{}]\u8be6\u60c5\u4fe1\u606f:\u3010{}\u3011", new Object[]{regionalismCode, resourceId, json});
        }
        if (StringUtils.isEmpty((Object)json)) {
            logger.error("\u62c9\u53d6regionalismCode:[{}]\u8d44\u6e90resourceId:[{}]\u8be6\u60c5\u4fe1\u606f:\u3010{}\u3011", new Object[]{regionalismCode, resourceId, json});
            throw SyncClientException.operateErrorException("\u62c9\u53d6\u8d44\u6e90\u8be6\u60c5\u5931\u8d25");
        }
        try {
            result = JSON.parseObject((String)json);
        }
        catch (Exception e) {
            logger.error("\u63a5\u6536\u62c9\u53d6\u5f02\u5730\u3010{}\u3011\u8d44\u6e90resourceId\u3010{}\u3011\u8be6\u60c5\u7ed3\u679c\u8f6c\u5316\u5f02\u5e38\uff0c\u539f\u6570\u636e\uff1a\u3010{}\u3011", new Object[]{regionalismCode, resourceId, json});
            throw SyncClientException.operateErrorException(String.format("\u63a5\u6536\u62c9\u53d6%s\u8d44\u6e90%s\u8be6\u60c5\u7ed3\u679c\u8f6c\u5316\u5f02\u5e38\uff0c\u539f\u6570\u636e\uff1a%s", regionalismCode, resourceId, json));
        }
        return result;
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW, rollbackFor={Exception.class})
    public void saveResource(JSONArray resourceList, String regionalismCode) {
        for (int i = 0; i < resourceList.size(); ++i) {
            JSONObject jsonObject = resourceList.getJSONObject(i);
            String resourceId = jsonObject.getString("resourceId");
            String networkAreaCode = jsonObject.getString("networkAreaCode");
            String powerType = jsonObject.getString("powerType");
            String resourceType = jsonObject.getString("resourceType");
            String resourceServiceType = jsonObject.getString("resourceServiceType");
            String resourceOperatorType = jsonObject.getString("resourceOperatorType");
            String resourceInterfaceType = jsonObject.getString("resourceInterfaceType");
            String resourceInterfaceAddress = jsonObject.getString("resourceInterfaceAddress");
            String regionalismCode2 = jsonObject.getString("regionalismCode");
            String resourceName = jsonObject.getString("resourceName");
            String depCode = jsonObject.getString("depCode");
            String ownerIdentifier = jsonObject.getString("ownerIdentifier");
            String approverIdentifier = jsonObject.getString("approverIdentifier");
            String resourceDescription = jsonObject.getString("resourceDescription");
            Long approveTime = jsonObject.getLongValue("approveTime");
            Long lastUpdateTime = jsonObject.getLongValue("lastUpdateTime");
            Long registerTime = jsonObject.getLongValue("registerTime");
            String status = jsonObject.getString("status");
            JSONArray publishScopeAry = jsonObject.getJSONArray("publishScope");
            String publishScope = "";
            for (int i1 = 0; i1 < publishScopeAry.size(); ++i1) {
                publishScope = publishScope + publishScopeAry.getString(i1) + ",";
            }
            String sql = "SELECT count(1) FROM t_sync_resource  where resource_id = ?  and regionalism_Code = ? ";
            Long count = (Long)this.basicSyncCommonDao.selectOne(sql, new Object[]{resourceId, regionalismCode}, Long.class);
            Object[] args = null;
            String id = UUID.randomUUID().toString().replaceAll("-", "");
            if (!Objects.isNull(count) && count > 0L) {
                sql = this.updateResourceSql;
                args = new Object[]{resourceType, resourceServiceType, resourceOperatorType, resourceInterfaceType, resourceInterfaceAddress, powerType, resourceName, resourceDescription, status, publishScope, registerTime, lastUpdateTime, depCode, ownerIdentifier, approverIdentifier, approveTime, lastUpdateTime, resourceId, regionalismCode2, networkAreaCode};
            } else {
                sql = this.insertResourceSql;
                args = new Object[]{id, resourceId, networkAreaCode, resourceType, resourceServiceType, resourceOperatorType, resourceInterfaceType, resourceInterfaceAddress, powerType, regionalismCode2, resourceName, resourceDescription, status, publishScope, registerTime, lastUpdateTime, depCode, ownerIdentifier, approverIdentifier, approveTime, lastUpdateTime};
            }
            this.basicSyncCommonDao.updateBySql(sql, args);
        }
    }

    @Override
    public TableEnum[] supportType(TableEnum[] tableEnums) {
        ArrayList<TableEnum> listTableEnum = new ArrayList<TableEnum>();
        for (TableEnum tableEnum : tableEnums) {
            if (TableEnum.TABLE_RESOURCE != tableEnum) continue;
            listTableEnum.add(tableEnum);
        }
        return listTableEnum.toArray(new TableEnum[listTableEnum.size()]);
    }
}

