create table t_sync_app_resource
(
  APP_RESOURCE_ID        VARCHAR2(32) not null,
  APP_ID     VARCHAR2(64),
  APP_REGIONALISM_CODE     VARCHAR2(32),
  APP_NETWORK_CODE     VARCHAR2(1),
  RESOURCE_ID     VARCHAR2(64),
  RESOURCE_REGIONALISM_CODE     VARCHAR2(32),
  RESOURCE_NETWORK_CODE     VARCHAR2(1),
  STATUS     NUMBER(1),
  CREATE_TIME     NUMBER(19),
  LAST_UPDATE_TIME     NUMBER(19)
);
comment on table t_sync_app_resource is '应用信息表';
comment on column t_sync_app_resource.APP_RESOURCE_ID is '主键id';
comment on column t_sync_app_resource.APP_ID is '应用id';
comment on column t_sync_app_resource.APP_REGIONALISM_CODE is '应用行政区划代码';
comment on column t_sync_app_resource.APP_NETWORK_CODE is '1一类2二类3三类';
comment on column t_sync_app_resource.RESOURCE_ID is '资源id';
comment on column t_sync_app_resource.RESOURCE_REGIONALISM_CODE is '资源行政区划代码';
comment on column t_sync_app_resource.RESOURCE_NETWORK_CODE is '1一类2二类3三类';
comment on column t_sync_app_resource.STATUS is '1授权，2收回，3删除';
comment on column t_sync_app_resource.CREATE_TIME is '创建时间戳';
comment on column t_sync_app_resource.LAST_UPDATE_TIME is '最后更新时间戳';
alter table t_sync_app_resource add primary key (APP_RESOURCE_ID);
