create table t_sync_department
(
  ID     VARCHAR2(32),
  AMOUNT     VARCHAR2(9),
  CODE     VARCHAR2(15),
  CONTACT     VARCHAR2(16),
  DEP_ABB     VARCHAR2(128),
  DEP_TYPE     VARCHAR2(4),
  DIRECT     VARCHAR2(1),
  DISPLAY_STATE     VARCHAR2(1),
  FLAG     VARCHAR2(1),
  GRADE     VARCHAR2(1),
  N_LAST_UPDATE_TIME     NUMBER(19),
  NAME     VARCHAR2(500),
  NOTE     VARCHAR2(500),
  ORDER_FIELD     NUMBER(19),
  PARENT_ID     VARCHAR2(32),
  PARENT_CODE     VARCHAR2(15),
  PHONE     VARCHAR2(20),
  TREE_CODE     VARCHAR2(4000),
  TREE_ID     VARCHAR2(4000)
);
comment on table t_sync_department is '资源业务类型信息表';
comment on column t_sync_department.ID is '主键';
comment on column t_sync_department.AMOUNT is '单位人数';
comment on column t_sync_department.CODE is '单位编码';
comment on column t_sync_department.CONTACT is '联系方式';
comment on column t_sync_department.DEP_ABB is '单位简拼';
comment on column t_sync_department.DEP_TYPE is '单位类型，单位：org， 部门：dept';
comment on column t_sync_department.DIRECT is '是否直属单位';
comment on column t_sync_department.DEP_ABB is '警信客户端是否展示,为null或1展示，0 不展示（暂不使用，使用display_state）';
comment on column t_sync_department.FLAG is '是否删除标志字段，0未删除,1删除。默认为0';
comment on column t_sync_department.GRADE is '单位级别';
comment on column t_sync_department.N_LAST_UPDATE_TIME is '更新时间戳';
comment on column t_sync_department.NAME is '单位名称';
comment on column t_sync_department.NOTE is '备注';
comment on column t_sync_department.ORDER_FIELD is '排序';
comment on column t_sync_department.PARENT_ID is '父节点id';
comment on column t_sync_department.PARENT_CODE is '父节点编码';
comment on column t_sync_department.PHONE is '单位联系电话';
comment on column t_sync_department.TREE_CODE is '单位code全排序（从根单位节点到当前单位节点），用-分隔';
comment on column t_sync_department.TREE_ID is '单位id全排序（从根单位节点到当前单位节点），用-分隔';
alter table t_sync_department add primary key (ID);