create table t_sync_service
(
  service_id        VARCHAR2(32) not null,
  service_name     VARCHAR2(128),
  regionalism_Code     VARCHAR2(32),
  network_area_code     VARCHAR2(1) default '1',
  public_key     VARCHAR2(4000),
  service_type     VARCHAR2(32),
  status     NUMBER(1),
  create_time     NUMBER(19),
  update_time     NUMBER(19)
);
comment on table t_sync_service is '全国服务平台信息表';
comment on column t_sync_service.service_id is '服务id，主键';
comment on column t_sync_service.service_name is '服务系统名称';
comment on column t_sync_service.regionalism_code is '行政区划编码code';
comment on column t_sync_service.network_area_code is '服务网络区域代码 1 互联网， 2 公安移动信息网, 3 公安网, 4 视频专网';
comment on column t_sync_service.public_key is '公钥信息';
comment on column t_sync_service.service_type is '服务类型';
comment on column t_sync_service.status is '状态：0-删除；1-正常';
comment on column t_sync_service.create_time is '创建时间';
comment on column t_sync_service.update_time is '更新时间';
alter table t_sync_service add primary key (service_id);