/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.log.service.impl;

import com.alibaba.fastjson.JSON;
import com.xdja.log.bean.LogCacheBean;
import com.xdja.log.bean.LogCacheKey;
import com.xdja.log.handler.BasicLogHandlerFactory;
import com.xdja.log.service.BasicLogCacheService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.ListOperations;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class RedisBasicLogCacheServiceImpl
implements BasicLogCacheService {
    private static final Logger logger = LoggerFactory.getLogger(RedisBasicLogCacheServiceImpl.class);
    @Autowired(required=false)
    private StringRedisTemplate stringRedisTemplate;
    @Autowired
    private BasicLogHandlerFactory basicLogHandlerFactory;

    @Override
    public void cacheLog(LogCacheBean logCacheBean) {
        try {
            this.stringRedisTemplate.opsForList().rightPush((Object)LogCacheKey.getLogCacheKey(), (Object)JSON.toJSONString((Object)logCacheBean));
        }
        catch (Exception e) {
            logger.error("\u7f13\u5b58[\u57fa\u4e8eRedis\u7f13\u5b58]\u65e5\u5fd7\u5931\u8d25:", (Throwable)e);
        }
    }

    @Override
    public void consumeLog() {
        try {
            while (true) {
                try {
                    while (true) {
                        ListOperations stringStringListOperations;
                        String json;
                        if (null != (json = (String)(stringStringListOperations = this.stringRedisTemplate.opsForList()).leftPop((Object)LogCacheKey.getLogCacheKey())) && !"".equals(json.trim())) {
                            if (logger.isDebugEnabled()) {
                                logger.debug("\u6d88\u8d39[\u57fa\u4e8eRedis\u7f13\u5b58]\u65e5\u5fd7>>>LogCacheBean:\u3010{}\u3011", (Object)json);
                            }
                            LogCacheBean logCacheBean = (LogCacheBean)JSON.parseObject((String)json, LogCacheBean.class);
                            this.basicLogHandlerFactory.handlerLog(logCacheBean);
                            continue;
                        }
                        Thread.sleep(5000L);
                    }
                }
                catch (Exception e) {
                    logger.error("\u6d88\u8d39[\u57fa\u4e8eRedis\u7f13\u5b58]\u65e5\u5fd7\u5931\u8d25:", (Throwable)e);
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            logger.error("\u6d88\u8d39[\u57fa\u4e8eRedis\u7f13\u5b58]\u65e5\u5fd7\u5931\u8d25:", (Throwable)e);
            return;
        }
    }
}

