/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.smcs.util;

import com.xdja.smcs.enums.RegionalismEnum;
import com.xdja.smcs.service.BasicPullSmcsService;
import com.xdja.sync.bean.common.Consts;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Component
public class SmcsPlatformUtil {
    public static SmcsPlatformUtil platformUtil;
    private static Environment environment;
    @Autowired
    private BasicPullSmcsService basicPullSmcsService;

    @PostConstruct
    public void init() {
        platformUtil = this;
        SmcsPlatformUtil.platformUtil.basicPullSmcsService = this.basicPullSmcsService;
    }

    public static void pullPlatformInfo() {
        SmcsPlatformUtil.platformUtil.basicPullSmcsService.platformInfoToSmcs();
    }

    public static String getSystemCode() {
        String applicationName = environment.getProperty(Consts.APPLICATION_NAME, "");
        return applicationName;
    }

    public static String getSmcsSwitch() {
        String smcsSwitch = environment.getProperty("smcs.switch", "off");
        return smcsSwitch;
    }

    public static String getSmcsUrl() {
        String smcsUrl = environment.getProperty("smcs.server.url");
        return smcsUrl;
    }

    public static String getRegionalismCode() {
        String regionalismCode = environment.getProperty(RegionalismEnum.getRegionalismCode(SmcsPlatformUtil.getSystemCode()), "");
        return regionalismCode;
    }

    static {
        environment = (Environment)Consts.applicationContext.getBean(Environment.class);
    }
}

