/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.sync.dao.imp;

import com.xdja.sync.bean.SyncAppResource;
import com.xdja.sync.bean.SyncPersonApp;
import com.xdja.sync.dao.BasicSyncCommonDao;
import com.xdja.sync.dao.PersonAppSyncDao;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PersonAppSyncDaoImpl
implements PersonAppSyncDao {
    private static final Logger logger = LoggerFactory.getLogger(PersonAppSyncDaoImpl.class);
    @Autowired
    private BasicSyncCommonDao basicSyncCommonDao;

    @Override
    public void savePersonApp(List<SyncPersonApp> listPersonApp) {
        String sql = "INSERT INTO t_sync_person_app (PERSON_APP_ID, APP_ID, APP_REGIONALISM_CODE, APP_NETWORK_CODE, PERSON_ID, PERSON_REGIONALISM_CODE, CREATE_TIME, LAST_UPDATE_TIME, status) VALUES (?, ?, ?, ?, ?, ?, ?, ?,?)";
        ArrayList<Object[]> batchArgs = new ArrayList<Object[]>();
        for (SyncPersonApp personApp : listPersonApp) {
            Object[] args = new Object[]{personApp.getPersonAppId(), personApp.getAppId(), personApp.getAppRegionalismCode(), personApp.getAppNetworkCode(), personApp.getPersonId(), personApp.getPersonRegionalismCode(), personApp.getCreateTime(), personApp.getLastUpdateTime(), personApp.getStatus()};
            batchArgs.add(args);
        }
        this.basicSyncCommonDao.batchUpdateBySql(sql, batchArgs);
    }

    @Override
    public void savePersonApp(SyncPersonApp personApp) {
        this.savePersonApp(Arrays.asList(personApp));
    }

    @Override
    public void updatePersonAppStatus(SyncPersonApp syncPersonApp) {
        this.updatePersonAppStatus(Arrays.asList(syncPersonApp));
    }

    @Override
    public void updatePersonAppStatus(List<SyncPersonApp> listPersonApp) {
        String sql = "UPDATE t_sync_person_app SET status = ?, LAST_UPDATE_TIME = ? where app_id = ?  and app_regionalism_Code = ?  and person_id = ?  and person_regionalism_Code = ? ";
        ArrayList<Object[]> batchArgs = new ArrayList<Object[]>();
        for (SyncPersonApp syncPersonApp : listPersonApp) {
            Object[] args = new Object[]{syncPersonApp.getStatus(), syncPersonApp.getLastUpdateTime(), syncPersonApp.getAppId(), syncPersonApp.getAppRegionalismCode(), syncPersonApp.getPersonId(), syncPersonApp.getPersonRegionalismCode()};
            batchArgs.add(args);
        }
        this.basicSyncCommonDao.batchUpdateBySql(sql, batchArgs);
    }

    @Override
    public void deletePersonAppByAppId(String appId, String appRegionalismCode) {
        String sql = "DELETE FROM t_sync_person_app  where app_id = ?  and app_regionalism_Code = ? ";
        this.basicSyncCommonDao.updateBySql(sql, new Object[]{appId, appRegionalismCode});
    }

    @Override
    public List<SyncPersonApp> queryPersonAppByAppId(String appId, String appRegionalismCode) {
        String sql = "SELECT * FROM t_sync_person_app  where app_id = ?  and app_regionalism_Code = ? ";
        return this.basicSyncCommonDao.selectList(sql, new Object[]{appId, appRegionalismCode}, SyncAppResource.class);
    }
}

