/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.smcs.util;

import com.xdja.common.BasicSystemInitUtil;
import com.xdja.smcs.enums.RegionalismEnum;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Component
public class SmcsPlatformUtil {
    @Autowired
    private Environment environment;
    @Autowired
    private BasicSystemInitUtil basicSystemInitUtil;

    public String getSystemCode() {
        return this.basicSystemInitUtil.getSystemCode();
    }

    public String getSmcsSwitch() {
        String smcsSwitch = this.environment.getProperty("smcs.switch", "off");
        return smcsSwitch;
    }

    public boolean reportSmcsSwitch() {
        return "on".equals(this.getSmcsSwitch());
    }

    public String getSmcsUrl() {
        String smcsUrl = this.environment.getProperty("smcs.server.url");
        return smcsUrl;
    }

    public String getRegionalismCode() {
        String regionalismCode = this.environment.getProperty(RegionalismEnum.getRegionalismCode(this.getSystemCode()), "");
        return regionalismCode;
    }
}

