/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.sync.util;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DigestUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(DigestUtil.class);

    public static String MD5Digest(String proto, String salt) {
        if (salt != null) {
            proto = proto + salt;
        }
        return DigestUtil.digest(proto, "MD5");
    }

    public static String encrytSHA256(String content, String secret) {
        String hash = "";
        try {
            Mac sha256_HMAC = Mac.getInstance("HmacSHA256");
            SecretKeySpec secret_key = new SecretKeySpec(secret.getBytes(), "HmacSHA256");
            sha256_HMAC.init(secret_key);
            byte[] bytes = sha256_HMAC.doFinal(content.getBytes());
            hash = DigestUtil.byteArrayToHex(bytes);
        }
        catch (Exception e) {
            LOGGER.error("Error HmacSHA256 ==========={}", (Object)e.getMessage());
        }
        return hash;
    }

    public static String encrytSHA512(String data, String key, Charset charset) {
        String result = "";
        byte[] bytesKey = key.getBytes();
        SecretKeySpec secretKey = new SecretKeySpec(bytesKey, "HmacSHA512");
        try {
            Mac mac = Mac.getInstance("HmacSHA512");
            mac.init(secretKey);
            byte[] macData = mac.doFinal(data.getBytes());
            byte[] hex = new Hex().encode(macData);
            result = new String(hex, charset);
        }
        catch (Exception e) {
            LOGGER.error("Error encrytSHA512 ==========={}", (Object)e.getMessage());
        }
        return result;
    }

    public static String encrytSHA512UTF_8(String data, String key) {
        return DigestUtil.encrytSHA512(data, key, StandardCharsets.UTF_8);
    }

    public static String encrytSHA512ISO_8859_1(String data, String key) {
        return DigestUtil.encrytSHA512(data, key, StandardCharsets.ISO_8859_1);
    }

    public static String SHA1Digest(String proto) {
        return DigestUtil.digest(proto, "SHA1");
    }

    private static String digest(String proto, String type) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(type);
            byte[] inputByteArray = proto.getBytes();
            messageDigest.update(inputByteArray);
            byte[] resultByteArray = messageDigest.digest();
            return DigestUtil.byteArrayToHex(resultByteArray);
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
    }

    private static String byteArrayToHex(byte[] byteArray) {
        char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        char[] resultCharArray = new char[byteArray.length * 2];
        int index = 0;
        for (byte b : byteArray) {
            resultCharArray[index++] = hexDigits[b >>> 4 & 0xF];
            resultCharArray[index++] = hexDigits[b & 0xF];
        }
        return new String(resultCharArray);
    }
}

