create table t_sync_app
(
  id        VARCHAR2(32) not null,
  app_id     VARCHAR2(64),
  app_name     VARCHAR2(200),
  app_package     VARCHAR2(200),
  app_description     VARCHAR2(4000),
  app_type     VARCHAR2(1),
  app_version     VARCHAR2(100),
  app_status     VARCHAR2(1) default '1',
  network_area_code     VARCHAR2(1) default '1',
  app_file_size     NUMBER(19),
  create_time     NUMBER(19),
  version_code     VARCHAR2(100),
  app_url     VARCHAR2(500),
  regionalism_Code     VARCHAR2(32),
  update_time     NUMBER(19),
  status     NUMBER(1),
  power_type     VARCHAR2(2)
);
comment on table t_sync_app is '应用信息表';
comment on column t_sync_app.id is '主键id';
comment on column t_sync_app.app_id is '应用id\r\n单个平台内唯一,推荐规则为“XXXXXXXXXX(12位服务事权单位机构代码，事权单位为公安机关则按照GA380填写；事权单位为非公安机关则填写18位统一社会信用代码)-X(1位区域类型)-X（1位应用类型）-XXXXX(字母或数字，总长度不超过32)”；其中流水号采取机构单位内小编吗（即不同机构单位内流水号从1开始）。编号一经生成后不可修改（可以删除），且不复用；如：\r\n010000000000-3-1-XXXXX 部级平台Ⅲ类区通用数据查询服务\r\n1级，服务资源事权单位机构代码\r\n2级，系统区域标识\r\n3级，应用类型代码（0未知、1-原生APP、2-Web应用、3-混合应用）\r\n4级，字母或数字，总长度不超过32';
comment on column t_sync_app.app_name is '应用名称';
comment on column t_sync_app.app_package is '应用包名';
comment on column t_sync_app.app_description is '应用描述';
comment on column t_sync_app.app_type is '应用分类，1：安卓，2：H5';
comment on column t_sync_app.app_version is '应用版本名';
comment on column t_sync_app.app_status is '应用上下架状态【1-上架 0-下架】';
comment on column t_sync_app.network_area_code is '应用所在网络区域,1-Ⅰ类网络 2-Ⅱ类网络 3-Ⅲ类网络';
comment on column t_sync_app.app_file_size is '单位Byte,安卓应用必填';
comment on column t_sync_app.create_time is '创建时间';
comment on column t_sync_app.version_code is '应用版本值';
comment on column t_sync_app.app_url is '应用地址\r\nH5应用是应用打开地址；安卓应用是应用包下载地址';
comment on column t_sync_app.regionalism_Code is '应用归属机构标识';
comment on column t_sync_app.update_time is '更新时间戳';
comment on column t_sync_app.status is '应用状态,1启用(解锁),0禁用(锁定)；身份认证系统临时禁用应用使用';
comment on column t_sync_app.power_type is '应用授权方式\r\n10-全公开、21-需由使用地授权、22-需由归属地授权、23-需由两地授权、31-需向使用地申请、32-需向归属地申请、33-需向两地申请';
alter table t_sync_app add primary key (id);
alter table t_sync_app add unique (app_id, regionalism_Code);