/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.sync.controller;

import com.xdja.log.controller.LogBaseController;
import com.xdja.sync.bean.SyncApp;
import com.xdja.sync.bean.SyncPerson;
import com.xdja.sync.bean.common.Consts;
import com.xdja.sync.service.BasicSyncAppService;
import com.xdja.sync.service.BasicSyncPersonService;
import com.xdja.sync.util.CredentialUtil;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class BasicCredentialController
extends LogBaseController {
    private static final Logger log = LoggerFactory.getLogger(BasicCredentialController.class);
    @Autowired
    private BasicSyncAppService basicSyncAppService;
    @Autowired
    private BasicSyncPersonService basicSyncPersonService;

    @RequestMapping(value={"/admin/v1/public/createAppCredential"})
    public void createAppCredential(String appId, String appRegionalismCode) {
        SyncApp syncApp;
        if (log.isDebugEnabled()) {
            log.debug("\u521b\u5efa\u5e94\u7528\u51ed\u8bc1>>>appId\uff1a\u3010{}\u3011, appRegionalismCode\uff1a\u3010{}\u3011", (Object)appId, (Object)appRegionalismCode);
        }
        if (null == (syncApp = this.basicSyncAppService.querySyncAppById(appId, appRegionalismCode))) {
            log.error("\u521b\u5efa\u5e94\u7528\u51ed\u8bc1>>>appId\uff1a\u3010{}\u3011, appRegionalismCode\uff1a\u3010{}\u3011,\u5e94\u7528\u4fe1\u606f\u4e0d\u5b58\u5728", (Object)appId, (Object)appRegionalismCode);
            super.writeAndFlushFailResponse(-1, "\u5e94\u7528\u4fe1\u606f\u4e0d\u5b58\u5728");
            return;
        }
        String appCredential = CredentialUtil.getAppCredential(syncApp);
        if (log.isDebugEnabled()) {
            log.debug("\u521b\u5efa\u5e94\u7528\u51ed\u8bc1<<<appId\uff1a\u3010{}\u3011, appRegionalismCode\uff1a\u3010{}\u3011, appCredential\uff1a\u3010{}\u3011", new Object[]{appId, appRegionalismCode, appCredential});
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("appCredential", appCredential);
        super.writeAndFlushSuccessResponse(map);
    }

    @RequestMapping(value={"/admin/v1/public/createUserCredential"})
    public void createUserCredential(String userId, String personCode) {
        if (log.isDebugEnabled()) {
            log.debug("\u521b\u5efa\u7528\u6237\u51ed\u8bc1>>>userId\uff1a\u3010{}\u3011, personCode\uff1a\u3010{}\u3011", (Object)userId, (Object)personCode);
        }
        SyncPerson syncPerson = null;
        if (!StringUtils.isEmpty((Object)userId)) {
            syncPerson = this.basicSyncPersonService.querySyncPersonById(userId);
        }
        if (!StringUtils.isEmpty((Object)personCode)) {
            syncPerson = this.basicSyncPersonService.querySyncPersonByCode(personCode);
        }
        if (null == syncPerson) {
            log.error("\u521b\u5efa\u7528\u6237\u51ed\u8bc1>>>userId\uff1a\u3010{}\u3011, personCode\uff1a\u3010{}\u3011,\u7528\u6237\u4fe1\u606f\u4e0d\u5b58\u5728", (Object)userId, (Object)personCode);
            super.writeAndFlushFailResponse(-1, "\u4eba\u5458\u4fe1\u606f\u4e0d\u5b58\u5728");
            return;
        }
        String regionalismCode = Consts.local_regionalismCode;
        String userCredential = CredentialUtil.getUserCredential(regionalismCode, syncPerson);
        if (log.isDebugEnabled()) {
            log.debug("\u521b\u5efa\u7528\u6237\u51ed\u8bc1<<<userId\uff1a\u3010{}\u3011,  personCode\uff1a\u3010{}\u3011, userCredential\uff1a\u3010{}\u3011", new Object[]{userId, personCode, userCredential});
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("userCredential", userCredential);
        super.writeAndFlushSuccessResponse(map);
    }
}

