/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.log.handler;

import com.alibaba.fastjson.JSON;
import com.xdja.log.bean.LogCacheBean;
import com.xdja.log.handler.AdminBasicLogSaveHandler;
import com.xdja.log.handler.BasicLogSaveHandler;
import com.xdja.log.service.BasicLogCacheService;
import com.xdja.sync.bean.common.Consts;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Component
public class BasicLogHandlerFactory
implements ApplicationContextAware,
InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger(BasicLogHandlerFactory.class);
    @Autowired
    private BasicLogCacheService basicLogCacheService;
    @Autowired
    private Environment environment;
    private List<BasicLogSaveHandler> listLogHandler = null;

    public boolean existExcludeAdminLogHandler() {
        return null != this.listLogHandler && this.listLogHandler.size() > 0;
    }

    public void handlerLog(LogCacheBean logCacheBean) {
        if (null != this.listLogHandler && !this.listLogHandler.isEmpty()) {
            for (BasicLogSaveHandler logSaveHandler : this.listLogHandler) {
                logSaveHandler.saveLog(logCacheBean);
            }
        }
    }

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        Map logHandlerMapTmp = context.getBeansOfType(BasicLogSaveHandler.class);
        this.listLogHandler = new ArrayList<BasicLogSaveHandler>();
        logger.info("\u65e5\u5fd7\u5904\u7406\u7c7b:\u3010{}\u3011", (Object)JSON.toJSONString((Object)logHandlerMapTmp));
        for (BasicLogSaveHandler logSaveHandler : logHandlerMapTmp.values()) {
            if (logSaveHandler instanceof AdminBasicLogSaveHandler) continue;
            this.listLogHandler.add(logSaveHandler);
        }
        Consts.applicationContext = context;
    }

    public void afterPropertiesSet() throws Exception {
        String logSwitch = this.environment.getProperty("log.switch", "off");
        logger.info("\u65e5\u5fd7\u5904\u7406\u7c7blogSwitch:\u3010{}\u3011", (Object)logSwitch);
        if ("on".equals(logSwitch)) {
            this.basicLogCacheService.consumeLog();
            this.basicLogCacheService.clearLog();
        }
    }
}

