/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.sync.handler;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicLong;
import org.springframework.util.StringUtils;

public class SyncHandlerThreadFactory {
    private static AtomicLong atomicLong = new AtomicLong(10L);
    private static Map<String, ScheduledExecutorService> mapExecutorService = new ConcurrentHashMap<String, ScheduledExecutorService>();
    public static final String POOL_NAME_DEFAULT = "default";
    public static final String POOL_NAME_PERSON_APP = "personApp";
    public static final String POOL_NAME_TABLE_DATA = "tableData";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ScheduledExecutorService getScheduledExecutorService(String poolName) {
        String string = poolName;
        synchronized (string) {
            ScheduledExecutorService executorService1 = mapExecutorService.get(poolName);
            if (null == executorService1) {
                executorService1 = SyncHandlerThreadFactory.initExecutorService(poolName);
                mapExecutorService.put(poolName, executorService1);
            }
            return executorService1;
        }
    }

    private static ScheduledExecutorService initExecutorService(String poolName) {
        return SyncHandlerThreadFactory.initExecutorService(poolName, 1);
    }

    private static ScheduledExecutorService initExecutorService(String poolName, int corePoolSize) {
        if (StringUtils.isEmpty((Object)poolName)) {
            poolName = POOL_NAME_DEFAULT;
            corePoolSize = 4;
        }
        if (0 == corePoolSize) {
            corePoolSize = 1;
        }
        String finalPoolName = poolName;
        ScheduledThreadPoolExecutor executorService = new ScheduledThreadPoolExecutor(corePoolSize, runnable -> {
            Thread thread = new Thread(runnable);
            thread.setDaemon(true);
            thread.setName("sync-pool-" + finalPoolName);
            return thread;
        });
        return executorService;
    }

    public static long getSyncInitialDelay() {
        return SyncHandlerThreadFactory.getSyncInitialDelay(20L);
    }

    public static long getSyncInitialDelay(long initialDelay) {
        return atomicLong.getAndAdd(initialDelay);
    }

    public static ScheduledExecutorService getScheduledExecutorService() {
        return SyncHandlerThreadFactory.getScheduledExecutorService(POOL_NAME_DEFAULT);
    }

    private SyncHandlerThreadFactory() {
    }

    public static void main(String[] args) {
        long syncInitialDelay = SyncHandlerThreadFactory.getSyncInitialDelay();
        long syncInitialDelay2 = SyncHandlerThreadFactory.getSyncInitialDelay();
        long syncInitialDelay3 = SyncHandlerThreadFactory.getSyncInitialDelay();
    }
}

