/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.common;

import com.xdja.sync.bean.common.Consts;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.core.ValueOperations;
import org.springframework.util.StringUtils;

public class BisRedisUtil {
    private static final Logger logger = LoggerFactory.getLogger(BisRedisUtil.class);

    public static StringRedisTemplate getStringRedisTemplate() {
        StringRedisTemplate stringRedisTemplate = (StringRedisTemplate)Consts.applicationContext.getBean(StringRedisTemplate.class);
        return stringRedisTemplate;
    }

    public static boolean tryLock(String lockKey, String lockValue) {
        String andSet;
        ValueOperations opsForValue = BisRedisUtil.getStringRedisTemplate().opsForValue();
        if (opsForValue.setIfAbsent((Object)lockKey, (Object)lockValue).booleanValue()) {
            return true;
        }
        String oldValue = (String)opsForValue.get((Object)lockKey);
        return !StringUtils.isEmpty((Object)oldValue) && Long.parseLong(oldValue) < System.currentTimeMillis() && !StringUtils.isEmpty((Object)(andSet = (String)opsForValue.getAndSet((Object)lockKey, (Object)lockValue))) && andSet.equals(oldValue);
    }

    public static boolean tryLock(String lockKey, String lockValue, long timeout) {
        return BisRedisUtil.getStringRedisTemplate().opsForValue().setIfAbsent((Object)lockKey, (Object)lockValue, timeout, TimeUnit.SECONDS);
    }

    public static void releaseLock(String lockKey, String lockValue) {
        try {
            ValueOperations opsForValue;
            String s;
            if (logger.isDebugEnabled()) {
                logger.debug("\u91ca\u653e\u9501\u5f00\u59cblockKey:{}", (Object)lockKey);
            }
            if (!StringUtils.isEmpty((Object)(s = (String)(opsForValue = BisRedisUtil.getStringRedisTemplate().opsForValue()).get((Object)lockKey))) && lockValue.equals(s)) {
                BisRedisUtil.getStringRedisTemplate().expire((Object)lockKey, 1L, TimeUnit.NANOSECONDS);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("\u91ca\u653e\u9501\u7ed3\u675flockKey:{}", (Object)lockKey);
            }
        }
        catch (Exception e) {
            logger.error("redis lockKey:\u3010{}\u3011lockValue:\u3010{}\u3011\u5220\u9664\u5931\u8d25", (Throwable)e);
        }
    }

    public static void renewalLock(String lockKey, long timeout) {
        BisRedisUtil.getStringRedisTemplate().opsForValue().getOperations().expire((Object)lockKey, timeout, TimeUnit.SECONDS);
    }

    public static String getExpireMillis(long seconds) {
        return String.valueOf(System.currentTimeMillis() + seconds * 60L);
    }
}

