/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.sync.handler;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import com.xdja.common.BisRedisUtil;
import com.xdja.common.RedisKeyConst;
import com.xdja.smcs.factory.BasicPullSmcsFactory;
import com.xdja.smcs.util.SmcsPlatformUtil;
import com.xdja.sync.bean.SyncApp;
import com.xdja.sync.bean.SyncAppResource;
import com.xdja.sync.bean.SyncPersonApp;
import com.xdja.sync.bean.common.Consts;
import com.xdja.sync.dao.PersonAppSyncDao;
import com.xdja.sync.enums.InterfaceCodeEnum;
import com.xdja.sync.enums.TableEnum;
import com.xdja.sync.exception.SyncClientException;
import com.xdja.sync.exception.SyncClientExceptionCode;
import com.xdja.sync.handler.AbstractSyncHandler;
import com.xdja.sync.handler.SyncHandlerThreadFactory;
import com.xdja.sync.service.BasicInfoSyncService;
import com.xdja.sync.service.BasicSyncAppService;
import com.xdja.sync.util.CredentialUtil;
import com.xdja.sync.util.IdGeneratorUtil;
import com.xdja.task.ThreadManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Component
public class PersonAppSyncHandler
extends AbstractSyncHandler {
    private static final Logger logger = LoggerFactory.getLogger(PersonAppSyncHandler.class);
    @Autowired
    private BasicSyncAppService basicSyncAppService;
    @Autowired
    private BasicInfoSyncService basicInfoSyncService;
    @Autowired
    private PersonAppSyncDao personAppSyncDao;
    @Autowired
    private BasicPullSmcsFactory basicPullSmcsFactory;
    @Autowired
    private Environment environment;
    @Autowired
    private SmcsPlatformUtil smcsPlatformUtil;
    private Long syncPersonAppInterval;
    private String syncPersonAppSwitch;
    private AtomicInteger atomicInteger = new AtomicInteger(1);
    private volatile boolean syncPersonAppRunning = false;
    private String syncPersonAppAppRegionalismCodeKey = "sync.personApp.app.regionalismCode";
    private final String APPLICATION_ROAM_AREA_CODE = "application.roam.area.code";

    @Override
    String getPoolName() {
        return "personApp";
    }

    @Override
    public void handler(TableEnum[] tableEnums, ScheduledExecutorService executorService) {
        String uasUrl = this.environment.getProperty("application.upm.server.url", "");
        if (StringUtils.isEmpty((Object)uasUrl)) {
            logger.error("\u540c\u6b65\u4eba\u5458\u5e94\u7528\u6743\u9650\u5173\u7cfb\uff0cuas\u5730\u5740\u4e3a\u7a7a\uff0c\u8bf7\u914d\u7f6e\u914d\u7f6e\u9879sync.uas.path");
            return;
        }
        this.syncPersonAppSwitch = this.environment.getProperty("sync.personApp.switch", "on");
        if ("off".equalsIgnoreCase(this.syncPersonAppSwitch)) {
            logger.info("\u540c\u6b65\u4eba\u5458\u5e94\u7528\u6743\u9650\u5173\u7cfb\u672a\u5f00\u542f\uff0c\u5982\u9700\u5f00\u542f\u8bf7\u6dfb\u52a0\u6216\u4fee\u6539\u914d\u7f6e\u9879sync.personApp.switch=on");
            return;
        }
        String property = this.environment.getProperty("sync.personApp.interval", "300");
        this.syncPersonAppInterval = Long.parseLong(property);
        if (null == executorService) {
            executorService = SyncHandlerThreadFactory.getScheduledExecutorService(this.getPoolName());
        }
        executorService.scheduleWithFixedDelay(() -> {
            try {
                logger.info("\u540c\u6b65\u4eba\u5458\u5e94\u7528\u6743\u9650\u5173\u7cfb\uff0c\u540c\u6b65\u9891\u7387\u914d\u7f6e\u9879sync.personApp.interval[{}]\u79d2", (Object)this.syncPersonAppInterval);
                for (TableEnum tableEnum : tableEnums) {
                    if (!TableEnum.TABLE_PERSON_APP.getTableName().equals(tableEnum.getTableName())) continue;
                    List<SyncApp> listSyncApp = this.basicSyncAppService.querySyncAppList();
                    this.syncSelfPersonApp(listSyncApp, uasUrl);
                    this.syncPersonApp(listSyncApp);
                }
                logger.info("\u540c\u6b65\u4eba\u5458\u5e94\u7528\u6743\u9650\u5173\u7cfb\uff0c\u540c\u6b65\u9891\u7387\u914d\u7f6e\u9879sync.personApp.interval[{}]\u79d2<<<", (Object)this.syncPersonAppInterval);
            }
            catch (Exception e) {
                logger.error("\u540c\u6b65\u4eba\u5458\u5e94\u7528\u5173\u7cfb\u5f02\u5e38:", (Throwable)e);
            }
        }, this.syncPersonAppInterval, this.syncPersonAppInterval, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int syncSelfPersonApp(List<SyncApp> listSyncApp, String uasUrl) {
        boolean existRedis;
        if (logger.isDebugEnabled()) {
            logger.debug("\u540c\u6b65\u4eba\u5458\u5e94\u7528\u5173\u7cfb\u4fe1\u606f>>>>>>");
        }
        String lockKey = RedisKeyConst.getLockSyncLocalPersonAppKey();
        long timeout = 900L;
        String lockValue = BisRedisUtil.getExpireMillis(timeout);
        boolean lock = false;
        boolean bl = existRedis = null != BisRedisUtil.getStringRedisTemplate();
        if (existRedis) {
            lock = BisRedisUtil.tryLock(lockKey, lockValue);
            if (!lock) {
                logger.error("\u4eba\u5458\u5e94\u7528\u5173\u7cfb,\u4fe1\u606f\u6b63\u5728\u540c\u6b65\u4e2d,\u8bf7\u52ff\u91cd\u590d\u542f\u52a8");
                throw new SyncClientException(SyncClientExceptionCode.REPEAT_START.getCode(), "\u4eba\u5458\u5e94\u7528\u5173\u7cfb\u4fe1\u606f\u6b63\u5728\u540c\u6b65\u4e2d,\u8bf7\u52ff\u91cd\u590d\u542f\u52a8");
            }
        } else {
            PersonAppSyncHandler personAppSyncHandler = this;
            synchronized (personAppSyncHandler) {
                if (this.syncPersonAppRunning) {
                    logger.error("\u4eba\u5458\u5e94\u7528\u5173\u7cfb,\u4fe1\u606f\u6b63\u5728\u540c\u6b65\u4e2d,\u8bf7\u52ff\u91cd\u590d\u542f\u52a8");
                    throw new SyncClientException(SyncClientExceptionCode.REPEAT_START.getCode(), "\u4eba\u5458\u5e94\u7528\u5173\u7cfb\u4fe1\u606f\u6b63\u5728\u540c\u6b65\u4e2d,\u8bf7\u52ff\u91cd\u590d\u542f\u52a8");
                }
                this.syncPersonAppRunning = true;
            }
        }
        int syncAppTotal = 0;
        try {
            if (CollectionUtils.isEmpty(listSyncApp)) {
                logger.warn("\u540c\u6b65\u4eba\u5458\u5e94\u7528\u5173\u7cfb,\u5e94\u7528\u4fe1\u606f\u4e3a\u7a7a,\u540c\u6b65\u7ed3\u675f");
                int n = syncAppTotal;
                return n;
            }
            Map<String, String> appIdMap = listSyncApp.stream().collect(Collectors.toMap(SyncApp::getAppId, SyncApp::getNetworkAreaCode, (value1, value2) -> value1));
            String localRoamAreaCode = this.environment.getProperty("application.roam.area.code", "");
            if (StringUtils.isEmpty((Object)localRoamAreaCode)) {
                logger.error("\u672c\u670d\u52a1\u884c\u653f\u533a\u57df\u7f16\u7801\u5fc5\u987b\u914d\u7f6e,\u8bf7\u68c0\u67e5\u914d\u7f6e\u9879 application.roam.area.code");
                int n = 0;
                return n;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("\u540c\u6b65\u4eba\u5458\u5e94\u7528\u5173\u7cfb,regionalism_Code:\u3010{}\u3011", (Object)localRoamAreaCode);
            }
            List<SyncPersonApp> appMaxTimeList = this.personAppSyncDao.queryPersonAppMaxTime();
            Map<String, List<SyncPersonApp>> appRegionalismCodeMap = appMaxTimeList.stream().collect(Collectors.groupingBy(SyncPersonApp::getAppRegionalismCode));
            ArrayList<Future> listFuture = new ArrayList<Future>();
            Future future = null;
            Long syncPersonAppMaxTime = 0L;
            if (!CollectionUtils.isEmpty(appRegionalismCodeMap) && !CollectionUtils.isEmpty((Collection)appRegionalismCodeMap.get(localRoamAreaCode))) {
                syncPersonAppMaxTime = appRegionalismCodeMap.get(localRoamAreaCode).get(0).getLastUpdateTime();
            }
            if (logger.isDebugEnabled()) {
                logger.debug("\u540c\u6b65\u4eba\u5458\u5e94\u7528\u5173\u7cfb,appRegionalismCode:\u3010{}\u3011,LastUpdateTime:\u3010{}\u3011>>>", (Object)localRoamAreaCode, (Object)syncPersonAppMaxTime);
            }
            future = ThreadManager.getInstance().submit(new LocalPersonAppTask(localRoamAreaCode, this.personAppSyncDao, this.basicInfoSyncService, this.basicPullSmcsFactory, this.smcsPlatformUtil, syncPersonAppMaxTime, uasUrl, appIdMap), "personApp");
            listFuture.add(future);
            if (logger.isDebugEnabled()) {
                logger.debug("\u540c\u6b65\u4eba\u5458\u5e94\u7528\u5173\u7cfb,appRegionalismCode:\u3010{}\u3011,LastUpdateTime:\u3010{}\u3011<<<", (Object)localRoamAreaCode, (Object)syncPersonAppMaxTime);
            }
            for (Future future2 : listFuture) {
                try {
                    future2.get();
                }
                catch (Exception e) {
                    logger.error("\u540c\u6b65\u4eba\u5458\u5e94\u7528\u5173\u7cfb\u5f02\u5e38\uff1a", (Throwable)e);
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("\u672c\u5730\u540c\u6b65\u4eba\u5458\u5e94\u7528\u5173\u7cfb,\u4efb\u52a1\u5b8c\u6210");
                }
                if (!existRedis) continue;
                BisRedisUtil.renewalLock(lockKey, timeout);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("\u672c\u5730\u540c\u6b65\u4eba\u5458\u5e94\u7528\u5173\u7cfb,appRegionalismCode:\u3010{}\u3011,LastUpdateTime:\u3010{}\u3011<<<", (Object)localRoamAreaCode, (Object)syncPersonAppMaxTime);
            }
        }
        catch (Exception e) {
            logger.error("\u540c\u6b65\u4eba\u5458\u5e94\u7528\u5173\u7cfb,\u5f02\u5e38", (Throwable)e);
        }
        finally {
            this.syncPersonAppRunning = false;
            if (existRedis && lock) {
                BisRedisUtil.releaseLock(lockKey, lockValue);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("\u540c\u6b65\u4eba\u5458\u5e94\u7528\u5173\u7cfb<<<");
        }
        return syncAppTotal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(rollbackFor={Exception.class})
    public int syncPersonApp(List<SyncApp> listSyncApp) {
        boolean existRedis;
        if (logger.isDebugEnabled()) {
            logger.debug("\u540c\u6b65\u4eba\u5458\u5e94\u7528\u5173\u7cfb\u4fe1\u606f>>>>>>");
        }
        String lockKey = RedisKeyConst.getLockSyncPersonAppKey();
        long timeout = 900L;
        String lockValue = BisRedisUtil.getExpireMillis(timeout);
        boolean lock = false;
        boolean bl = existRedis = null != BisRedisUtil.getStringRedisTemplate();
        if (existRedis) {
            lock = BisRedisUtil.tryLock(lockKey, lockValue);
            if (!lock) {
                logger.error("\u4eba\u5458\u5e94\u7528\u5173\u7cfb,\u4fe1\u606f\u6b63\u5728\u540c\u6b65\u4e2d,\u8bf7\u52ff\u91cd\u590d\u542f\u52a8");
                throw new SyncClientException(SyncClientExceptionCode.REPEAT_START.getCode(), "\u4eba\u5458\u5e94\u7528\u5173\u7cfb\u4fe1\u606f\u6b63\u5728\u540c\u6b65\u4e2d,\u8bf7\u52ff\u91cd\u590d\u542f\u52a8");
            }
        } else {
            PersonAppSyncHandler personAppSyncHandler = this;
            synchronized (personAppSyncHandler) {
                if (this.syncPersonAppRunning) {
                    logger.error("\u4eba\u5458\u5e94\u7528\u5173\u7cfb,\u4fe1\u606f\u6b63\u5728\u540c\u6b65\u4e2d,\u8bf7\u52ff\u91cd\u590d\u542f\u52a8");
                    throw new SyncClientException(SyncClientExceptionCode.REPEAT_START.getCode(), "\u4eba\u5458\u5e94\u7528\u5173\u7cfb\u4fe1\u606f\u6b63\u5728\u540c\u6b65\u4e2d,\u8bf7\u52ff\u91cd\u590d\u542f\u52a8");
                }
                this.syncPersonAppRunning = true;
            }
        }
        int syncAppTotal = 0;
        try {
            String appRegionalismCode;
            if (CollectionUtils.isEmpty(listSyncApp)) {
                logger.warn("\u540c\u6b65\u4eba\u5458\u5e94\u7528\u5173\u7cfb,\u5e94\u7528\u4fe1\u606f\u4e3a\u7a7a,\u540c\u6b65\u7ed3\u675f");
                int n = syncAppTotal;
                return n;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("\u540c\u6b65\u4eba\u5458\u5e94\u7528\u5173\u7cfb,\u5e94\u7528:\u3010{}\u3011", (Object)JSON.toJSONString(listSyncApp));
            }
            String syncPersonAppAppRegionalismCode = this.environment.getProperty(this.syncPersonAppAppRegionalismCodeKey, "");
            String localRoamAreaCode = this.environment.getProperty("application.roam.area.code", "");
            if (StringUtils.isEmpty((Object)localRoamAreaCode)) {
                logger.error("\u672c\u670d\u52a1\u884c\u653f\u533a\u57df\u7f16\u7801\u5fc5\u987b\u914d\u7f6e,\u8bf7\u68c0\u67e5\u914d\u7f6e\u9879 application.roam.area.code");
                int n = 0;
                return n;
            }
            if (!StringUtils.isEmpty((Object)syncPersonAppAppRegionalismCode)) {
                String[] ary = syncPersonAppAppRegionalismCode.split(",");
                List<String> listAppRegionalismCode = Arrays.asList(ary);
                ArrayList<SyncApp> listSyncAppTmp = new ArrayList<SyncApp>();
                for (SyncApp syncApp : listSyncApp) {
                    appRegionalismCode = syncApp.getAppRegionalismCode();
                    if (appRegionalismCode.equals(localRoamAreaCode) || !listAppRegionalismCode.contains(appRegionalismCode)) continue;
                    listSyncAppTmp.add(syncApp);
                }
                listSyncApp = listSyncAppTmp;
            }
            ArrayList<Future> listFuture = new ArrayList<Future>();
            Future future = null;
            for (SyncApp syncApp : listSyncApp) {
                String appId = syncApp.getAppId();
                appRegionalismCode = syncApp.getRegionalismCode();
                if (appRegionalismCode.equals(localRoamAreaCode)) continue;
                if (logger.isDebugEnabled()) {
                    logger.debug("\u540c\u6b65\u4eba\u5458\u5e94\u7528\u5173\u7cfb,appId:\u3010{}\u3011,appRegionalismCode:\u3010{}\u3011>>>", (Object)appId, (Object)appRegionalismCode);
                }
                future = ThreadManager.getInstance().submit(new PersonAppTask(syncApp, this.personAppSyncDao, this.basicInfoSyncService, this.basicPullSmcsFactory, this.smcsPlatformUtil), "personApp");
                listFuture.add(future);
                if (!logger.isDebugEnabled()) continue;
                logger.debug("\u540c\u6b65\u4eba\u5458\u5e94\u7528\u5173\u7cfb,appId:\u3010{}\u3011, appRegionalismCode:\u3010{}\u3011<<<", (Object)appId, (Object)appRegionalismCode);
            }
            for (Future future2 : listFuture) {
                try {
                    future2.get();
                }
                catch (Exception e) {
                    logger.error("\u540c\u6b65\u4eba\u5458\u5e94\u7528\u5173\u7cfb\u5f02\u5e38\uff1a", (Throwable)e);
                }
                if (!existRedis) continue;
                BisRedisUtil.renewalLock(lockKey, timeout);
            }
        }
        catch (Exception e) {
            logger.error("\u540c\u6b65\u4eba\u5458\u5e94\u7528\u5173\u7cfb,\u5f02\u5e38", (Throwable)e);
        }
        finally {
            this.syncPersonAppRunning = false;
            if (existRedis && lock) {
                BisRedisUtil.releaseLock(lockKey, lockValue);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("\u540c\u6b65\u4eba\u5458\u5e94\u7528\u5173\u7cfb<<<");
        }
        return syncAppTotal;
    }

    @Override
    public TableEnum[] supportType(TableEnum[] tableEnums) {
        ArrayList<TableEnum> listTableEnum = new ArrayList<TableEnum>();
        for (TableEnum tableEnum : tableEnums) {
            if (TableEnum.TABLE_PERSON_APP != tableEnum) continue;
            listTableEnum.add(tableEnum);
        }
        return listTableEnum.toArray(new TableEnum[listTableEnum.size()]);
    }

    static class PersonAppTask
    implements Callable<String> {
        private int pageSize = 2000;
        private PersonAppSyncDao personAppSyncDao;
        private BasicPullSmcsFactory basicPullSmcsFactory;
        private SmcsPlatformUtil smcsPlatformUtil;
        private BasicInfoSyncService basicInfoSyncService;
        private SyncApp syncApp;

        public PersonAppTask(SyncApp syncApp, PersonAppSyncDao personAppSyncDao, BasicInfoSyncService basicInfoSyncService, BasicPullSmcsFactory basicPullSmcsFactory, SmcsPlatformUtil smcsPlatformUtil) {
            this.syncApp = syncApp;
            this.personAppSyncDao = personAppSyncDao;
            this.basicInfoSyncService = basicInfoSyncService;
            this.basicPullSmcsFactory = basicPullSmcsFactory;
            this.smcsPlatformUtil = smcsPlatformUtil;
        }

        @Override
        public String call() throws Exception {
            String appId = this.syncApp.getAppId();
            String appRegionalismCode = this.syncApp.getRegionalismCode();
            String appNetworkAreaCode = this.syncApp.getNetworkAreaCode();
            try {
                int addCount = 0;
                int deleteCount = 0;
                List<SyncPersonApp> listPullSyncPersonApp = this.pullPersonAppList(appId, appRegionalismCode, appNetworkAreaCode);
                if (CollectionUtils.isEmpty(listPullSyncPersonApp)) {
                    logger.info("\u540c\u6b65\u4eba\u5458\u5e94\u7528\u5173\u7cfb,appId:\u3010{}\u3011, appRegionalismCode:\u3010{}\u3011\u5220\u9664\u5168\u90e8", (Object)appId, (Object)appRegionalismCode);
                    List<SyncPersonApp> listDbSyncPersonApp = this.personAppSyncDao.queryPersonAppByAppId(appId, appRegionalismCode, SyncPersonApp.status_grant_1);
                    if (null != listDbSyncPersonApp && listDbSyncPersonApp.size() > 0) {
                        for (SyncPersonApp syncPersonApp : listDbSyncPersonApp) {
                            syncPersonApp.setStatus(SyncAppResource.status_delete_3);
                            syncPersonApp.setLastUpdateTime(System.currentTimeMillis());
                            this.personAppSyncDao.updatePersonAppStatus(syncPersonApp);
                            ++deleteCount;
                        }
                    }
                } else {
                    Long count = this.personAppSyncDao.queryPersonAppCountByAppId(appId, appRegionalismCode, SyncPersonApp.status_grant_1);
                    if (null == count || count == 0L) {
                        SyncPersonApp syncPersonAppTmp = null;
                        for (SyncPersonApp personApp : listPullSyncPersonApp) {
                            long currentTimeMillis;
                            syncPersonAppTmp = this.personAppSyncDao.getSyncPersonApp(personApp.getPersonId(), personApp.getPersonRegionalismCode(), appId, appRegionalismCode);
                            if (null == syncPersonAppTmp) {
                                personApp.setPersonAppId(IdGeneratorUtil.nextIdNum());
                                personApp.setAppId(appId);
                                personApp.setAppRegionalismCode(appRegionalismCode);
                                personApp.setAppNetworkCode(appNetworkAreaCode);
                                personApp.setStatus(SyncPersonApp.status_grant_1);
                                currentTimeMillis = System.currentTimeMillis();
                                personApp.setCreateTime(currentTimeMillis);
                                personApp.setLastUpdateTime(currentTimeMillis);
                                this.personAppSyncDao.savePersonApp(personApp);
                                continue;
                            }
                            if (SyncPersonApp.status_grant_1.intValue() == syncPersonAppTmp.getStatus().intValue()) continue;
                            currentTimeMillis = System.currentTimeMillis();
                            syncPersonAppTmp.setCreateTime(currentTimeMillis);
                            syncPersonAppTmp.setLastUpdateTime(currentTimeMillis);
                            syncPersonAppTmp.setStatus(SyncPersonApp.status_grant_1);
                            this.personAppSyncDao.updatePersonAppStatus(syncPersonAppTmp);
                        }
                        addCount = listPullSyncPersonApp.size();
                    } else {
                        HashMap<Object, SyncPersonApp> mapPullPersonApp = new HashMap<Object, SyncPersonApp>();
                        for (SyncPersonApp syncPersonApp : listPullSyncPersonApp) {
                            String key = syncPersonApp.getPersonId() + syncPersonApp.getPersonRegionalismCode() + appId + appRegionalismCode;
                            long currentTimeMillis = System.currentTimeMillis();
                            syncPersonApp.setPersonAppId(IdGeneratorUtil.nextIdNum());
                            syncPersonApp.setStatus(SyncPersonApp.status_grant_1);
                            syncPersonApp.setCreateTime(currentTimeMillis);
                            syncPersonApp.setLastUpdateTime(currentTimeMillis);
                            syncPersonApp.setAppId(appId);
                            syncPersonApp.setAppRegionalismCode(appRegionalismCode);
                            syncPersonApp.setAppNetworkCode(appNetworkAreaCode);
                            mapPullPersonApp.put(key, syncPersonApp);
                        }
                        List<SyncPersonApp> listDbSyncPersonApp = this.personAppSyncDao.queryPersonAppByAppId(appId, appRegionalismCode, SyncPersonApp.status_grant_1);
                        HashMap<String, SyncPersonApp> mapDbSyncPersonApp = new HashMap<String, SyncPersonApp>();
                        for (SyncPersonApp syncPersonApp : listDbSyncPersonApp) {
                            String key = syncPersonApp.getPersonId() + syncPersonApp.getPersonRegionalismCode() + syncPersonApp.getAppId() + syncPersonApp.getAppRegionalismCode();
                            mapDbSyncPersonApp.put(key, syncPersonApp);
                        }
                        MapDifference difference = Maps.difference(mapPullPersonApp, mapDbSyncPersonApp);
                        Map mapAdd = difference.entriesOnlyOnLeft();
                        Map mapDelete = difference.entriesOnlyOnRight();
                        if (!CollectionUtils.isEmpty((Map)mapAdd)) {
                            Collection values = mapAdd.values();
                            SyncPersonApp syncPersonAppTmp = null;
                            for (SyncPersonApp syncPersonApp : values) {
                                syncPersonAppTmp = this.personAppSyncDao.getSyncPersonApp(syncPersonApp.getPersonId(), syncPersonApp.getPersonRegionalismCode(), syncPersonApp.getAppId(), syncPersonApp.getAppRegionalismCode());
                                if (null == syncPersonAppTmp) {
                                    syncPersonApp.setCreateTime(System.currentTimeMillis());
                                    syncPersonApp.setLastUpdateTime(System.currentTimeMillis());
                                    syncPersonApp.setStatus(SyncPersonApp.status_grant_1);
                                    this.personAppSyncDao.savePersonApp(syncPersonApp);
                                    continue;
                                }
                                if (SyncPersonApp.status_grant_1.intValue() == syncPersonAppTmp.getStatus().intValue()) continue;
                                syncPersonAppTmp.setLastUpdateTime(System.currentTimeMillis());
                                syncPersonAppTmp.setStatus(SyncPersonApp.status_grant_1);
                                this.personAppSyncDao.updatePersonAppStatusById(syncPersonAppTmp);
                            }
                            addCount = mapAdd.size();
                        }
                        if (!CollectionUtils.isEmpty((Map)mapDelete)) {
                            for (SyncPersonApp syncPersonApp : mapDelete.values()) {
                                if (syncPersonApp.getStatus().intValue() != SyncPersonApp.status_grant_1.intValue()) continue;
                                syncPersonApp.setLastUpdateTime(System.currentTimeMillis());
                                syncPersonApp.setStatus(SyncPersonApp.status_delete_3);
                                this.personAppSyncDao.updatePersonAppStatus(syncPersonApp);
                            }
                            deleteCount = mapDelete.size();
                        }
                    }
                    logger.info("\u540c\u6b65\u4eba\u5458\u5e94\u7528\u5173\u7cfb,appId:\u3010{}\u3011, appRegionalismCode:\u3010{}\u3011<<<\u65b0\u589e\u3010{}\u3011\u6761,\u5220\u9664:\u3010{}\u3011\u6761", new Object[]{appId, appRegionalismCode, addCount, deleteCount});
                }
            }
            catch (Exception e) {
                logger.error("\u540c\u6b65\u4eba\u5458\u5e94\u7528\u5173\u7cfb,appId:\u3010{}\u3011, appRegionalismCode:\u3010{}\u3011\u5f02\u5e38:", new Object[]{appId, appRegionalismCode, e});
            }
            return "1";
        }

        private List<SyncPersonApp> computeDeleteSyncPersonApp(Map<String, SyncPersonApp> mapPullSyncPersonApp, Map<String, SyncPersonApp> mapDbSyncPersonApp) {
            ArrayList<SyncPersonApp> listDeleteSyncPersonApp = new ArrayList<SyncPersonApp>();
            for (Map.Entry<String, SyncPersonApp> entry : mapDbSyncPersonApp.entrySet()) {
                String key = entry.getKey();
                SyncPersonApp syncPersonAppDb = mapDbSyncPersonApp.get(key);
                Integer status = syncPersonAppDb.getStatus();
                if (mapPullSyncPersonApp.containsKey(key) || !SyncPersonApp.status_grant_1.equals(status)) continue;
                long currentTimeMillis = System.currentTimeMillis();
                SyncPersonApp value = entry.getValue();
                value.setLastUpdateTime(currentTimeMillis);
                value.setStatus(SyncPersonApp.status_delete_3);
                listDeleteSyncPersonApp.add(value);
            }
            return listDeleteSyncPersonApp;
        }

        private List<SyncPersonApp> computeAddSyncPersonApp(Map<String, SyncPersonApp> mapPullSyncPersonApp, Map<String, SyncPersonApp> mapDbSyncPersonApp) {
            ArrayList<SyncPersonApp> listAddSyncPersonApp = new ArrayList<SyncPersonApp>();
            for (Map.Entry<String, SyncPersonApp> entry : mapPullSyncPersonApp.entrySet()) {
                String key = entry.getKey();
                if (mapDbSyncPersonApp.containsKey(key)) continue;
                long currentTimeMillis = System.currentTimeMillis();
                SyncPersonApp syncPersonApp = entry.getValue();
                syncPersonApp.setPersonAppId(IdGeneratorUtil.nextIdNum());
                syncPersonApp.setStatus(SyncPersonApp.status_grant_1);
                syncPersonApp.setCreateTime(currentTimeMillis);
                syncPersonApp.setLastUpdateTime(currentTimeMillis);
                listAddSyncPersonApp.add(syncPersonApp);
            }
            return listAddSyncPersonApp;
        }

        private List<SyncPersonApp> computeUpdateSyncPersonApp(Map<String, SyncPersonApp> mapPullSyncPersonApp, Map<String, SyncPersonApp> mapDbSyncPersonApp) {
            ArrayList<SyncPersonApp> listUpdateSyncPersonApp = new ArrayList<SyncPersonApp>();
            for (Map.Entry<String, SyncPersonApp> entry : mapPullSyncPersonApp.entrySet()) {
                String key = entry.getKey();
                if (!mapDbSyncPersonApp.containsKey(key)) continue;
                SyncPersonApp syncPersonAppDb = mapDbSyncPersonApp.get(key);
                Integer status = syncPersonAppDb.getStatus();
                if (SyncPersonApp.status_grant_1.intValue() == status.intValue()) continue;
                long currentTimeMillis = System.currentTimeMillis();
                SyncPersonApp syncPersonApp = mapDbSyncPersonApp.get(key);
                syncPersonApp.setStatus(SyncPersonApp.status_grant_1);
                syncPersonApp.setCreateTime(currentTimeMillis);
                syncPersonApp.setLastUpdateTime(currentTimeMillis);
                listUpdateSyncPersonApp.add(syncPersonApp);
            }
            return listUpdateSyncPersonApp;
        }

        private List<SyncPersonApp> pullPersonAppList(String appId, String appRegionalismCode, String appNetworkAreaCode) {
            HashMap<String, Object> mapReqParam = new HashMap<String, Object>();
            mapReqParam.put("pageSize", this.pageSize);
            mapReqParam.put("appId", appId);
            mapReqParam.put("appRegionalismCode", appRegionalismCode);
            long appResourceTotal = 0L;
            String localRegionalismCode = Consts.local_regionalismCode;
            String localNetworkCode = Consts.local_networkAreaCode;
            JSONArray listPerson = new JSONArray();
            int pageNo = 1;
            while (true) {
                mapReqParam.put("pageNo", pageNo);
                JSONArray personList = this.queryOffsitePersonAppList(localRegionalismCode, localNetworkCode, mapReqParam);
                if (logger.isDebugEnabled()) {
                    logger.debug("\u540c\u6b65\u4eba\u5458\u5e94\u7528\u5173\u7cfb,appId:\u3010{}\u3011, appRegionalismCode:\u3010{}\u3011,\u7b2c[{}]\u9875\u6570\u636e:\u3010{}\u3011>>>", new Object[]{appId, appRegionalismCode, pageNo, null != personList ? personList.toJSONString() : null});
                }
                if (!CollectionUtils.isEmpty((Collection)personList)) {
                    listPerson.addAll((Collection)personList);
                    appResourceTotal += (long)personList.size();
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("\u540c\u6b65\u4eba\u5458\u5e94\u7528\u5173\u7cfb,,appId:\u3010{}\u3011, appRegionalismCode:\u3010{}\u3011, pageNo:\u3010{}\u3011, rows:\u3010{}\u3011, total:\u3010{}\u3011<<<", new Object[]{appId, appRegionalismCode, pageNo, personList.toJSONString(), appResourceTotal});
                }
                if (CollectionUtils.isEmpty((Collection)personList) || personList.size() != this.pageSize) {
                    if (!logger.isDebugEnabled()) break;
                    logger.debug("\u540c\u6b65\u4eba\u5458\u5e94\u7528\u5173\u7cfb,appId:\u3010{}\u3011, appRegionalismCode:\u3010{}\u3011\u4e0d\u591f\u4e0b\u4e00\u6b21\u5206\u9875\uff0c\u540c\u6b65\u7ed3\u675f", (Object)appId, (Object)appRegionalismCode);
                    break;
                }
                ++pageNo;
            }
            return this.buildSyncPersonApp(listPerson, appId, appRegionalismCode, appNetworkAreaCode);
        }

        private List<SyncPersonApp> buildSyncPersonApp(JSONArray personList, String appId, String appRegionalismCode, String appNetworkAreaCode) {
            return personList.toJavaList(SyncPersonApp.class);
        }

        private JSONArray queryOffsitePersonAppList(String regionalismCode, String localNetworkCode, Map<String, Object> mapReqParam) {
            JSONArray resultList;
            String json = this.basicInfoSyncService.executeCallIF(regionalismCode, InterfaceCodeEnum.IF_UPM_SVC_03.getCode(), localNetworkCode, CredentialUtil.getAppCredential(), CredentialUtil.getUserCredential(), mapReqParam);
            if (logger.isDebugEnabled()) {
                logger.debug("\u540c\u6b65\u4eba\u5458\u5e94\u7528\u5173\u7cfb,appRegionalismCode:\u3010{}\u3011,appResource:\u3010{}\u3011", (Object)regionalismCode, (Object)json);
            }
            if (StringUtils.isEmpty((Object)json)) {
                logger.debug("\u540c\u6b65\u4eba\u5458\u5e94\u7528\u5173\u7cfb,appRegionalismCode:\u3010{}\u3011\u5217\u8868\u4e3a\u7a7a", (Object)regionalismCode);
                return new JSONArray();
            }
            try {
                JSONObject result = JSON.parseObject((String)json);
                resultList = result.getJSONArray("personList");
            }
            catch (Exception e) {
                logger.error("\u540c\u6b65\u4eba\u5458\u5e94\u7528\u5173\u7cfb,appRegionalismCode:\u3010{}\u3011\u8f6c\u5316\u5f02\u5e38,\u539f\u6570\u636e\u3010{}\u3011", (Object)regionalismCode, (Object)json);
                throw SyncClientException.operateErrorException("\u540c\u6b65\u884c\u653f\u533a\u5212" + regionalismCode + "\u4eba\u5458\u5e94\u7528\u5173\u7cfb\u5217\u8868\u7ed3\u679c\u8f6c\u5316\u5f02\u5e38");
            }
            if (null == resultList) {
                logger.debug("\u540c\u6b65\u4eba\u5458\u5e94\u7528\u5173\u7cfb,appRegionalismCode:\u3010{}\u3011\u5217\u8868\u4e3a\u7a7a", (Object)regionalismCode);
                return new JSONArray();
            }
            return resultList;
        }
    }

    static class LocalPersonAppTask
    implements Callable<String> {
        private int pageSize = 2000;
        private String syncPersonAppRegionalismPath = "/v1/authUserAppController/getUserAppAuthList.do";
        private PersonAppSyncDao personAppSyncDao;
        private BasicPullSmcsFactory basicPullSmcsFactory;
        private SmcsPlatformUtil smcsPlatformUtil;
        private BasicInfoSyncService basicInfoSyncService;
        private SyncApp syncApp = this.syncApp;
        private Long syncPersonAppMaxTime;
        private String uasUrl;
        private String appRegionalismCode;
        private Map<String, String> appIdMap;

        public LocalPersonAppTask(String appRegionalismCode, PersonAppSyncDao personAppSyncDao, BasicInfoSyncService basicInfoSyncService, BasicPullSmcsFactory basicPullSmcsFactory, SmcsPlatformUtil smcsPlatformUtil, Long syncPersonAppMaxTime, String uasUrl, Map<String, String> appIdMap) {
            this.personAppSyncDao = personAppSyncDao;
            this.basicInfoSyncService = basicInfoSyncService;
            this.basicPullSmcsFactory = basicPullSmcsFactory;
            this.smcsPlatformUtil = smcsPlatformUtil;
            this.syncPersonAppMaxTime = syncPersonAppMaxTime;
            this.uasUrl = uasUrl;
            this.appRegionalismCode = appRegionalismCode;
            this.appIdMap = appIdMap;
        }

        @Override
        public String call() throws Exception {
            try {
                this.pullPersonAppList(this.appRegionalismCode, this.syncPersonAppMaxTime);
            }
            catch (Exception e) {
                logger.error("\u540c\u6b65\u4eba\u5458\u5e94\u7528\u5173\u7cfb, appRegionalismCode:\u3010{}\u3011,lastUpdateTime\u3010{}\u3011\u5f02\u5e38:", new Object[]{this.appRegionalismCode, this.syncPersonAppMaxTime, e});
                throw e;
            }
            return "1";
        }

        private List<SyncPersonApp> computeDeleteSyncPersonApp(Map<String, SyncPersonApp> mapPullSyncPersonApp, Map<String, SyncPersonApp> mapDbSyncPersonApp) {
            ArrayList<SyncPersonApp> listDeleteSyncPersonApp = new ArrayList<SyncPersonApp>();
            for (Map.Entry<String, SyncPersonApp> entry : mapDbSyncPersonApp.entrySet()) {
                String key = entry.getKey();
                SyncPersonApp syncPersonAppDb = mapDbSyncPersonApp.get(key);
                Integer status = syncPersonAppDb.getStatus();
                if (mapPullSyncPersonApp.containsKey(key) || !SyncPersonApp.status_grant_1.equals(status)) continue;
                long currentTimeMillis = System.currentTimeMillis();
                SyncPersonApp value = entry.getValue();
                value.setLastUpdateTime(currentTimeMillis);
                value.setStatus(SyncPersonApp.status_delete_3);
                listDeleteSyncPersonApp.add(value);
            }
            return listDeleteSyncPersonApp;
        }

        private List<SyncPersonApp> computeAddSyncPersonApp(Map<String, SyncPersonApp> mapPullSyncPersonApp, Map<String, SyncPersonApp> mapDbSyncPersonApp) {
            ArrayList<SyncPersonApp> listAddSyncPersonApp = new ArrayList<SyncPersonApp>();
            for (Map.Entry<String, SyncPersonApp> entry : mapPullSyncPersonApp.entrySet()) {
                String key = entry.getKey();
                if (mapDbSyncPersonApp.containsKey(key)) continue;
                long currentTimeMillis = System.currentTimeMillis();
                SyncPersonApp syncPersonApp = entry.getValue();
                syncPersonApp.setPersonAppId(IdGeneratorUtil.nextIdNum());
                syncPersonApp.setStatus(SyncPersonApp.status_grant_1);
                syncPersonApp.setCreateTime(currentTimeMillis);
                syncPersonApp.setLastUpdateTime(currentTimeMillis);
                listAddSyncPersonApp.add(syncPersonApp);
            }
            return listAddSyncPersonApp;
        }

        private List<SyncPersonApp> computeUpdateSyncPersonApp(Map<String, SyncPersonApp> mapPullSyncPersonApp, Map<String, SyncPersonApp> mapDbSyncPersonApp) {
            ArrayList<SyncPersonApp> listUpdateSyncPersonApp = new ArrayList<SyncPersonApp>();
            for (Map.Entry<String, SyncPersonApp> entry : mapPullSyncPersonApp.entrySet()) {
                String key = entry.getKey();
                if (!mapDbSyncPersonApp.containsKey(key)) continue;
                SyncPersonApp syncPersonAppDb = mapDbSyncPersonApp.get(key);
                Integer status = syncPersonAppDb.getStatus();
                if (SyncPersonApp.status_grant_1.intValue() == status.intValue()) continue;
                long currentTimeMillis = System.currentTimeMillis();
                SyncPersonApp syncPersonApp = mapDbSyncPersonApp.get(key);
                syncPersonApp.setStatus(SyncPersonApp.status_grant_1);
                syncPersonApp.setCreateTime(currentTimeMillis);
                syncPersonApp.setLastUpdateTime(currentTimeMillis);
                listUpdateSyncPersonApp.add(syncPersonApp);
            }
            return listUpdateSyncPersonApp;
        }

        private void pullPersonAppList(String appRegionalismCode, Long syncPersonAppMaxTime) {
            HashMap<String, Object> mapReqParam = new HashMap<String, Object>();
            mapReqParam.put("pageSize", this.pageSize);
            mapReqParam.put("appRegionalismCode", appRegionalismCode);
            mapReqParam.put("updateTime", syncPersonAppMaxTime);
            long appResourceTotal = 0L;
            String localRegionalismCode = Consts.local_regionalismCode;
            String localNetworkCode = Consts.local_networkAreaCode;
            int pageNo = 1;
            while (true) {
                mapReqParam.put("pageNo", pageNo);
                JSONArray personList = this.queryOffsitePersonAppList(localRegionalismCode, localNetworkCode, mapReqParam);
                if (logger.isDebugEnabled()) {
                    logger.debug("\u540c\u6b65\u4eba\u5458\u5e94\u7528\u5173\u7cfb, appRegionalismCode:\u3010{}\u3011,syncPersonAppMaxTime\u201c\u3010{}\u3011\uff0c\u7b2c[{}]\u9875\u6570\u636e:\u3010{}\u3011>>>", new Object[]{appRegionalismCode, syncPersonAppMaxTime, pageNo, null != personList ? personList.toJSONString() : null});
                }
                if (!CollectionUtils.isEmpty((Collection)personList)) {
                    appResourceTotal += (long)personList.size();
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("\u540c\u6b65\u4eba\u5458\u5e94\u7528\u5173\u7cfb, appRegionalismCode:\u3010{}\u3011, pageNo:\u3010{}\u3011, total:\u3010{}\u3011<<<", new Object[]{appRegionalismCode, pageNo, appResourceTotal});
                }
                List list = personList.toJavaList(SyncPersonApp.class);
                this.saveOrUpdateBatch(appRegionalismCode, list);
                if (CollectionUtils.isEmpty((Collection)personList) || personList.size() != this.pageSize) {
                    if (!logger.isDebugEnabled()) break;
                    logger.debug("\u540c\u6b65\u4eba\u5458\u5e94\u7528\u5173\u7cfb,appRegionalismCode:\u3010{}\u3011\u4e0d\u591f\u4e0b\u4e00\u6b21\u5206\u9875\uff0c\u540c\u6b65\u7ed3\u675f", (Object)appRegionalismCode);
                    break;
                }
                ++pageNo;
            }
        }

        @Transactional(rollbackFor={Exception.class})
        public void saveOrUpdateBatch(String appRegionalismCode, List<SyncPersonApp> listPullSyncPersonApp) {
            ArrayList<SyncPersonApp> updateList = new ArrayList<SyncPersonApp>();
            ArrayList<SyncPersonApp> insertList = new ArrayList<SyncPersonApp>();
            List<String> updateAppIdAndPersonIds = this.personAppSyncDao.queryPersonAppByAppId(listPullSyncPersonApp);
            listPullSyncPersonApp.forEach(syncPersonApp -> {
                long currentTimeMillis = System.currentTimeMillis();
                String networkAreaCode = this.appIdMap.get(syncPersonApp.getAppId());
                syncPersonApp.setLastUpdateTime(syncPersonApp.getCreateTime());
                syncPersonApp.setAppRegionalismCode(appRegionalismCode);
                syncPersonApp.setAppNetworkCode(networkAreaCode);
                String key = syncPersonApp.getAppId() + syncPersonApp.getPersonId();
                if (!CollectionUtils.isEmpty((Collection)updateAppIdAndPersonIds) && updateAppIdAndPersonIds.contains(key)) {
                    updateList.add((SyncPersonApp)syncPersonApp);
                } else {
                    syncPersonApp.setCreateTime(currentTimeMillis);
                    syncPersonApp.setPersonAppId(IdGeneratorUtil.nextIdNum());
                    insertList.add((SyncPersonApp)syncPersonApp);
                }
            });
            this.personAppSyncDao.updatePersonAppStatus(updateList);
            this.personAppSyncDao.savePersonApp(insertList);
            logger.info("\u540c\u6b65\u4eba\u5458\u5e94\u7528\u5173\u7cfb,appRegionalismCode:\u3010{}\u3011<<<\u65b0\u589e\u3010{}\u3011\u6761,\u66f4\u65b0:\u3010{}\u3011\u6761", new Object[]{appRegionalismCode, insertList.size(), updateList.size()});
        }

        private List<SyncPersonApp> buildSyncPersonApp(JSONArray personList, String appId, String appRegionalismCode, String appNetworkAreaCode) {
            return personList.toJavaList(SyncPersonApp.class);
        }

        private JSONArray queryOffsitePersonAppList(String regionalismCode, String localNetworkCode, Map<String, Object> mapReqParam) {
            JSONArray resultList;
            String interfaceUrl = this.uasUrl + this.syncPersonAppRegionalismPath;
            String json = this.basicInfoSyncService.executeCallCustom(interfaceUrl, null, mapReqParam);
            if (logger.isDebugEnabled()) {
                logger.debug("\u540c\u6b65\u4eba\u5458\u5e94\u7528\u5173\u7cfb,appRegionalismCode:\u3010{}\u3011,appResource:\u3010{}\u3011", (Object)regionalismCode, (Object)json);
            }
            if (StringUtils.isEmpty((Object)json)) {
                logger.debug("\u540c\u6b65\u4eba\u5458\u5e94\u7528\u5173\u7cfb,appRegionalismCode:\u3010{}\u3011\u5217\u8868\u4e3a\u7a7a", (Object)regionalismCode);
                return new JSONArray();
            }
            try {
                JSONObject result = JSON.parseObject((String)json);
                resultList = result.getJSONArray("personList");
            }
            catch (Exception e) {
                logger.error("\u540c\u6b65\u4eba\u5458\u5e94\u7528\u5173\u7cfb,appRegionalismCode:\u3010{}\u3011\u8f6c\u5316\u5f02\u5e38,\u539f\u6570\u636e\u3010{}\u3011", (Object)regionalismCode, (Object)json);
                throw SyncClientException.operateErrorException("\u540c\u6b65\u884c\u653f\u533a\u5212" + regionalismCode + "\u4eba\u5458\u5e94\u7528\u5173\u7cfb\u5217\u8868\u7ed3\u679c\u8f6c\u5316\u5f02\u5e38");
            }
            if (null == resultList) {
                logger.debug("\u540c\u6b65\u4eba\u5458\u5e94\u7528\u5173\u7cfb,appRegionalismCode:\u3010{}\u3011\u5217\u8868\u4e3a\u7a7a", (Object)regionalismCode);
                return new JSONArray();
            }
            return resultList;
        }
    }
}

