/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.log.controller;

import com.alibaba.fastjson.JSON;
import com.xdja.log.bean.Dict;
import com.xdja.log.bean.DictReqBean;
import com.xdja.log.bean.LogDetailRepBean;
import com.xdja.log.bean.LogDetailReqBean;
import com.xdja.log.bean.LogListRepBean;
import com.xdja.log.bean.LogListReqBean;
import com.xdja.log.controller.LogBaseController;
import com.xdja.log.enums.LogStatus;
import com.xdja.log.service.BasicLogService;
import com.xdja.sync.bean.common.Page;
import com.xdja.sync.exception.RoamException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class BasicLogController
extends LogBaseController {
    private static final Logger logger = LoggerFactory.getLogger(BasicLogController.class);
    @Autowired
    private BasicLogService basicLogService;

    @RequestMapping(value={"/admin/v1/basicLog/queryLogList", "/admin/v1/basicLog/queryLogList.do"})
    public void list(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LogListReqBean reqBean = new LogListReqBean();
        String contentType = request.getContentType();
        int draw = 0;
        if (contentType.contains("application/json")) {
            reqBean = (LogListReqBean)JSON.parseObject((String)IOUtils.toString((InputStream)request.getInputStream(), (String)"utf-8"), LogListReqBean.class);
        } else {
            String startTime = request.getParameter("startTime");
            String endTime = request.getParameter("endTime");
            String logType = request.getParameter("logType");
            String status = request.getParameter("status");
            String searchKey = request.getParameter("searchKey");
            String pageNo = request.getParameter("pageNo");
            String pageSize = request.getParameter("pageSize");
            String drawTmp = request.getParameter("draw");
            if (!StringUtils.isEmpty((Object)drawTmp)) {
                try {
                    draw = Integer.parseInt(drawTmp);
                }
                catch (Exception e) {
                    draw = 1;
                }
            }
            if (!StringUtils.isEmpty((Object)startTime)) {
                reqBean.setStartTime(Long.parseLong(startTime));
            }
            if (!StringUtils.isEmpty((Object)endTime)) {
                reqBean.setEndTime(Long.parseLong(endTime));
            }
            if (!StringUtils.isEmpty((Object)logType)) {
                reqBean.setLogType(Integer.parseInt(logType));
            }
            if (!StringUtils.isEmpty((Object)status)) {
                reqBean.setStatus(Integer.parseInt(status));
            }
            if (!StringUtils.isEmpty((Object)searchKey)) {
                reqBean.setSearchKey(searchKey);
            }
            if (!StringUtils.isEmpty((Object)pageNo)) {
                reqBean.setPageNo(Integer.parseInt(pageNo));
            }
            if (!StringUtils.isEmpty((Object)pageSize)) {
                reqBean.setPageSize(Integer.parseInt(pageSize));
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("\u5165\u53c2\u4e3a\uff1a", (Object)JSON.toJSONString((Object)reqBean));
        }
        if (reqBean.getPageNo() < 1) {
            throw new RoamException(LogStatus.LOG_PAGE_NO_ERROR.getCode(), LogStatus.LOG_PAGE_NO_ERROR.getDesc());
        }
        if (reqBean.getPageSize() < 5) {
            throw new RoamException(LogStatus.LOG_PAGE_SIZE_ERROR.getCode(), LogStatus.LOG_PAGE_SIZE_ERROR.getDesc());
        }
        if (reqBean.getStartTime() == null || reqBean.getEndTime() == null) {
            throw new RoamException(LogStatus.LOG_TIME_INCOMPLETE.getCode(), LogStatus.LOG_TIME_INCOMPLETE.getDesc());
        }
        Page page = new Page(reqBean.getPageNo(), reqBean.getPageSize());
        List<LogListRepBean> logListRepBeans = this.basicLogService.selectList(reqBean, page);
        page.setDraw(draw);
        if (!CollectionUtils.isEmpty(logListRepBeans)) {
            List list = logListRepBeans.stream().map(tmp -> {
                LogListRepBean logListRepBean = new LogListRepBean();
                BeanUtils.copyProperties((Object)tmp, (Object)logListRepBean);
                return logListRepBean;
            }).collect(Collectors.toList());
            page.setData(list);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("\u51fa\u53c2\u4e3a\uff1a", (Object)JSON.toJSONString((Object)page));
        }
        this.writeAndFlushSuccessResponse(request, response, (Object)page);
    }

    @RequestMapping(value={"/admin/v1/basicLog/queryLogDetail", "/admin/v1/basicLog/queryLogDetail.do"})
    public void detail(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LogDetailReqBean reqBean = new LogDetailReqBean();
        String contentType = request.getContentType();
        if (contentType.contains("application/json")) {
            reqBean = (LogDetailReqBean)JSON.parseObject((String)IOUtils.toString((InputStream)request.getInputStream(), (String)"utf-8"), LogDetailReqBean.class);
        } else {
            String id = request.getParameter("id");
            if (!StringUtils.isEmpty((Object)id)) {
                reqBean.setId(id);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("\u5165\u53c2\u4e3a\uff1a", (Object)JSON.toJSONString((Object)reqBean));
        }
        if (StringUtils.isEmpty((Object)reqBean.getId())) {
            throw new RoamException(LogStatus.LOG_ID_INCOMPLETE.getCode(), LogStatus.LOG_ID_INCOMPLETE.getDesc());
        }
        LogDetailRepBean result = this.basicLogService.getLogDetail(reqBean);
        if (logger.isDebugEnabled()) {
            logger.debug("\u51fa\u53c2\u4e3a\uff1a", (Object)JSON.toJSONString((Object)result));
        }
        this.writeAndFlushSuccessResponse(request, response, (Object)result);
    }

    @RequestMapping(value={"/admin/v1/basicLog/getLogDict", "/admin/v1/basicLog/getLogDict.do"})
    public void getDict(HttpServletRequest request, HttpServletResponse response) throws IOException {
        DictReqBean reqBean = new DictReqBean();
        String contentType = request.getContentType();
        if (contentType.contains("application/json")) {
            reqBean = (DictReqBean)JSON.parseObject((String)IOUtils.toString((InputStream)request.getInputStream(), (String)"utf-8"), DictReqBean.class);
        } else {
            String systemCode = request.getParameter("systemCode");
            if (!StringUtils.isEmpty((Object)systemCode)) {
                reqBean.setSystemCode(systemCode);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("\u5165\u53c2\u4e3a\uff1a", (Object)JSON.toJSONString((Object)reqBean));
        }
        if (StringUtils.isEmpty((Object)reqBean.getSystemCode())) {
            throw new RoamException(LogStatus.LOG_SYSTEM_CODE_INCOMPLETE.getCode(), LogStatus.LOG_SYSTEM_CODE_INCOMPLETE.getDesc());
        }
        List<Dict> result = this.basicLogService.getDicts(reqBean);
        if (logger.isDebugEnabled()) {
            logger.debug("\u51fa\u53c2\u4e3a\uff1a", (Object)JSON.toJSONString(result));
        }
        this.writeAndFlushSuccessResponse(request, response, result);
    }

    @RequestMapping(value={"/admin/v1/basicLog/exportLog", "/admin/v1/basicLog/exportLog.do"})
    public void exportLog(HttpServletRequest request, HttpServletResponse response) {
        try {
            LogListReqBean reqBean = new LogListReqBean();
            String contentType = request.getContentType();
            if (contentType.contains("application/json")) {
                reqBean = (LogListReqBean)JSON.parseObject((String)IOUtils.toString((InputStream)request.getInputStream(), (String)"utf-8"), LogListReqBean.class);
            } else {
                String startTime = request.getParameter("startTime");
                String endTime = request.getParameter("endTime");
                String logType = request.getParameter("logType");
                String status = request.getParameter("status");
                String searchKey = request.getParameter("searchKey");
                String pageNo = request.getParameter("pageNo");
                String pageSize = request.getParameter("pageSize");
                if (!StringUtils.isEmpty((Object)startTime)) {
                    reqBean.setStartTime(Long.parseLong(startTime));
                }
                if (!StringUtils.isEmpty((Object)endTime)) {
                    reqBean.setEndTime(Long.parseLong(endTime));
                }
                if (!StringUtils.isEmpty((Object)logType)) {
                    reqBean.setLogType(Integer.parseInt(logType));
                }
                if (!StringUtils.isEmpty((Object)status)) {
                    reqBean.setStatus(Integer.parseInt(status));
                }
                if (!StringUtils.isEmpty((Object)searchKey)) {
                    reqBean.setSearchKey(searchKey);
                }
                if (!StringUtils.isEmpty((Object)pageNo)) {
                    reqBean.setPageNo(Integer.parseInt(pageNo));
                }
                if (!StringUtils.isEmpty((Object)pageSize)) {
                    reqBean.setPageSize(Integer.parseInt(pageSize));
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug("\u5165\u53c2\u4e3a\uff1a", (Object)JSON.toJSONString((Object)reqBean));
            }
            if (reqBean.getStartTime() == null || reqBean.getEndTime() == null) {
                throw new RoamException(LogStatus.LOG_TIME_INCOMPLETE.getCode(), LogStatus.LOG_TIME_INCOMPLETE.getDesc());
            }
            this.basicLogService.exportLog(reqBean, response);
        }
        catch (Exception e) {
            super.writeAndFlushFailResponse(request, response, -1, "\u5bfc\u51fa\u65e5\u5fd7\u62a5\u8868\u5931\u8d25");
        }
    }
}

