/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.log.enums;

public enum RequestMethod {
    GET(4, "GET"),
    POST(1, "POST"),
    DELETE(2, "DELETE"),
    PUT(4, "PUT");

    private int code;
    private String desc;

    public static String getNameByCode(int code) {
        RequestMethod[] values;
        for (RequestMethod requestMethod : values = RequestMethod.values()) {
            if (requestMethod.getCode() != code) continue;
            return requestMethod.getDesc();
        }
        return GET.getDesc();
    }

    public static int getCodeByName(String name) {
        RequestMethod[] values;
        for (RequestMethod requestMethod : values = RequestMethod.values()) {
            if (!requestMethod.getDesc().equals(name)) continue;
            return requestMethod.getCode();
        }
        return GET.getCode();
    }

    private RequestMethod(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public int getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }
}

