/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.log.util.excel;

import com.xdja.log.bean.ExcelCellBean;
import com.xdja.log.util.excel.ExcelCell;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFCreationHelper;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

public class ExcelUtil {
    private static final Logger logger = LoggerFactory.getLogger(ExcelUtil.class);

    public static void exportExcelDependOnExcelCellAnnotation(OutputStream output, String sheetName, List<?> listData) throws Exception {
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet sheet = wb.createSheet(sheetName);
        HSSFCreationHelper createHelper = wb.getCreationHelper();
        HSSFRow row = sheet.createRow(0);
        row.setHeightInPoints(30.0f);
        HSSFCellStyle cellStyle = wb.createCellStyle();
        cellStyle.setAlignment(HorizontalAlignment.CENTER);
        cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        cellStyle.setBorderBottom(BorderStyle.THIN);
        cellStyle.setBottomBorderColor(IndexedColors.BLACK.getIndex());
        cellStyle.setBorderLeft(BorderStyle.THIN);
        cellStyle.setLeftBorderColor(IndexedColors.BLACK.getIndex());
        cellStyle.setBorderRight(BorderStyle.THIN);
        cellStyle.setRightBorderColor(IndexedColors.BLACK.getIndex());
        cellStyle.setBorderTop(BorderStyle.THIN);
        cellStyle.setTopBorderColor(IndexedColors.BLACK.getIndex());
        HSSFCellStyle cellStyleWithDate = wb.createCellStyle();
        cellStyleWithDate.setAlignment(HorizontalAlignment.CENTER);
        cellStyleWithDate.setVerticalAlignment(VerticalAlignment.CENTER);
        cellStyleWithDate.setBorderBottom(BorderStyle.THIN);
        cellStyleWithDate.setBottomBorderColor(IndexedColors.BLACK.getIndex());
        cellStyleWithDate.setBorderLeft(BorderStyle.THIN);
        cellStyleWithDate.setLeftBorderColor(IndexedColors.BLACK.getIndex());
        cellStyleWithDate.setBorderRight(BorderStyle.THIN);
        cellStyleWithDate.setRightBorderColor(IndexedColors.BLACK.getIndex());
        cellStyleWithDate.setBorderTop(BorderStyle.THIN);
        cellStyleWithDate.setTopBorderColor(IndexedColors.BLACK.getIndex());
        cellStyleWithDate.setDataFormat(createHelper.createDataFormat().getFormat("yyyy/mm/dd hh:mm:ss"));
        HSSFCellStyle cellStyleHead = wb.createCellStyle();
        cellStyleHead.setAlignment(HorizontalAlignment.CENTER);
        cellStyleHead.setVerticalAlignment(VerticalAlignment.CENTER);
        cellStyleHead.setBorderBottom(BorderStyle.THIN);
        cellStyleHead.setBottomBorderColor(IndexedColors.BLACK.getIndex());
        cellStyleHead.setBorderLeft(BorderStyle.THIN);
        cellStyleHead.setLeftBorderColor(IndexedColors.BLACK.getIndex());
        cellStyleHead.setBorderRight(BorderStyle.THIN);
        cellStyleHead.setRightBorderColor(IndexedColors.BLACK.getIndex());
        cellStyleHead.setBorderTop(BorderStyle.THIN);
        cellStyleHead.setTopBorderColor(IndexedColors.BLACK.getIndex());
        cellStyleHead.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.getIndex());
        cellStyleHead.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        Field[] fields = listData.get(0).getClass().getDeclaredFields();
        int x = 0;
        HSSFCell cell = row.createCell(x);
        cell.setCellStyle((CellStyle)cellStyleHead);
        cell.setCellValue("\u5e8f\u53f7");
        sheet.setColumnWidth(x, 2560);
        ++x;
        for (Field field : fields) {
            ExcelCell excelCell = field.getAnnotation(ExcelCell.class);
            if (null == excelCell) continue;
            HSSFCell cellHead = row.createCell(x);
            cellHead.setCellStyle((CellStyle)cellStyleHead);
            cellHead.setCellValue(excelCell.title());
            sheet.setColumnWidth(x, 256 * excelCell.width());
            ++x;
        }
        for (int i = 0; i < listData.size(); ++i) {
            row = sheet.createRow(1 + i);
            row.setHeightInPoints(20.0f);
            Object object = listData.get(i);
            HSSFCell xh = row.createCell(0);
            xh.setCellStyle((CellStyle)cellStyle);
            xh.setCellValue((double)(i + 1));
            int n = 1;
            for (Field field : object.getClass().getDeclaredFields()) {
                ExcelCell excelCell = field.getAnnotation(ExcelCell.class);
                if (null == excelCell) continue;
                field.setAccessible(true);
                HSSFCell data = row.createCell(n);
                if (excelCell.isDate()) {
                    if (null != field.get(object)) {
                        Date date = new Date(Long.parseLong(field.get(object).toString()));
                        data.setCellValue(date);
                        data.setCellStyle((CellStyle)cellStyleWithDate);
                    } else {
                        data.setCellValue("");
                        data.setCellStyle((CellStyle)cellStyleWithDate);
                    }
                } else {
                    if (field.get(object) != null) {
                        data.setCellValue(field.get(object).toString());
                    }
                    data.setCellStyle((CellStyle)cellStyle);
                }
                field.setAccessible(false);
                ++n;
            }
        }
        try {
            output.flush();
            wb.write(output);
        }
        catch (IOException e) {
            logger.error("\u5bfc\u5165Excel\u5f02\u5e38\uff1a", (Throwable)e);
        }
    }

    public static void exportExcelDependOnExcelCellAnnotation(OutputStream output, String sheetName, String title, List<?> listData) throws Exception {
        Field[] fields;
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet sheet = wb.createSheet(sheetName);
        HSSFCreationHelper createHelper = wb.getCreationHelper();
        HSSFCellStyle cellStyle = wb.createCellStyle();
        cellStyle.setAlignment(HorizontalAlignment.CENTER);
        cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        cellStyle.setBorderBottom(BorderStyle.THIN);
        cellStyle.setBottomBorderColor(IndexedColors.BLACK.getIndex());
        cellStyle.setBorderLeft(BorderStyle.THIN);
        cellStyle.setLeftBorderColor(IndexedColors.BLACK.getIndex());
        cellStyle.setBorderRight(BorderStyle.THIN);
        cellStyle.setRightBorderColor(IndexedColors.BLACK.getIndex());
        cellStyle.setBorderTop(BorderStyle.THIN);
        cellStyle.setTopBorderColor(IndexedColors.BLACK.getIndex());
        HSSFCellStyle cellStyleWithDate = wb.createCellStyle();
        cellStyleWithDate.setAlignment(HorizontalAlignment.CENTER);
        cellStyleWithDate.setVerticalAlignment(VerticalAlignment.CENTER);
        cellStyleWithDate.setBorderBottom(BorderStyle.THIN);
        cellStyleWithDate.setBottomBorderColor(IndexedColors.BLACK.getIndex());
        cellStyleWithDate.setBorderLeft(BorderStyle.THIN);
        cellStyleWithDate.setLeftBorderColor(IndexedColors.BLACK.getIndex());
        cellStyleWithDate.setBorderRight(BorderStyle.THIN);
        cellStyleWithDate.setRightBorderColor(IndexedColors.BLACK.getIndex());
        cellStyleWithDate.setBorderTop(BorderStyle.THIN);
        cellStyleWithDate.setTopBorderColor(IndexedColors.BLACK.getIndex());
        cellStyleWithDate.setDataFormat(createHelper.createDataFormat().getFormat("yyyy/mm/dd hh:mm:ss"));
        HSSFCellStyle cellStyleHead = wb.createCellStyle();
        cellStyleHead.setAlignment(HorizontalAlignment.CENTER);
        cellStyleHead.setVerticalAlignment(VerticalAlignment.CENTER);
        cellStyleHead.setBorderBottom(BorderStyle.THIN);
        cellStyleHead.setBottomBorderColor(IndexedColors.BLACK.getIndex());
        cellStyleHead.setBorderLeft(BorderStyle.THIN);
        cellStyleHead.setLeftBorderColor(IndexedColors.BLACK.getIndex());
        cellStyleHead.setBorderRight(BorderStyle.THIN);
        cellStyleHead.setRightBorderColor(IndexedColors.BLACK.getIndex());
        cellStyleHead.setBorderTop(BorderStyle.THIN);
        cellStyleHead.setTopBorderColor(IndexedColors.BLACK.getIndex());
        cellStyleHead.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.getIndex());
        cellStyleHead.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        HSSFCellStyle cellStyleTitle = wb.createCellStyle();
        cellStyleTitle.setAlignment(HorizontalAlignment.CENTER);
        cellStyleTitle.setVerticalAlignment(VerticalAlignment.CENTER);
        cellStyleTitle.setBorderBottom(BorderStyle.THIN);
        cellStyleTitle.setBottomBorderColor(IndexedColors.BLACK.getIndex());
        cellStyleTitle.setBorderLeft(BorderStyle.THIN);
        cellStyleTitle.setLeftBorderColor(IndexedColors.BLACK.getIndex());
        cellStyleTitle.setBorderRight(BorderStyle.THIN);
        cellStyleTitle.setRightBorderColor(IndexedColors.BLACK.getIndex());
        cellStyleTitle.setBorderTop(BorderStyle.THIN);
        cellStyleTitle.setTopBorderColor(IndexedColors.BLACK.getIndex());
        HSSFFont font = wb.createFont();
        font.setFontHeightInPoints((short)13);
        cellStyleTitle.setFont((Font)font);
        HSSFRow row = sheet.createRow(0);
        row = sheet.createRow(1);
        row.setHeightInPoints(30.0f);
        int x = 0;
        HSSFCell cell = row.createCell(0);
        cell.setCellStyle((CellStyle)cellStyleHead);
        cell.setCellValue("\u5e8f\u53f7");
        sheet.setColumnWidth(x, 2560);
        ++x;
        for (Field field : fields = listData.get(0).getClass().getDeclaredFields()) {
            ExcelCell excelCell = field.getAnnotation(ExcelCell.class);
            if (null == excelCell) continue;
            HSSFCell cellHead = row.createCell(x);
            cellHead.setCellStyle((CellStyle)cellStyleHead);
            cellHead.setCellValue(excelCell.title());
            sheet.setColumnWidth(x, 256 * excelCell.width());
            ++x;
        }
        row = sheet.createRow(0);
        row.setHeightInPoints(30.0f);
        HSSFCell titleCell = row.createCell(0);
        titleCell.setCellValue(title);
        titleCell.setCellStyle((CellStyle)cellStyleTitle);
        sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, x - 1));
        for (int i = 0; i < listData.size(); ++i) {
            row = sheet.createRow(2 + i);
            row.setHeightInPoints(20.0f);
            Object object = listData.get(i);
            HSSFCell xh = row.createCell(0);
            xh.setCellStyle((CellStyle)cellStyle);
            xh.setCellValue((double)(i + 1));
            int n = 1;
            for (Field field : object.getClass().getDeclaredFields()) {
                ExcelCell excelCell = field.getAnnotation(ExcelCell.class);
                if (null == excelCell) continue;
                field.setAccessible(true);
                HSSFCell data = row.createCell(n);
                if (excelCell.isDate()) {
                    if (null != field.get(object)) {
                        Date date = new Date(Long.parseLong(field.get(object).toString()));
                        data.setCellValue(date);
                        data.setCellStyle((CellStyle)cellStyleWithDate);
                    } else {
                        data.setCellValue("");
                        data.setCellStyle((CellStyle)cellStyleWithDate);
                    }
                } else {
                    if (field.get(object) != null) {
                        data.setCellValue(field.get(object).toString());
                    }
                    data.setCellStyle((CellStyle)cellStyle);
                }
                field.setAccessible(false);
                ++n;
            }
        }
        try {
            output.flush();
            wb.write(output);
        }
        catch (IOException e) {
            logger.error("\u5bfc\u5165Excel\u5f02\u5e38\uff1a", (Throwable)e);
        }
    }

    public static void exportExcelAsTitleDependOnExcelCellAnnotation(OutputStream output, String sheetName, String title, List<?> listData, List<String> listTitle) throws Exception {
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet sheet = wb.createSheet(sheetName);
        HSSFCreationHelper createHelper = wb.getCreationHelper();
        HSSFCellStyle cellStyle = wb.createCellStyle();
        cellStyle.setAlignment(HorizontalAlignment.CENTER);
        cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        cellStyle.setBorderBottom(BorderStyle.THIN);
        cellStyle.setBottomBorderColor(IndexedColors.BLACK.getIndex());
        cellStyle.setBorderLeft(BorderStyle.THIN);
        cellStyle.setLeftBorderColor(IndexedColors.BLACK.getIndex());
        cellStyle.setBorderRight(BorderStyle.THIN);
        cellStyle.setRightBorderColor(IndexedColors.BLACK.getIndex());
        cellStyle.setBorderTop(BorderStyle.THIN);
        cellStyle.setTopBorderColor(IndexedColors.BLACK.getIndex());
        HSSFCellStyle cellStyleWithDate = wb.createCellStyle();
        cellStyleWithDate.setAlignment(HorizontalAlignment.CENTER);
        cellStyleWithDate.setVerticalAlignment(VerticalAlignment.CENTER);
        cellStyleWithDate.setBorderBottom(BorderStyle.THIN);
        cellStyleWithDate.setBottomBorderColor(IndexedColors.BLACK.getIndex());
        cellStyleWithDate.setBorderLeft(BorderStyle.THIN);
        cellStyleWithDate.setLeftBorderColor(IndexedColors.BLACK.getIndex());
        cellStyleWithDate.setBorderRight(BorderStyle.THIN);
        cellStyleWithDate.setRightBorderColor(IndexedColors.BLACK.getIndex());
        cellStyleWithDate.setBorderTop(BorderStyle.THIN);
        cellStyleWithDate.setTopBorderColor(IndexedColors.BLACK.getIndex());
        cellStyleWithDate.setDataFormat(createHelper.createDataFormat().getFormat("yyyy/mm/dd hh:mm:ss"));
        HSSFCellStyle cellStyleHead = wb.createCellStyle();
        cellStyleHead.setAlignment(HorizontalAlignment.CENTER);
        cellStyleHead.setVerticalAlignment(VerticalAlignment.CENTER);
        cellStyleHead.setBorderBottom(BorderStyle.THIN);
        cellStyleHead.setBottomBorderColor(IndexedColors.BLACK.getIndex());
        cellStyleHead.setBorderLeft(BorderStyle.THIN);
        cellStyleHead.setLeftBorderColor(IndexedColors.BLACK.getIndex());
        cellStyleHead.setBorderRight(BorderStyle.THIN);
        cellStyleHead.setRightBorderColor(IndexedColors.BLACK.getIndex());
        cellStyleHead.setBorderTop(BorderStyle.THIN);
        cellStyleHead.setTopBorderColor(IndexedColors.BLACK.getIndex());
        cellStyleHead.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.getIndex());
        cellStyleHead.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        HSSFCellStyle cellStyleTitle = wb.createCellStyle();
        cellStyleTitle.setAlignment(HorizontalAlignment.CENTER);
        cellStyleTitle.setVerticalAlignment(VerticalAlignment.CENTER);
        cellStyleTitle.setBorderBottom(BorderStyle.THIN);
        cellStyleTitle.setBottomBorderColor(IndexedColors.BLACK.getIndex());
        cellStyleTitle.setBorderLeft(BorderStyle.THIN);
        cellStyleTitle.setLeftBorderColor(IndexedColors.BLACK.getIndex());
        cellStyleTitle.setBorderRight(BorderStyle.THIN);
        cellStyleTitle.setRightBorderColor(IndexedColors.BLACK.getIndex());
        cellStyleTitle.setBorderTop(BorderStyle.THIN);
        cellStyleTitle.setTopBorderColor(IndexedColors.BLACK.getIndex());
        HSSFFont font = wb.createFont();
        font.setFontHeightInPoints((short)13);
        cellStyleTitle.setFont((Font)font);
        HSSFRow row = sheet.createRow(0);
        row = sheet.createRow(1);
        row.setHeightInPoints(30.0f);
        int x = 0;
        HSSFCell cell = row.createCell(0);
        cell.setCellStyle((CellStyle)cellStyleHead);
        cell.setCellValue("\u5e8f\u53f7");
        sheet.setColumnWidth(x, 2560);
        ++x;
        Field[] fields = listData.get(0).getClass().getDeclaredFields();
        int j = 0;
        for (Field field : fields) {
            ExcelCell excelCell = field.getAnnotation(ExcelCell.class);
            if (null == excelCell) continue;
            HSSFCell cellHead = row.createCell(x);
            cellHead.setCellStyle((CellStyle)cellStyleHead);
            cellHead.setCellValue(listTitle.get(j));
            ++j;
            sheet.setColumnWidth(x, 256 * excelCell.width());
            ++x;
        }
        row = sheet.createRow(0);
        row.setHeightInPoints(30.0f);
        HSSFCell titleCell = row.createCell(0);
        titleCell.setCellValue(title);
        titleCell.setCellStyle((CellStyle)cellStyleTitle);
        sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, x - 1));
        for (int i = 0; i < listData.size(); ++i) {
            row = sheet.createRow(2 + i);
            row.setHeightInPoints(20.0f);
            Object object = listData.get(i);
            HSSFCell xh = row.createCell(0);
            xh.setCellStyle((CellStyle)cellStyle);
            xh.setCellValue((double)(i + 1));
            int n = 1;
            for (Field field : object.getClass().getDeclaredFields()) {
                ExcelCell excelCell = field.getAnnotation(ExcelCell.class);
                if (null == excelCell) continue;
                field.setAccessible(true);
                HSSFCell data = row.createCell(n);
                if (excelCell.isDate()) {
                    if (null != field.get(object)) {
                        Date date = new Date(Long.parseLong(field.get(object).toString()));
                        data.setCellValue(date);
                        data.setCellStyle((CellStyle)cellStyleWithDate);
                    } else {
                        data.setCellValue("");
                        data.setCellStyle((CellStyle)cellStyleWithDate);
                    }
                } else {
                    if (field.get(object) != null) {
                        data.setCellValue(field.get(object).toString());
                    }
                    if (IndexedColors.BLACK.index != excelCell.fontColor()) {
                        HSSFCellStyle errorInfoCellStyle = wb.createCellStyle();
                        errorInfoCellStyle.setAlignment(HorizontalAlignment.CENTER);
                        errorInfoCellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
                        errorInfoCellStyle.setBorderBottom(BorderStyle.THIN);
                        errorInfoCellStyle.setBottomBorderColor(IndexedColors.BLACK.getIndex());
                        errorInfoCellStyle.setBorderLeft(BorderStyle.THIN);
                        errorInfoCellStyle.setLeftBorderColor(IndexedColors.BLACK.getIndex());
                        errorInfoCellStyle.setBorderRight(BorderStyle.THIN);
                        errorInfoCellStyle.setRightBorderColor(IndexedColors.BLACK.getIndex());
                        errorInfoCellStyle.setBorderTop(BorderStyle.THIN);
                        errorInfoCellStyle.setTopBorderColor(IndexedColors.BLACK.getIndex());
                        HSSFFont font1 = wb.createFont();
                        font1.setColor(excelCell.fontColor());
                        errorInfoCellStyle.setFont((Font)font1);
                        data.setCellStyle((CellStyle)errorInfoCellStyle);
                    } else {
                        data.setCellStyle((CellStyle)cellStyle);
                    }
                }
                field.setAccessible(false);
                ++n;
            }
        }
        try {
            output.flush();
            wb.write(output);
        }
        catch (IOException e) {
            logger.error("\u5bfc\u5165Excel\u5f02\u5e38\uff1a", (Throwable)e);
        }
    }

    public static void exportExcelDependOnExcelCellAnnotation(OutputStream output, String sheetName, List<?> listData, Class<?> clazz) throws Exception {
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet sheet = wb.createSheet(sheetName);
        HSSFCreationHelper createHelper = wb.getCreationHelper();
        HSSFRow row = sheet.createRow(0);
        row.setHeightInPoints(30.0f);
        HSSFCellStyle cellStyle = wb.createCellStyle();
        cellStyle.setAlignment(HorizontalAlignment.CENTER);
        cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        cellStyle.setBorderBottom(BorderStyle.THIN);
        cellStyle.setBottomBorderColor(IndexedColors.BLACK.getIndex());
        cellStyle.setBorderLeft(BorderStyle.THIN);
        cellStyle.setLeftBorderColor(IndexedColors.BLACK.getIndex());
        cellStyle.setBorderRight(BorderStyle.THIN);
        cellStyle.setRightBorderColor(IndexedColors.BLACK.getIndex());
        cellStyle.setBorderTop(BorderStyle.THIN);
        cellStyle.setTopBorderColor(IndexedColors.BLACK.getIndex());
        HSSFCellStyle cellStyleWithDate = wb.createCellStyle();
        cellStyleWithDate.setAlignment(HorizontalAlignment.CENTER);
        cellStyleWithDate.setVerticalAlignment(VerticalAlignment.CENTER);
        cellStyleWithDate.setBorderBottom(BorderStyle.THIN);
        cellStyleWithDate.setBottomBorderColor(IndexedColors.BLACK.getIndex());
        cellStyleWithDate.setBorderLeft(BorderStyle.THIN);
        cellStyleWithDate.setLeftBorderColor(IndexedColors.BLACK.getIndex());
        cellStyleWithDate.setBorderRight(BorderStyle.THIN);
        cellStyleWithDate.setRightBorderColor(IndexedColors.BLACK.getIndex());
        cellStyleWithDate.setBorderTop(BorderStyle.THIN);
        cellStyleWithDate.setTopBorderColor(IndexedColors.BLACK.getIndex());
        cellStyleWithDate.setDataFormat(createHelper.createDataFormat().getFormat("yyyy/mm/dd hh:mm:ss"));
        HSSFCellStyle cellStyleHead = wb.createCellStyle();
        cellStyleHead.setAlignment(HorizontalAlignment.CENTER);
        cellStyleHead.setVerticalAlignment(VerticalAlignment.CENTER);
        cellStyleHead.setBorderBottom(BorderStyle.THIN);
        cellStyleHead.setBottomBorderColor(IndexedColors.BLACK.getIndex());
        cellStyleHead.setBorderLeft(BorderStyle.THIN);
        cellStyleHead.setLeftBorderColor(IndexedColors.BLACK.getIndex());
        cellStyleHead.setBorderRight(BorderStyle.THIN);
        cellStyleHead.setRightBorderColor(IndexedColors.BLACK.getIndex());
        cellStyleHead.setBorderTop(BorderStyle.THIN);
        cellStyleHead.setTopBorderColor(IndexedColors.BLACK.getIndex());
        cellStyleHead.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.getIndex());
        cellStyleHead.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        Field[] fields = clazz.getDeclaredFields();
        int x = 0;
        HSSFCell cell = row.createCell(x);
        cell.setCellStyle((CellStyle)cellStyleHead);
        cell.setCellValue("\u5e8f\u53f7");
        sheet.setColumnWidth(x, 2560);
        ++x;
        List<Object> cellList = new ArrayList();
        for (Field field : fields) {
            ExcelCell excelCell = field.getAnnotation(ExcelCell.class);
            if (null == excelCell) continue;
            cellList.add(new ExcelCellBean(excelCell.order(), excelCell.title(), excelCell.width()));
        }
        cellList = cellList.stream().sorted(Comparator.comparing(ExcelCellBean::getOrder)).collect(Collectors.toList());
        for (ExcelCellBean excelCellBean : cellList) {
            HSSFCell cellHead = row.createCell(x);
            cellHead.setCellStyle((CellStyle)cellStyleHead);
            cellHead.setCellValue(excelCellBean.getTitle());
            sheet.setColumnWidth(x, 256 * excelCellBean.getWidth());
            ++x;
        }
        for (int i = 0; i < listData.size(); ++i) {
            row = sheet.createRow(1 + i);
            row.setHeightInPoints(20.0f);
            Object obj = listData.get(i);
            HSSFCell xh = row.createCell(0);
            xh.setCellStyle((CellStyle)cellStyle);
            xh.setCellValue((double)(i + 1));
            int n = 1;
            for (Field field : obj.getClass().getDeclaredFields()) {
                ExcelCell excelCell = field.getAnnotation(ExcelCell.class);
                if (null == excelCell) continue;
                field.setAccessible(true);
                HSSFCell data = row.createCell(n);
                if (excelCell.isDate()) {
                    if (null != field.get(obj)) {
                        Date date = new Date(Long.parseLong(field.get(obj).toString()));
                        data.setCellValue(date);
                        data.setCellStyle((CellStyle)cellStyleWithDate);
                    } else {
                        data.setCellValue("");
                        data.setCellStyle((CellStyle)cellStyleWithDate);
                    }
                } else {
                    if (field.get(obj) != null) {
                        data.setCellValue(field.get(obj).toString());
                    }
                    data.setCellStyle((CellStyle)cellStyle);
                }
                field.setAccessible(false);
                ++n;
            }
        }
        try {
            output.flush();
            wb.write(output);
        }
        catch (IOException e) {
            logger.error("\u5bfc\u5165Excel\u5f02\u5e38\uff1a", (Throwable)e);
        }
    }

    public static void exportExcelAndZipDependOnExcelCellAnnotation(OutputStream output, int length, String sheetName, List<?> listData) throws Exception {
        int readLength;
        Field[] fields = listData.get(0).getClass().getDeclaredFields();
        ArrayList<String> fileNames = new ArrayList<String>();
        File zip = new File("temp.zip");
        int m = listData.size() / length + 1;
        for (int j = 0; j < m; ++j) {
            int min;
            HSSFWorkbook wb = new HSSFWorkbook();
            HSSFCreationHelper createHelper = wb.getCreationHelper();
            HSSFCellStyle cellStyle = wb.createCellStyle();
            cellStyle.setAlignment(HorizontalAlignment.CENTER);
            cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
            cellStyle.setBorderBottom(BorderStyle.THIN);
            cellStyle.setBottomBorderColor(IndexedColors.BLACK.getIndex());
            cellStyle.setBorderLeft(BorderStyle.THIN);
            cellStyle.setLeftBorderColor(IndexedColors.BLACK.getIndex());
            cellStyle.setBorderRight(BorderStyle.THIN);
            cellStyle.setRightBorderColor(IndexedColors.BLACK.getIndex());
            cellStyle.setBorderTop(BorderStyle.THIN);
            cellStyle.setTopBorderColor(IndexedColors.BLACK.getIndex());
            HSSFCellStyle cellStyleWithDate = wb.createCellStyle();
            cellStyleWithDate.setAlignment(HorizontalAlignment.CENTER);
            cellStyleWithDate.setVerticalAlignment(VerticalAlignment.CENTER);
            cellStyleWithDate.setBorderBottom(BorderStyle.THIN);
            cellStyleWithDate.setBottomBorderColor(IndexedColors.BLACK.getIndex());
            cellStyleWithDate.setBorderLeft(BorderStyle.THIN);
            cellStyleWithDate.setLeftBorderColor(IndexedColors.BLACK.getIndex());
            cellStyleWithDate.setBorderRight(BorderStyle.THIN);
            cellStyleWithDate.setRightBorderColor(IndexedColors.BLACK.getIndex());
            cellStyleWithDate.setBorderTop(BorderStyle.THIN);
            cellStyleWithDate.setTopBorderColor(IndexedColors.BLACK.getIndex());
            cellStyleWithDate.setDataFormat(createHelper.createDataFormat().getFormat("yyyy/mm/dd hh:mm:ss"));
            HSSFCellStyle cellStyleHead = wb.createCellStyle();
            cellStyleHead.setAlignment(HorizontalAlignment.CENTER);
            cellStyleHead.setVerticalAlignment(VerticalAlignment.CENTER);
            cellStyleHead.setBorderBottom(BorderStyle.THIN);
            cellStyleHead.setBottomBorderColor(IndexedColors.BLACK.getIndex());
            cellStyleHead.setBorderLeft(BorderStyle.THIN);
            cellStyleHead.setLeftBorderColor(IndexedColors.BLACK.getIndex());
            cellStyleHead.setBorderRight(BorderStyle.THIN);
            cellStyleHead.setRightBorderColor(IndexedColors.BLACK.getIndex());
            cellStyleHead.setBorderTop(BorderStyle.THIN);
            cellStyleHead.setTopBorderColor(IndexedColors.BLACK.getIndex());
            cellStyleHead.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.getIndex());
            cellStyleHead.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            HSSFSheet sheet = wb.createSheet(sheetName + (length * j + 1) + "-" + (listData.size() - j * length + 1 > length + 1 ? length * (j + 1) : listData.size()));
            HSSFRow row = sheet.createRow(0);
            row.setHeightInPoints(30.0f);
            int x = 0;
            HSSFCell cell = row.createCell(x);
            cell.setCellStyle((CellStyle)cellStyleHead);
            cell.setCellValue("\u5e8f\u53f7");
            sheet.setColumnWidth(x, 2560);
            ++x;
            String file = "data_" + (length * j + 1) + "-" + (listData.size() - j * length + 1 > length + 1 ? length * (j + 1) : listData.size()) + ".xls";
            fileNames.add(file);
            FileOutputStream o = null;
            o = new FileOutputStream(file);
            for (Field field : fields) {
                ExcelCell excelCell = field.getAnnotation(ExcelCell.class);
                if (null == excelCell) continue;
                HSSFCell cellHead = row.createCell(x);
                cellHead.setCellStyle((CellStyle)cellStyleHead);
                cellHead.setCellValue(excelCell.title());
                sheet.setColumnWidth(x, 256 * excelCell.width());
                ++x;
            }
            int n = min = listData.size() - j * length + 1 > length + 1 ? length + 1 : listData.size() - j * length + 1;
            for (int i = 1; i < min; ++i) {
                row = sheet.createRow(0 + i);
                row.setHeightInPoints(20.0f);
                Object object = listData.get(length * j + i - 1);
                HSSFCell xh = row.createCell(0);
                xh.setCellStyle((CellStyle)cellStyle);
                xh.setCellValue((double)(length * j + i));
                int n2 = 1;
                for (Field field : object.getClass().getDeclaredFields()) {
                    ExcelCell excelCell = field.getAnnotation(ExcelCell.class);
                    if (null == excelCell) continue;
                    field.setAccessible(true);
                    HSSFCell data = row.createCell(n2);
                    if (excelCell.isDate()) {
                        if (null != field.get(object)) {
                            Date date = new Date(Long.parseLong(field.get(object).toString()));
                            data.setCellValue(date);
                            data.setCellStyle((CellStyle)cellStyleWithDate);
                        } else {
                            data.setCellValue("");
                            data.setCellStyle((CellStyle)cellStyleWithDate);
                        }
                    } else {
                        if (field.get(object) != null) {
                            data.setCellValue(field.get(object).toString());
                        }
                        data.setCellStyle((CellStyle)cellStyle);
                    }
                    field.setAccessible(false);
                    ++n2;
                }
            }
            wb.write((OutputStream)o);
            o.flush();
            o.close();
        }
        File[] srcfile = new File[fileNames.size()];
        int n = fileNames.size();
        for (int i = 0; i < n; ++i) {
            srcfile[i] = new File((String)fileNames.get(i));
        }
        ExcelUtil.ZipFiles(srcfile, zip);
        FileInputStream inStream = new FileInputStream(zip);
        byte[] buf = new byte[4096];
        while ((readLength = inStream.read(buf)) != -1) {
            output.write(buf, 0, readLength);
        }
        inStream.close();
        int n3 = fileNames.size();
        for (int i = 0; i < n3; ++i) {
            FileUtils.forceDelete((File)new File((String)fileNames.get(i)));
        }
        FileUtils.forceDelete((File)zip);
    }

    public static void ZipFiles(File[] srcfile, File zipfile) {
        byte[] buf = new byte[1024];
        try {
            ZipOutputStream out = new ZipOutputStream(new FileOutputStream(zipfile));
            for (int i = 0; i < srcfile.length; ++i) {
                int len;
                FileInputStream in = new FileInputStream(srcfile[i]);
                out.putNextEntry(new ZipEntry(srcfile[i].getName()));
                while ((len = in.read(buf)) > 0) {
                    out.write(buf, 0, len);
                }
                out.closeEntry();
                in.close();
            }
            out.close();
        }
        catch (IOException e) {
            logger.error("\u538b\u7f29\u6587\u4ef6\u5f02\u5e38\uff1a", (Throwable)e);
        }
    }

    public static void exportExcel(OutputStream output, String sheetName, List<String> listTitle, List<Object[]> listData) throws Exception {
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet sheet = wb.createSheet(sheetName);
        HSSFCreationHelper createHelper = wb.getCreationHelper();
        HSSFCellStyle cellStyle = wb.createCellStyle();
        cellStyle.setAlignment(HorizontalAlignment.CENTER);
        cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        cellStyle.setBorderBottom(BorderStyle.THIN);
        cellStyle.setBottomBorderColor(IndexedColors.BLACK.getIndex());
        cellStyle.setBorderLeft(BorderStyle.THIN);
        cellStyle.setLeftBorderColor(IndexedColors.BLACK.getIndex());
        cellStyle.setBorderRight(BorderStyle.THIN);
        cellStyle.setRightBorderColor(IndexedColors.BLACK.getIndex());
        cellStyle.setBorderTop(BorderStyle.THIN);
        cellStyle.setTopBorderColor(IndexedColors.BLACK.getIndex());
        HSSFCellStyle cellStyleWithDate = wb.createCellStyle();
        cellStyleWithDate.setAlignment(HorizontalAlignment.CENTER);
        cellStyleWithDate.setVerticalAlignment(VerticalAlignment.CENTER);
        cellStyleWithDate.setBorderBottom(BorderStyle.THIN);
        cellStyleWithDate.setBottomBorderColor(IndexedColors.BLACK.getIndex());
        cellStyleWithDate.setBorderLeft(BorderStyle.THIN);
        cellStyleWithDate.setLeftBorderColor(IndexedColors.BLACK.getIndex());
        cellStyleWithDate.setBorderRight(BorderStyle.THIN);
        cellStyleWithDate.setRightBorderColor(IndexedColors.BLACK.getIndex());
        cellStyleWithDate.setBorderTop(BorderStyle.THIN);
        cellStyleWithDate.setTopBorderColor(IndexedColors.BLACK.getIndex());
        cellStyleWithDate.setDataFormat(createHelper.createDataFormat().getFormat("yyyy/mm/dd hh:mm:ss"));
        HSSFCellStyle cellStyleHead = wb.createCellStyle();
        cellStyleHead.setAlignment(HorizontalAlignment.CENTER);
        cellStyleHead.setVerticalAlignment(VerticalAlignment.CENTER);
        cellStyleHead.setBorderBottom(BorderStyle.DOUBLE);
        cellStyleHead.setBottomBorderColor(IndexedColors.BLACK.getIndex());
        cellStyleHead.setBorderLeft(BorderStyle.THIN);
        cellStyleHead.setLeftBorderColor(IndexedColors.BLACK.getIndex());
        cellStyleHead.setBorderRight(BorderStyle.THIN);
        cellStyleHead.setRightBorderColor(IndexedColors.BLACK.getIndex());
        cellStyleHead.setBorderTop(BorderStyle.THIN);
        cellStyleHead.setTopBorderColor(IndexedColors.BLACK.getIndex());
        cellStyleHead.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.getIndex());
        cellStyleHead.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        HSSFCellStyle cellStyleTitle = wb.createCellStyle();
        cellStyleTitle.setAlignment(HorizontalAlignment.CENTER);
        cellStyleTitle.setVerticalAlignment(VerticalAlignment.CENTER);
        cellStyleTitle.setBorderBottom(BorderStyle.THIN);
        cellStyleTitle.setBottomBorderColor(IndexedColors.BLACK.getIndex());
        cellStyleTitle.setBorderLeft(BorderStyle.THIN);
        cellStyleTitle.setLeftBorderColor(IndexedColors.BLACK.getIndex());
        cellStyleTitle.setBorderRight(BorderStyle.THIN);
        cellStyleTitle.setRightBorderColor(IndexedColors.BLACK.getIndex());
        cellStyleTitle.setBorderTop(BorderStyle.THIN);
        cellStyleTitle.setTopBorderColor(IndexedColors.BLACK.getIndex());
        HSSFFont font = wb.createFont();
        font.setFontHeightInPoints((short)13);
        cellStyleTitle.setFont((Font)font);
        int rowIndex = 0;
        HSSFRow row = sheet.createRow(rowIndex);
        row.setHeightInPoints(30.0f);
        int cellIndex = 0;
        HSSFCell rowCell = row.createCell(0);
        rowCell.setCellStyle((CellStyle)cellStyleHead);
        rowCell.setCellValue("\u5e8f\u53f7");
        sheet.setColumnWidth(cellIndex, 2560);
        ++cellIndex;
        for (String title : listTitle) {
            rowCell = row.createCell(cellIndex);
            rowCell.setCellStyle((CellStyle)cellStyleHead);
            rowCell.setCellValue(title);
            sheet.setColumnWidth(cellIndex, 12800);
            ++cellIndex;
        }
        ++rowIndex;
        for (int i = 0; i < listData.size(); ++i) {
            Object[] aryData;
            row = sheet.createRow(rowIndex);
            row.setHeightInPoints(20.0f);
            int dataCellIndex = 0;
            rowCell = row.createCell(dataCellIndex);
            rowCell.setCellStyle((CellStyle)cellStyle);
            rowCell.setCellValue((double)rowIndex);
            ++dataCellIndex;
            for (Object tmp : aryData = listData.get(i)) {
                rowCell = row.createCell(dataCellIndex);
                if (null == tmp) {
                    rowCell.setCellValue("");
                    rowCell.setCellStyle((CellStyle)cellStyleWithDate);
                } else if (tmp instanceof Date) {
                    rowCell.setCellValue((Date)tmp);
                    rowCell.setCellStyle((CellStyle)cellStyleWithDate);
                } else {
                    rowCell.setCellValue(null == tmp ? "" : tmp.toString());
                    rowCell.setCellStyle((CellStyle)cellStyle);
                }
                ++dataCellIndex;
            }
            ++rowIndex;
        }
        try {
            output.flush();
            wb.write(output);
        }
        catch (IOException e) {
            logger.error("\u5bfc\u51faExcel\u51fa\u9519:", (Throwable)e);
        }
    }

    public static void exportExcel(String title, OutputStream output, String sheetName, List<Map<String, Object>> listData, String[] heanderNames, String[] keys) throws Exception {
        HSSFWorkbook wb = new HSSFWorkbook();
        CellStyle titleCellStyle = ExcelUtil.createTitleCellStyle(wb);
        CellStyle headCellStyle = ExcelUtil.createHeadCellStyle(wb);
        CellStyle normalCellStyle = ExcelUtil.createNormalCellStyle(wb);
        HSSFSheet sheet = wb.createSheet(sheetName);
        sheet.createFreezePane(0, 2);
        HSSFRow titleRow = sheet.createRow(0);
        titleRow.setHeightInPoints(60.0f);
        HSSFRow row = sheet.createRow(1);
        row.setHeightInPoints(30.0f);
        int x = 0;
        HSSFCell titleCell = titleRow.createCell(x);
        titleCell.setCellStyle(titleCellStyle);
        titleCell.setCellValue(title);
        HSSFCell cellHead = row.createCell(x);
        cellHead.setCellStyle(headCellStyle);
        cellHead.setCellValue("\u5e8f\u53f7");
        sheet.setColumnWidth(x, 1280);
        ++x;
        if (listData == null || heanderNames == null || keys == null || heanderNames.length != keys.length) {
            logger.error("\u6570\u636e\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u65e0\u6cd5\u8fdb\u884c\u5bfc\u51faexcel\u64cd\u4f5c\uff01");
            throw new Exception("\u6570\u636e\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u65e0\u6cd5\u8fdb\u884c\u5bfc\u51faexcel\u64cd\u4f5c\uff01");
        }
        for (String header : heanderNames) {
            titleCell = titleRow.createCell(x);
            titleCell.setCellStyle(titleCellStyle);
            cellHead = row.createCell(x);
            cellHead.setCellStyle(headCellStyle);
            cellHead.setCellValue(header);
            sheet.setColumnWidth(x, 5120);
            ++x;
        }
        sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, (int)((short)heanderNames.length)));
        for (int i = 0; i < listData.size(); ++i) {
            row = sheet.createRow(2 + i);
            row.setHeightInPoints(20.0f);
            HSSFCell xh = row.createCell(0);
            xh.setCellStyle(normalCellStyle);
            xh.setCellValue((double)(i + 1));
            HSSFCell data = null;
            int n = 1;
            String value = null;
            Map<String, Object> map = listData.get(i);
            for (String key : keys) {
                data = row.createCell(n++);
                value = map.get(key) == null ? "" : map.get(key).toString();
                data.setCellValue(!StringUtils.isEmpty((Object)value) ? value : "");
                data.setCellStyle(normalCellStyle);
            }
        }
        try {
            output.flush();
            wb.write(output);
        }
        catch (IOException e) {
            logger.error("\u5bfc\u5165Excel\u5f02\u5e38\uff1a", (Throwable)e);
        }
    }

    private static CellStyle createTitleCellStyle(HSSFWorkbook hssfWorkbook) {
        HSSFCellStyle titleCellStyle = hssfWorkbook.createCellStyle();
        titleCellStyle.setAlignment(HorizontalAlignment.CENTER);
        titleCellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        titleCellStyle.setBorderBottom(BorderStyle.MEDIUM);
        titleCellStyle.setBottomBorderColor(IndexedColors.BLACK.getIndex());
        titleCellStyle.setBorderLeft(BorderStyle.THIN);
        titleCellStyle.setLeftBorderColor(IndexedColors.BLACK.getIndex());
        titleCellStyle.setBorderRight(BorderStyle.THIN);
        titleCellStyle.setRightBorderColor(IndexedColors.BLACK.getIndex());
        titleCellStyle.setBorderTop(BorderStyle.THIN);
        titleCellStyle.setTopBorderColor(IndexedColors.BLACK.getIndex());
        titleCellStyle.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.getIndex());
        titleCellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        HSSFFont font = hssfWorkbook.createFont();
        font.setFontHeightInPoints((short)24);
        titleCellStyle.setFont((Font)font);
        return titleCellStyle;
    }

    private static CellStyle createHeadCellStyle(HSSFWorkbook hssfWorkbook) {
        HSSFCellStyle headCellStyle = hssfWorkbook.createCellStyle();
        headCellStyle.setAlignment(HorizontalAlignment.CENTER);
        headCellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        headCellStyle.setBorderBottom(BorderStyle.MEDIUM);
        headCellStyle.setBottomBorderColor(IndexedColors.BLACK.getIndex());
        headCellStyle.setBorderLeft(BorderStyle.THIN);
        headCellStyle.setLeftBorderColor(IndexedColors.BLACK.getIndex());
        headCellStyle.setBorderRight(BorderStyle.THIN);
        headCellStyle.setRightBorderColor(IndexedColors.BLACK.getIndex());
        headCellStyle.setBorderTop(BorderStyle.THIN);
        headCellStyle.setTopBorderColor(IndexedColors.BLACK.getIndex());
        headCellStyle.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.getIndex());
        headCellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        return headCellStyle;
    }

    private static CellStyle createNormalCellStyle(HSSFWorkbook hssfWorkbook) {
        HSSFCellStyle normalCellStyle = hssfWorkbook.createCellStyle();
        normalCellStyle.setAlignment(HorizontalAlignment.CENTER);
        normalCellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        normalCellStyle.setBorderBottom(BorderStyle.THIN);
        normalCellStyle.setBottomBorderColor(IndexedColors.BLACK.getIndex());
        normalCellStyle.setBorderLeft(BorderStyle.THIN);
        normalCellStyle.setLeftBorderColor(IndexedColors.BLACK.getIndex());
        normalCellStyle.setBorderRight(BorderStyle.THIN);
        normalCellStyle.setRightBorderColor(IndexedColors.BLACK.getIndex());
        normalCellStyle.setBorderTop(BorderStyle.THIN);
        normalCellStyle.setTopBorderColor(IndexedColors.BLACK.getIndex());
        normalCellStyle.setWrapText(true);
        return normalCellStyle;
    }

    public static Sheet parseExcel(MultipartFile multipartFile, int sheetNum) throws IOException {
        if (multipartFile == null) {
            return null;
        }
        InputStream is = multipartFile.getInputStream();
        String version = multipartFile.getOriginalFilename().endsWith(".xls") ? "2003" : "2007";
        XSSFSheet sheet = null;
        if ("2003".equals(version)) {
            POIFSFileSystem fs = new POIFSFileSystem(is);
            HSSFWorkbook wb = new HSSFWorkbook(fs);
            sheet = wb.getSheetAt(sheetNum);
        } else {
            XSSFWorkbook xwb = new XSSFWorkbook(is);
            sheet = xwb.getSheetAt(sheetNum);
        }
        return sheet;
    }

    public static void downloadExcel(HttpServletResponse response, String excelName, String sheetName, List<?> listData, Class<?> clazz) throws Exception {
        response.setContentType("application/vnd.ms-excel;charset=UTF-8");
        response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(excelName + ".xlsx", "UTF-8"));
        response.setHeader("code", "0");
        ExcelUtil.exportExcelDependOnExcelCellAnnotation((OutputStream)response.getOutputStream(), sheetName, listData, clazz);
    }

    public static void downloadExcel(HttpServletResponse response, String excelName, String sheetName, String title, List<Map<String, Object>> listData, String[] heanderNames, String[] keys) throws Exception {
        response.setContentType("application/vnd.ms-excel;charset=UTF-8");
        response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(excelName + ".xlsx", "UTF-8"));
        response.setHeader("code", "0");
        ExcelUtil.exportExcel(title, (OutputStream)response.getOutputStream(), sheetName, listData, heanderNames, keys);
    }

    public static void downloadExcel(HttpServletResponse response, String excelName, List<String> listTitle, List<Object[]> listData) throws Exception {
        response.setContentType("application/vnd.ms-excel;charset=UTF-8");
        response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(excelName + ".xlsx", "UTF-8"));
        response.setHeader("code", "0");
        ExcelUtil.exportExcel((OutputStream)response.getOutputStream(), excelName, listTitle, listData);
    }
}

