/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.sync.handler;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xdja.common.BisRedisUtil;
import com.xdja.common.RedisKeyConst;
import com.xdja.sync.bean.SyncPerson;
import com.xdja.sync.bean.SyncPersonDevice;
import com.xdja.sync.bean.common.Consts;
import com.xdja.sync.dao.PersonDeviceSyncDao;
import com.xdja.sync.enums.InterfaceCodeEnum;
import com.xdja.sync.enums.TableEnum;
import com.xdja.sync.exception.SyncClientException;
import com.xdja.sync.exception.SyncClientExceptionCode;
import com.xdja.sync.handler.AbstractSyncHandler;
import com.xdja.sync.handler.SyncHandlerThreadFactory;
import com.xdja.sync.service.BasicInfoSyncService;
import com.xdja.sync.service.BasicSyncPersonService;
import com.xdja.sync.util.CredentialUtil;
import com.xdja.sync.util.IdGeneratorUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Component
public class PersonDeviceSyncIncrementHandler
extends AbstractSyncHandler {
    private static final Logger logger = LoggerFactory.getLogger(PersonDeviceSyncIncrementHandler.class);
    @Autowired
    private Environment environment;
    @Autowired
    private BasicInfoSyncService basicInfoSyncService;
    @Autowired
    private BasicSyncPersonService basicSyncPersonService;
    @Autowired
    private PersonDeviceSyncDao personDeviceSyncDao;
    private Long syncPersonDeviceInterval;
    private String syncPersonDeviceSwitch;
    private volatile boolean syncPersonAppRunning = false;
    private int pageSize = Consts.SYNC_DEFAULT_PAGE_SIZE;

    @Override
    String getPoolName() {
        return "personDevice";
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void handler(TableEnum[] tableEnums, ScheduledExecutorService executorService) {
        this.syncPersonDeviceSwitch = this.environment.getProperty("sync.personDevice.switch", "on");
        if ("off".equalsIgnoreCase(this.syncPersonDeviceSwitch)) {
            logger.info("\u540c\u6b65\u4eba\u5458\u8bbe\u5907\u6743\u9650\u5173\u7cfb\u672a\u5f00\u542f\uff0c\u5982\u9700\u5f00\u542f\u8bf7\u6dfb\u52a0\u6216\u4fee\u6539\u914d\u7f6e\u9879sync.personDevice.switch=on");
            return;
        }
        if (null == executorService) {
            executorService = SyncHandlerThreadFactory.getScheduledExecutorService(this.getPoolName());
        }
        String property = this.environment.getProperty("sync.personDevice.interval", "300");
        this.syncPersonDeviceInterval = Long.parseLong(property);
        executorService.scheduleWithFixedDelay(() -> {
            try {
                logger.info("\u540c\u6b65\u4eba\u5458\u8bbe\u5907\u6743\u9650\u5173\u7cfb\uff0c\u540c\u6b65\u9891\u7387\u914d\u7f6e\u9879sync.personDevice.interval[{}]\u79d2", (Object)this.syncPersonDeviceInterval);
                for (TableEnum tableEnum : tableEnums) {
                    if (!TableEnum.TABLE_PERSON_DEVICE.getTableName().equals(tableEnum.getTableName())) continue;
                    this.syncPersonDevice();
                }
            }
            catch (Exception e) {
                logger.error("\u540c\u6b65\u4eba\u5458\u8bbe\u5907\u5173\u7cfb\u5f02\u5e38:", (Throwable)e);
            }
        }, SyncHandlerThreadFactory.getSyncInitialDelay(), this.syncPersonDeviceInterval, TimeUnit.SECONDS);
    }

    @Transactional(rollbackFor={Exception.class})
    public int syncPersonDevice() {
        ArrayList<SyncPerson> listSyncApp = new ArrayList<SyncPerson>();
        return this.syncPersonDevice(listSyncApp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(rollbackFor={Exception.class})
    public int syncPersonDevice(List<SyncPerson> listSyncPerson) {
        boolean existRedis;
        if (logger.isDebugEnabled()) {
            logger.debug("\u540c\u6b65\u4eba\u5458\u8bbe\u5907\u5173\u7cfb\u4fe1\u606f>>>>>>");
        }
        String lockKey = RedisKeyConst.getLockSyncPersonDeviceKey("increment");
        long timeout = 600L;
        String lockValue = BisRedisUtil.getExpireMillis(timeout);
        boolean lock = false;
        boolean bl = existRedis = null != BisRedisUtil.getStringRedisTemplate();
        if (existRedis) {
            lock = BisRedisUtil.tryLock(lockKey, lockValue);
            if (!lock) {
                logger.error("\u4eba\u5458\u8bbe\u5907\u5173\u7cfb,\u4fe1\u606f\u6b63\u5728\u540c\u6b65\u4e2d,\u8bf7\u52ff\u91cd\u590d\u542f\u52a8");
                throw new SyncClientException(SyncClientExceptionCode.REPEAT_START.getCode(), "\u4eba\u5458\u8bbe\u5907\u5173\u7cfb\u4fe1\u606f\u6b63\u5728\u540c\u6b65\u4e2d,\u8bf7\u52ff\u91cd\u590d\u542f\u52a8");
            }
        } else {
            PersonDeviceSyncIncrementHandler personDeviceSyncIncrementHandler = this;
            synchronized (personDeviceSyncIncrementHandler) {
                if (this.syncPersonAppRunning) {
                    logger.error("\u4eba\u5458\u8bbe\u5907\u5173\u7cfb,\u4fe1\u606f\u6b63\u5728\u540c\u6b65\u4e2d,\u8bf7\u52ff\u91cd\u590d\u542f\u52a8");
                    throw new SyncClientException(SyncClientExceptionCode.REPEAT_START.getCode(), "\u4eba\u5458\u8bbe\u5907\u5173\u7cfb\u4fe1\u606f\u6b63\u5728\u540c\u6b65\u4e2d,\u8bf7\u52ff\u91cd\u590d\u542f\u52a8");
                }
                this.syncPersonAppRunning = true;
            }
        }
        int syncAppTotal = 0;
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("\u540c\u6b65\u4eba\u5458\u8bbe\u5907\u5173\u7cfb,\u4eba\u5458:\u3010{}\u3011", (Object)JSON.toJSONString(listSyncPerson));
            }
            this.call(existRedis, lockKey, timeout);
        }
        catch (Exception e) {
            logger.error("\u540c\u6b65\u4eba\u5458\u8bbe\u5907\u5173\u7cfb,\u5f02\u5e38", (Throwable)e);
        }
        finally {
            this.syncPersonAppRunning = false;
            if (existRedis && lock) {
                BisRedisUtil.releaseLock(lockKey, lockValue);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("\u540c\u6b65\u4eba\u5458\u8bbe\u5907\u5173\u7cfb<<<");
        }
        return syncAppTotal;
    }

    public void call(boolean existRedis, String lockKey, long timeout) {
        String personId = "";
        if (logger.isDebugEnabled()) {
            logger.debug("\u540c\u6b65\u4eba\u5458\u8bbe\u5907\u5173\u7cfb,personId:\u3010{}\u3011>>>", (Object)personId);
        }
        Integer addCount = 0;
        Integer delCount = 0;
        try {
            Long lastUpdateTime = this.personDeviceSyncDao.querySyncPersonDeviceLastUpdateTime();
            List<SyncPersonDevice> listPullSyncPersonDevice = this.pullPersonDeviceList(personId, lastUpdateTime);
            if (null == listPullSyncPersonDevice || listPullSyncPersonDevice.isEmpty()) {
                logger.info("\u540c\u6b65\u4eba\u5458\u8bbe\u5907\u5173\u7cfb,\u6743\u9650\u5173\u7cfb\u6ca1\u6709\u66f4\u65b0");
                return;
            }
            for (SyncPersonDevice syncPersonDevice : listPullSyncPersonDevice) {
                SyncPersonDevice syncPersonDeviceTmp;
                if (existRedis) {
                    BisRedisUtil.renewalLock(lockKey, timeout);
                }
                if (null == (syncPersonDeviceTmp = this.personDeviceSyncDao.getPersonDevice(syncPersonDevice.getPersonId(), syncPersonDevice.getDeviceId()))) {
                    this.personDeviceSyncDao.saveSyncPersonDevice(syncPersonDevice);
                    continue;
                }
                syncPersonDeviceTmp.setCreateTime(syncPersonDevice.getCreateTime());
                syncPersonDeviceTmp.setStatus(syncPersonDevice.getStatus());
                this.personDeviceSyncDao.updateSyncPersonDeviceStatus(syncPersonDeviceTmp);
            }
            logger.info("\u540c\u6b65\u4eba\u5458\u8bbe\u5907\u5173\u7cfb,personId:\u3010{}\u3011, personCode:\u3010{}\u3011<<<\u65b0\u589e\u3010{}\u3011\u6761,\u5220\u9664:\u3010{}\u3011\u6761", new Object[]{personId, "", addCount, delCount});
        }
        catch (Exception e) {
            logger.error("\u540c\u6b65\u4eba\u5458\u8bbe\u5907\u5173\u7cfb,personId:\u3010{}\u3011\u5f02\u5e38:", (Object)personId, (Object)e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("\u540c\u6b65\u4eba\u5458\u8bbe\u5907\u5173\u7cfb,personId:\u3010{}\u3011<<<", (Object)personId);
        }
    }

    private List<SyncPersonDevice> pullPersonDeviceList(String personId, Long createTime) {
        HashMap<String, Object> mapReqParam = new HashMap<String, Object>();
        mapReqParam.put("pageNo", 1);
        mapReqParam.put("pageSize", Consts.SYNC_DEFAULT_PAGE_SIZE);
        mapReqParam.put("personId", personId);
        mapReqParam.put("createTime", createTime);
        long appResourceTotal = 0L;
        String localRegionalismCode = Consts.local_regionalismCode;
        String localNetworkCode = Consts.local_networkAreaCode;
        JSONArray listDevice = new JSONArray();
        int pageNo = 1;
        while (true) {
            mapReqParam.put("pageNo", pageNo);
            JSONArray deviceList = this.queryOffsitePersonDeviceList(localRegionalismCode, localNetworkCode, mapReqParam);
            if (logger.isDebugEnabled()) {
                logger.debug("\u540c\u6b65\u4eba\u5458\u8bbe\u5907\u5173\u7cfb,personId:\u3010{}\u3011, personRegionalismCode:\u3010{}\u3011,\u7b2c[{}]\u9875\u6570\u636e:\u3010{}\u3011>>>", new Object[]{personId, localRegionalismCode, pageNo, null != deviceList ? deviceList.toJSONString() : null});
            }
            if (!CollectionUtils.isEmpty((Collection)deviceList)) {
                listDevice.addAll((Collection)deviceList);
                appResourceTotal += (long)deviceList.size();
            }
            if (logger.isDebugEnabled()) {
                logger.debug("\u540c\u6b65\u4eba\u5458\u8bbe\u5907\u5173\u7cfb,,personId:\u3010{}\u3011, personRegionalismCode:\u3010{}\u3011, pageNo:\u3010{}\u3011, rows:\u3010{}\u3011, total:\u3010{}\u3011<<<", new Object[]{personId, localRegionalismCode, pageNo, deviceList.toJSONString(), appResourceTotal});
            }
            if (CollectionUtils.isEmpty((Collection)deviceList) || deviceList.size() < Consts.SYNC_DEFAULT_PAGE_SIZE) {
                if (!logger.isDebugEnabled()) break;
                logger.debug("\u540c\u6b65\u4eba\u5458\u8bbe\u5907\u5173\u7cfb,personId:\u3010{}\u3011, personRegionalismCode:\u3010{}\u3011\u4e0d\u591f\u4e0b\u4e00\u6b21\u5206\u9875\uff0c\u540c\u6b65\u7ed3\u675f", (Object)personId, (Object)localRegionalismCode);
                break;
            }
            ++pageNo;
        }
        return this.buildSyncPersonDevice(listDevice, personId, localRegionalismCode);
    }

    private List<SyncPersonDevice> buildSyncPersonDevice(JSONArray personList, String personId, String localRegionalismCode) {
        ArrayList<SyncPersonDevice> listSyncPersonApp = new ArrayList<SyncPersonDevice>();
        if (null == personList) {
            return listSyncPersonApp;
        }
        SyncPersonDevice syncPersonApp = null;
        for (int i = 0; i < personList.size(); ++i) {
            JSONObject jsonObject = personList.getJSONObject(i);
            if (null == jsonObject) continue;
            syncPersonApp = (SyncPersonDevice)jsonObject.toJavaObject(SyncPersonDevice.class);
            syncPersonApp.setPersonDeviceId(IdGeneratorUtil.nextIdNum());
            syncPersonApp.setPersonRegionalismCode(localRegionalismCode);
            listSyncPersonApp.add(syncPersonApp);
        }
        return listSyncPersonApp;
    }

    private JSONArray queryOffsitePersonDeviceList(String regionalismCode, String localNetworkCode, Map<String, Object> mapReqParam) {
        JSONArray resultList;
        String json = this.basicInfoSyncService.executeCallIF("/v1/personDevice/getDeviceByPerson.do", "/v1/personDevice/getDeviceByPersonIncrement.do", regionalismCode, InterfaceCodeEnum.IF_UPM_SVC_22.getCode(), localNetworkCode, IdGeneratorUtil.nextIdStr(), CredentialUtil.getUserCredential(), CredentialUtil.getAppCredential(), CredentialUtil.getDeviceCredential(), mapReqParam);
        if (logger.isDebugEnabled()) {
            logger.debug("\u540c\u6b65\u4eba\u5458\u8bbe\u5907\u5173\u7cfb<<<\u3010{}\u3011", (Object)json);
        }
        if (StringUtils.isEmpty((Object)json)) {
            logger.debug("\u540c\u6b65\u4eba\u5458\u8bbe\u5907\u5173\u7cfb,personRegionalismCode:\u3010{}\u3011\u5217\u8868\u4e3a\u7a7a", (Object)regionalismCode);
            return new JSONArray();
        }
        try {
            JSONObject result = JSON.parseObject((String)json);
            resultList = result.getJSONArray("deviceList");
        }
        catch (Exception e) {
            logger.error("\u540c\u6b65\u4eba\u5458\u8bbe\u5907\u5173\u7cfb,personRegionalismCode:\u3010{}\u3011\u8f6c\u5316\u5f02\u5e38,\u539f\u6570\u636e\u3010{}\u3011", (Object)regionalismCode, (Object)json);
            throw SyncClientException.operateErrorException("\u540c\u6b65\u884c\u653f\u533a\u5212" + regionalismCode + "\u4eba\u5458\u8bbe\u5907\u5173\u7cfb\u5217\u8868\u7ed3\u679c\u8f6c\u5316\u5f02\u5e38");
        }
        if (null == resultList) {
            logger.debug("\u540c\u6b65\u4eba\u5458\u8bbe\u5907\u5173\u7cfb,personRegionalismCode:\u3010{}\u3011\u5217\u8868\u4e3a\u7a7a", (Object)regionalismCode);
            return new JSONArray();
        }
        return resultList;
    }

    @Override
    public TableEnum[] supportType(TableEnum[] tableEnums) {
        ArrayList<TableEnum> listTableEnum = new ArrayList<TableEnum>();
        for (TableEnum tableEnum : tableEnums) {
            if (TableEnum.TABLE_PERSON_DEVICE != tableEnum) continue;
            listTableEnum.add(tableEnum);
        }
        return listTableEnum.toArray(new TableEnum[listTableEnum.size()]);
    }
}

