/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.sync.service.impl;

import com.alibaba.fastjson.JSON;
import com.xdja.sync.exception.RoamException;
import com.xdja.sync.exception.RoamExceptionCodeEnum;
import com.xdja.sync.service.BasicSyncServiceInterfaceService;
import com.xdja.sync.service.InterfaceSvcCallService;
import com.xdja.sync.util.HttpUtils;
import com.xdja.sync.util.IdGeneratorUtil;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class InterfaceSvcCallServiceImpl
implements InterfaceSvcCallService {
    private static final Logger logger = LoggerFactory.getLogger(InterfaceSvcCallServiceImpl.class);
    @Autowired
    private BasicSyncServiceInterfaceService syncServiceInterfaceService;

    private String getInterfaceUrl(String regionalismCode, String networkCode, String interfaceCode) {
        String interfaceUrl = this.syncServiceInterfaceService.queryInterfaceUrl(regionalismCode, interfaceCode, networkCode);
        if (StringUtils.isEmpty((Object)interfaceUrl)) {
            logger.error("regionalismCode\uff1a\u3010{}\u3011, interfaceCode:\u3010{}\u3011, networkCode:\u3010{}\u3011\u5bf9\u5e94\u7684\u63a5\u53e3\u5730\u5740\u4e3a\u7a7a", new Object[]{regionalismCode, interfaceCode, networkCode});
            throw new RoamException(RoamExceptionCodeEnum.PARAM_FAILED.getCode(), "\u63a5\u53e3\u5730\u5740\u4e0d\u5b58\u5728");
        }
        return interfaceUrl;
    }

    @Override
    public String execute(String regionalismCode, String networkCode, String interfaceCode, String messageId, String appCredential, String userCredential, Object bodyParam) throws RoamException {
        String interfaceUrl = this.getInterfaceUrl(regionalismCode, networkCode, interfaceCode);
        return this.executeCall(interfaceUrl, messageId, appCredential, userCredential, bodyParam);
    }

    @Override
    public String execute(String regionalismCode, String networkCode, String interfaceCode, String appCredential, String userCredential, Object bodyParam) throws RoamException {
        return this.execute(regionalismCode, networkCode, interfaceCode, IdGeneratorUtil.nextUUID(), appCredential, userCredential, bodyParam);
    }

    @Override
    public String execute(String regionalismCode, String networkCode, String interfaceCode, String appCredential, Object bodyParam) throws RoamException {
        return this.execute(regionalismCode, networkCode, interfaceCode, IdGeneratorUtil.nextUUID(), appCredential, null, bodyParam);
    }

    public String executeCall(String interfaceUrl, String messageId, String appCredential, String userCredential, Object bodyParam) throws RoamException {
        return this.executeCall(interfaceUrl, messageId, appCredential, userCredential, null, bodyParam);
    }

    public String executeCall(String interfaceUrl, String messageId, String appCredential, String userCredential, String deviceCredential, Object bodyParam) throws RoamException {
        HashMap<String, String> mapHeader = new HashMap<String, String>();
        mapHeader.put("messageId", StringUtils.isEmpty((Object)messageId) ? IdGeneratorUtil.nextUUID() : messageId);
        if (!StringUtils.isEmpty((Object)appCredential)) {
            mapHeader.put("appCredential", appCredential);
        }
        if (!StringUtils.isEmpty((Object)userCredential)) {
            mapHeader.put("userCredential", userCredential);
        }
        if (!StringUtils.isEmpty((Object)deviceCredential)) {
            mapHeader.put("deviceCredential", deviceCredential);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("\u8c03\u7528\u63a5\u53e3>>>url:\u3010{}\u3011,Header:\u3010{}\u3011,param:\u3010{}\u3011", new Object[]{interfaceUrl, JSON.toJSONString(mapHeader), Objects.isNull(bodyParam) ? "" : JSON.toJSONString((Object)bodyParam)});
        }
        HttpUtils.ResponseWrap responseWrap = null;
        try {
            responseWrap = HttpUtils.createPost(interfaceUrl).addHeader(mapHeader).addJsonBody(bodyParam).execute();
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528\u63a5\u53e3\u5931\u8d25:\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a,url:\u3010{}\u3011,Header:\u3010{}\u3011,param:\u3010{}\u3011", new Object[]{interfaceUrl, JSON.toJSONString(mapHeader), Objects.isNull(bodyParam) ? "" : JSON.toJSONString((Object)bodyParam)});
            throw e;
        }
        String code = "";
        String message = "";
        if (responseWrap == null) {
            logger.error("\u8c03\u7528\u63a5\u53e3\u5931\u8d25:\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a,url:\u3010{}\u3011,Header:\u3010{}\u3011,param:\u3010{}\u3011", new Object[]{interfaceUrl, JSON.toJSONString(mapHeader), Objects.isNull(bodyParam) ? "" : JSON.toJSONString((Object)bodyParam)});
            throw new RoamException(RoamExceptionCodeEnum.RES_EMPTY.getCode(), RoamExceptionCodeEnum.RES_EMPTY.getMessage());
        }
        if (200 != responseWrap.statusCode()) {
            logger.error("\u8c03\u7528\u63a5\u53e3\u5931\u8d25url:\u3010{}\u3011,Header:\u3010{}\u3011,param:\u3010{}\u3011,:\u8fd4\u56deHTTP\u72b6\u6001\u7801\u9519\u8bef{},", new Object[]{interfaceUrl, JSON.toJSONString(mapHeader), Objects.isNull(bodyParam) ? "" : JSON.toJSONString((Object)bodyParam), responseWrap.statusCode()});
            throw new RoamException(responseWrap.statusCode(), "\u8fd4\u56deHTTP\u72b6\u6001\u7801\u9519\u8bef," + responseWrap.statusCode());
        }
        code = responseWrap.getHeaderValue("code");
        message = responseWrap.getHeaderValue("message");
        if (!"0".equals(code)) {
            String errorMsg = "\u8fd4\u56de\u4e1a\u52a1\u9519\u8bef\u72b6\u6001\u7801:" + code + ",\u9519\u8bef\u6d88\u606f\uff1a" + responseWrap.getHeaderValue("message");
            logger.error("\u8c03\u7528\u63a5\u53e3\u5931\u8d25url:\u3010{}\u3011,Header:\u3010{}\u3011,param:\u3010{}\u3011,:\u8fd4\u56decode:\u3010{}\u3011,message:\u3010{}\u3011,", new Object[]{interfaceUrl, JSON.toJSONString(mapHeader), Objects.isNull(bodyParam) ? "" : JSON.toJSONString((Object)bodyParam), code, null != message ? URLDecoder.decode(message) : null});
            int errorCode = -1;
            try {
                errorCode = Integer.parseInt(code);
            }
            catch (Exception e) {
                logger.error("\u8c03\u7528\u63a5\u53e3\u5931\u8d25url:\u3010{}\u3011,Header:\u3010{}\u3011,param:\u3010{}\u3011,:\u8fd4\u56decode:\u3010{}\u3011,message:\u3010{}\u3011,", new Object[]{interfaceUrl, JSON.toJSONString(mapHeader), Objects.isNull(bodyParam) ? "" : JSON.toJSONString((Object)bodyParam), code, null != message ? URLDecoder.decode(message) : null});
            }
            throw new RoamException(errorCode, URLDecoder.decode(errorMsg));
        }
        String result = responseWrap.getString();
        if (logger.isDebugEnabled()) {
            logger.debug("\u8c03\u7528\u63a5\u53e3<<<url:\u3010{}\u3011,Header:\u3010{}\u3011,param:\u3010{}\u3011,resultCode:\u3010{}\u3011,resultMessage:\u3010{}\u3011,result:\u3010{}\u3011", new Object[]{interfaceUrl, JSON.toJSONString(mapHeader), Objects.isNull(bodyParam) ? "" : JSON.toJSONString((Object)bodyParam), code, null != message ? URLDecoder.decode(message) : null, result});
        }
        return result;
    }

    @Override
    public String executeCall(String regionalismCode, String networkCode, String interfaceCode, String messageId, String appCredential, String userCredential, String deviceCredential, Object bodyParam) throws RoamException {
        String interfaceUrl = this.getInterfaceUrl(regionalismCode, networkCode, interfaceCode);
        HashMap<String, String> mapHeader = new HashMap<String, String>();
        mapHeader.put("messageId", StringUtils.isEmpty((Object)messageId) ? IdGeneratorUtil.nextUUID() : messageId);
        if (!StringUtils.isEmpty((Object)appCredential)) {
            mapHeader.put("appCredential", appCredential);
        }
        if (!StringUtils.isEmpty((Object)userCredential)) {
            mapHeader.put("userCredential", userCredential);
        }
        if (!StringUtils.isEmpty((Object)deviceCredential)) {
            mapHeader.put("deviceCredential", deviceCredential);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("\u8c03\u7528\u63a5\u53e3>>>url:\u3010{}\u3011,Header:\u3010{}\u3011,param:\u3010{}\u3011", new Object[]{interfaceUrl, JSON.toJSONString(mapHeader), Objects.isNull(bodyParam) ? "" : JSON.toJSONString((Object)bodyParam)});
        }
        HttpUtils.ResponseWrap responseWrap = null;
        try {
            responseWrap = HttpUtils.createPost(interfaceUrl).addHeader(mapHeader).addJsonBody(bodyParam).execute();
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528\u63a5\u53e3\u5931\u8d25:\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a,url:\u3010{}\u3011,Header:\u3010{}\u3011,param:\u3010{}\u3011", new Object[]{interfaceUrl, JSON.toJSONString(mapHeader), Objects.isNull(bodyParam) ? "" : JSON.toJSONString((Object)bodyParam)});
            throw e;
        }
        String code = "";
        String message = "";
        if (responseWrap == null) {
            logger.error("\u8c03\u7528\u63a5\u53e3\u5931\u8d25:\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a,url:\u3010{}\u3011,Header:\u3010{}\u3011,param:\u3010{}\u3011", new Object[]{interfaceUrl, JSON.toJSONString(mapHeader), Objects.isNull(bodyParam) ? "" : JSON.toJSONString((Object)bodyParam)});
            throw new RoamException(RoamExceptionCodeEnum.RES_EMPTY.getCode(), RoamExceptionCodeEnum.RES_EMPTY.getMessage());
        }
        if (200 != responseWrap.statusCode()) {
            logger.error("\u8c03\u7528\u63a5\u53e3\u5931\u8d25url:\u3010{}\u3011,Header:\u3010{}\u3011,param:\u3010{}\u3011,:\u8fd4\u56deHTTP\u72b6\u6001\u7801\u9519\u8bef{},", new Object[]{interfaceUrl, JSON.toJSONString(mapHeader), Objects.isNull(bodyParam) ? "" : JSON.toJSONString((Object)bodyParam), responseWrap.statusCode()});
            throw new RoamException(responseWrap.statusCode(), "\u8fd4\u56deHTTP\u72b6\u6001\u7801\u9519\u8bef," + responseWrap.statusCode());
        }
        code = responseWrap.getHeaderValue("code");
        message = responseWrap.getHeaderValue("message");
        if (!"0".equals(code)) {
            String errorMsg = "\u8fd4\u56de\u4e1a\u52a1\u9519\u8bef\u72b6\u6001\u7801:" + code + ",\u9519\u8bef\u6d88\u606f\uff1a" + responseWrap.getHeaderValue("message");
            logger.error("\u8c03\u7528\u63a5\u53e3\u5931\u8d25url:\u3010{}\u3011,Header:\u3010{}\u3011,param:\u3010{}\u3011,:\u8fd4\u56decode:\u3010{}\u3011,message:\u3010{}\u3011,", new Object[]{interfaceUrl, JSON.toJSONString(mapHeader), Objects.isNull(bodyParam) ? "" : JSON.toJSONString((Object)bodyParam), code, null != message ? URLDecoder.decode(message) : null});
            int errorCode = -1;
            try {
                errorCode = Integer.parseInt(code);
            }
            catch (Exception e) {
                logger.error("\u8c03\u7528\u63a5\u53e3\u5931\u8d25url:\u3010{}\u3011,Header:\u3010{}\u3011,param:\u3010{}\u3011,:\u8fd4\u56decode:\u3010{}\u3011,message:\u3010{}\u3011,", new Object[]{interfaceUrl, JSON.toJSONString(mapHeader), Objects.isNull(bodyParam) ? "" : JSON.toJSONString((Object)bodyParam), code, null != message ? URLDecoder.decode(message) : null});
            }
            throw new RoamException(errorCode, URLDecoder.decode(errorMsg));
        }
        String result = responseWrap.getString();
        if (logger.isDebugEnabled()) {
            logger.debug("\u8c03\u7528\u63a5\u53e3<<<url:\u3010{}\u3011,Header:\u3010{}\u3011,param:\u3010{}\u3011,resultCode:\u3010{}\u3011,resultMessage:\u3010{}\u3011,result:\u3010{}\u3011", new Object[]{interfaceUrl, JSON.toJSONString(mapHeader), Objects.isNull(bodyParam) ? "" : JSON.toJSONString((Object)bodyParam), code, null != message ? URLDecoder.decode(message) : null, result});
        }
        return result;
    }

    @Override
    public String executeCall(String interfaceUrl, Object bodyParam) {
        if (StringUtils.isEmpty((Object)interfaceUrl)) {
            logger.error("\u63a5\u53e3\u5730\u5740\u4e3a\u7a7a");
            throw new RoamException(RoamExceptionCodeEnum.RES_EMPTY.getCode(), RoamExceptionCodeEnum.RES_EMPTY.getMessage());
        }
        if (logger.isInfoEnabled()) {
            logger.info("\u8c03\u7528\u63a5\u53e3url:\u3010{}\u3011, param:\u3010{}\u3011>>>", (Object)interfaceUrl, (Object)JSON.toJSONString((Object)bodyParam));
        }
        HttpUtils.ResponseWrap responseWrap = null;
        try {
            responseWrap = HttpUtils.createPost(interfaceUrl).addJsonBody(bodyParam).execute();
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528\u63a5\u53e3\u5931\u8d25:\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a,url:\u3010{}\u3011,,param:\u3010{}\u3011", (Object)interfaceUrl, (Object)(Objects.isNull(bodyParam) ? "" : JSON.toJSONString((Object)bodyParam)));
            throw e;
        }
        String code = "";
        String message = "";
        if (responseWrap == null) {
            logger.error("\u8c03\u7528\u63a5\u53e3\u5931\u8d25:\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a,url:\u3010{}\u3011,param:\u3010{}\u3011", (Object)interfaceUrl, (Object)(Objects.isNull(bodyParam) ? "" : JSON.toJSONString((Object)bodyParam)));
            throw new RoamException(RoamExceptionCodeEnum.RES_EMPTY.getCode(), RoamExceptionCodeEnum.RES_EMPTY.getMessage());
        }
        if (200 != responseWrap.statusCode()) {
            logger.error("\u8c03\u7528\u63a5\u53e3\u5931\u8d25url:\u3010{}\u3011,param:\u3010{}\u3011,:\u8fd4\u56deHTTP\u72b6\u6001\u7801\u9519\u8bef{},", new Object[]{interfaceUrl, Objects.isNull(bodyParam) ? "" : JSON.toJSONString((Object)bodyParam), responseWrap.statusCode()});
            throw new RoamException(responseWrap.statusCode(), "\u8fd4\u56deHTTP\u72b6\u6001\u7801\u9519\u8bef," + responseWrap.statusCode());
        }
        code = responseWrap.getHeaderValue("code");
        message = responseWrap.getHeaderValue("message");
        if (!"0".equals(code)) {
            String errorMsg = "\u8fd4\u56de\u4e1a\u52a1\u9519\u8bef\u72b6\u6001\u7801:" + code + ",\u9519\u8bef\u6d88\u606f\uff1a" + responseWrap.getHeaderValue("message");
            logger.error("\u8c03\u7528\u63a5\u53e3\u5931\u8d25url:\u3010{}\u3011,param:\u3010{}\u3011,:\u8fd4\u56decode:\u3010{}\u3011,message:\u3010{}\u3011,", new Object[]{interfaceUrl, Objects.isNull(bodyParam) ? "" : JSON.toJSONString((Object)bodyParam), code, null != message ? URLDecoder.decode(message) : null});
            int errorCode = -1;
            try {
                errorCode = Integer.parseInt(code);
            }
            catch (Exception e) {
                logger.error("\u8c03\u7528\u63a5\u53e3\u5931\u8d25url:\u3010{}\u3011,param:\u3010{}\u3011,:\u8fd4\u56decode:\u3010{}\u3011,message:\u3010{}\u3011,", new Object[]{interfaceUrl, Objects.isNull(bodyParam) ? "" : JSON.toJSONString((Object)bodyParam), code, null != message ? URLDecoder.decode(message) : null});
            }
            throw new RoamException(errorCode, URLDecoder.decode(errorMsg));
        }
        String result = responseWrap.getString();
        if (logger.isDebugEnabled()) {
            logger.debug("\u8c03\u7528\u63a5\u53e3<<<url:\u3010{}\u3011,param:\u3010{}\u3011,resultCode:\u3010{}\u3011,resultMessage:\u3010{}\u3011,result:\u3010{}\u3011", new Object[]{interfaceUrl, Objects.isNull(bodyParam) ? "" : JSON.toJSONString((Object)bodyParam), code, null != message ? URLDecoder.decode(message) : null, result});
        }
        return result;
    }
}

