/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.version.service.impl;

import com.alibaba.fastjson.JSON;
import com.xdja.sync.bean.SyncSystemConfig;
import com.xdja.sync.bean.common.Consts;
import com.xdja.sync.bean.common.DbType;
import com.xdja.sync.dao.BasicSyncCommonDao;
import com.xdja.sync.dao.BasicSyncSystemConfigDao;
import com.xdja.version.service.BasicSyncVersionUpdateService;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class BasicSyncVersionUpdateServiceImpl
implements BasicSyncVersionUpdateService {
    private static final Logger logger = LoggerFactory.getLogger(BasicSyncVersionUpdateServiceImpl.class);
    @Autowired
    private BasicSyncSystemConfigDao basicSyncSystemConfigDao;
    @Autowired
    private BasicSyncCommonDao basicSyncCommonDao;
    private static final String currentVersion = "1.0.13";

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void checkUpdate() {
        SyncSystemConfig syncSystemConfig = this.basicSyncSystemConfigDao.getSystemConfigByCode("BASIC_SYNC_VERSION");
        if (logger.isDebugEnabled()) {
            logger.debug("\u540c\u6b65\u7a0b\u5e8f\u7248\u672c\u4fe1\u606f>>>SyncSystemConfig\uff1a\u3010{}\u3011", (Object)(null != syncSystemConfig ? JSON.toJSONString((Object)syncSystemConfig) : null));
        }
        String versionCode = null;
        if (null == syncSystemConfig) {
            syncSystemConfig = new SyncSystemConfig();
            syncSystemConfig.setConfigId("BASIC_SYNC_VERSION");
            syncSystemConfig.setConfigCode("BASIC_SYNC_VERSION");
            syncSystemConfig.setConfigName("\u540c\u6b65\u7a0b\u5e8f\u7248\u672c\u53f7");
            syncSystemConfig.setConfigValue("1.0.4");
            syncSystemConfig.setConfigDesc("\u540c\u6b65\u7a0b\u5e8f\u7248\u672c\u53f7");
            syncSystemConfig.setParentId("0");
            syncSystemConfig.setUpdateTime(System.currentTimeMillis());
            this.basicSyncSystemConfigDao.saveSystemConfig(syncSystemConfig);
            versionCode = "1.0.3";
        } else {
            versionCode = syncSystemConfig.getConfigValue();
        }
        List<String> listUpdateVersion = this.getUpdateVersionList(versionCode);
        for (String version : listUpdateVersion) {
            List<String> listSql = this.getInitTableFileSql(version);
            if (CollectionUtils.isEmpty(listSql)) continue;
            for (String sql : listSql) {
                if (StringUtils.isEmpty((Object)sql)) continue;
                if (DbType.ORACLE == Consts.dbType || DbType.ORACLE_12C == Consts.dbType) {
                    sql = sql.substring(0, sql.length() - 1);
                }
                try {
                    this.basicSyncCommonDao.updateBySql(sql, null);
                }
                catch (Exception e) {
                    logger.warn("\u540c\u6b65\u7a0b\u5e8f\u6267\u884c\u5347\u7ea7\u811a\u672c\u5931\u8d25", (Throwable)e);
                }
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("\u540c\u6b65\u7a0b\u5e8f\u7248\u672c\u4fe1\u606f<<<SyncSystemConfig\uff1a\u3010{}\u3011", (Object)JSON.toJSONString((Object)syncSystemConfig));
        }
    }

    private List<String> getInitTableFileSql(String updateSqlName) {
        ArrayList<String> listSql = new ArrayList<String>();
        String sql = "";
        try {
            String path = updateSqlName + ".upgrade." + Consts.dbType.getDb().toLowerCase() + ".sql";
            InputStream inputStream = BasicSyncVersionUpdateServiceImpl.class.getClassLoader().getResourceAsStream(path);
            if (null == inputStream) {
                return listSql;
            }
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            String line = null;
            while (null != (line = bufferedReader.readLine())) {
                if (StringUtils.isEmpty((Object)line)) continue;
                sql = sql + line;
                boolean b = line.endsWith(";");
                if (!b) continue;
                listSql.add(sql.trim());
                sql = "";
            }
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u5347\u7ea7\u811a\u672c[{}]\u5931\u8d25\uff1a", (Object)updateSqlName, (Object)e);
        }
        return listSql;
    }

    private List<String> getUpdateVersionList(String version) {
        ArrayList<String> listVersion = new ArrayList<String>();
        String[] aryVersion = version.split("\\.");
        String[] aryCurrentVersion = currentVersion.split("\\.");
        if (3 != aryVersion.length || 3 != aryCurrentVersion.length) {
            return listVersion;
        }
        String firstVersion = aryVersion[0];
        String secondVersion = aryVersion[1];
        String threeVersion = aryVersion[2];
        String firstCurrentVersion = aryCurrentVersion[0];
        String secondCurrentVersion = aryCurrentVersion[1];
        String threeCurrentVersion = aryCurrentVersion[2];
        if (firstVersion.equals(firstCurrentVersion) && secondVersion.equals(secondCurrentVersion)) {
            if (threeVersion.equals(threeCurrentVersion)) {
                return listVersion;
            }
            for (int i = Integer.parseInt(threeVersion); i <= Integer.parseInt(threeCurrentVersion); ++i) {
                listVersion.add(firstVersion + "." + secondVersion + "." + i);
            }
        }
        listVersion.remove(version);
        return listVersion;
    }
}

