CREATE TABLE `t_sync_resource` (
	`id` VARCHAR(32) NOT NULL COMMENT '主键' COLLATE 'utf8mb4_general_ci',
	`resource_id` VARCHAR(128) NULL DEFAULT NULL COMMENT '资源ID\r\n单个平台内唯一,规则为“XXXXXXXXXX(12位服务事权单位机构代码，事权单位为公安机关则按照GA380填写；事权单位为非公安机关则填写18位统一社会信用代码)-X(1位区域类型)-XXXX（4位业务类型代码）-XXXXX(字母或数字，总长度不超过32)”；其中流水号采取机构单位内小编吗（即不同机构单位内流水号从1开始）。编号一经生成后不可修改（可以删除），且不复用；如：\r\n010000000000-3-0100-XXXXX 部级平台Ⅲ类区通用数据查询服务\r\n1级，服务资源事权单位机构代码\r\n2级，系统区域标识\r\n3级，业务类型代码\r\n4级，字母或数字，总长度不超过32\r\n业务类型代码：\r\n0100	查询检索类服务\r\n0200	比对订阅类服务\r\n0300	模型分析类服务\r\n0400	数据推送类服务\r\n0500	数据鉴权服务\r\n0600	数据操作类服务\r\n0700	数据服务管理类服务\r\n0800	其他服务' COLLATE 'utf8mb4_general_ci',
	`network_area_Code` INT(1) NULL DEFAULT NULL COMMENT '资源部署区域标识\r\n1-Ⅰ类\r\n2-Ⅱ类\r\n3-Ⅲ类',
	`resource_type` INT(1) NULL DEFAULT NULL COMMENT '资源可用区域标识\r\n1-Ⅰ类资源\r\n2-Ⅱ类资源\r\n3-Ⅲ类资源',
	`resource_service_type` VARCHAR(12) NULL DEFAULT NULL COMMENT '资源服务类型\r\n第1位为总类型：\r\n1-摆渡交换\r\n2-请求服务\r\n3-授权访问\r\n第2位为细分类型，如果没有用0表示' COLLATE 'utf8mb4_general_ci',
	`resource_operator_type` VARCHAR(2) NULL DEFAULT NULL COMMENT '资源操作类型\r\n1-查询、2-写入、3-更新、4-删除' COLLATE 'utf8mb4_general_ci',
	`resource_interface_type` VARCHAR(2) NULL DEFAULT NULL COMMENT '资源接口类型\r\n资源接口类型\r\n11-HTTP\r\n12-HTTPS\r\n21-TCP\r\n22-UDP' COLLATE 'utf8mb4_general_ci',
	`resource_interface_address` VARCHAR(500) NULL DEFAULT NULL COMMENT '资源接口地址' COLLATE 'utf8mb4_general_ci',
	`power_type` VARCHAR(2) NULL DEFAULT '10' COMMENT '资源授权方式\r\n10-全公开、21-需由使用地授权、22-需由归属地授权、23-需由两地授权、31-需向使用地申请、32-需向归属地申请、33-需向两地申请' COLLATE 'utf8mb4_general_ci',
	`regionalism_code` VARCHAR(32) NULL DEFAULT NULL COMMENT '资源归属机构标识\r\n代码 GA380标准组织机构代码' COLLATE 'utf8mb4_general_ci',
	`resource_name` VARCHAR(500) NULL DEFAULT NULL COMMENT '资源名称' COLLATE 'utf8mb4_general_ci',
	`resource_description` VARCHAR(500) NULL DEFAULT NULL COMMENT '资源描述' COLLATE 'utf8mb4_general_ci',
	`status` INT(1) NULL DEFAULT '1' COMMENT '资源状态 1 启用；0 禁用',
	`publish_scope` TEXT NULL DEFAULT NULL COMMENT '资源发布范围，多个以英文逗号分割，GA380标准组织机构代码组成' COLLATE 'utf8mb4_general_ci',
	`register_time` BIGINT(13) NULL DEFAULT NULL COMMENT '资源注册时间戳',
	`update_Time` BIGINT(13) NULL DEFAULT NULL COMMENT '资源更新时间戳',
	`dep_code` VARCHAR(100) NULL DEFAULT NULL COMMENT '来源机构标识\r\n资源所有者所属部门代码（应按照全国统一部门代码返回）' COLLATE 'utf8mb4_general_ci',
	`owner_Identifier` VARCHAR(18) NULL DEFAULT NULL COMMENT '注册人标识\r\n资源注册人身份证号码' COLLATE 'utf8mb4_general_ci',
	`approver_Identifier` VARCHAR(18) NULL DEFAULT NULL COMMENT '审批人标识资源审批人身份证号码' COLLATE 'utf8mb4_general_ci',
	`approve_Time` BIGINT(20) NULL DEFAULT NULL COMMENT '审批时间',
	`last_Update_Time` BIGINT(13) NULL DEFAULT NULL COMMENT '最后一次更新时间',
	PRIMARY KEY (`id`) USING BTREE,
	UNIQUE INDEX `resource_id_network_area_Code_regionalism_code` (`resource_id`, `network_area_Code`, `regionalism_code`) USING BTREE
)
COMMENT='全国资源信息表'
COLLATE='utf8mb4_general_ci'
ENGINE=InnoDB
