/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.miping.config;

import com.xdja.cryptoappkit.domain.bean.CryptoAppKitProperties;
import com.xdja.cryptoappkit.usecase.crypt.CryptOperatorUseCase;
import com.xdja.cryptoappkit.usecase.keymanage.KeyManageUseCase;
import com.xdja.miping.config.CryptoConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;

@Configuration
public class KitConfig {
    private static final Logger logger = LoggerFactory.getLogger((String)KitConfig.class.getSimpleName());
    @Autowired
    CryptoConfig cryptoConfig;

    @Bean(name={"cryptoAppKitProperties"})
    public CryptoAppKitProperties cryptoAppKitProperties() {
        CryptoAppKitProperties cryptoAppKitProperties = CryptoAppKitProperties.getInstance();
        cryptoAppKitProperties.setUseSvs(false);
        cryptoAppKitProperties.setHsmType(this.cryptoConfig.getHsmType());
        switch (this.cryptoConfig.getHsmType()) {
            case 1: {
                cryptoAppKitProperties.setUsbKey(this.usbConfig());
                break;
            }
            case 2: {
                cryptoAppKitProperties.setHsm(this.hsmConfig());
                break;
            }
            default: {
                cryptoAppKitProperties.setSoft(this.softConfig());
            }
        }
        CryptoAppKitProperties.CertInfo certInfo = cryptoAppKitProperties.getCertInfo();
        certInfo.setCertValidityType(this.cryptoConfig.getCertValidityType());
        if (this.cryptoConfig.getCertValidityType() != 0) {
            this.certConfig(certInfo);
        }
        return cryptoAppKitProperties;
    }

    private CryptoAppKitProperties.Soft softConfig() {
        CryptoAppKitProperties.Soft soft = new CryptoAppKitProperties.Soft();
        soft.setSignKeyStoreFile(this.cryptoConfig.getSignKeyStoreFile());
        soft.setSignKeyPasswd(this.cryptoConfig.getSignKeyPasswd());
        soft.setEncKeyStoreFile(this.cryptoConfig.getEncKeyStoreFile());
        soft.setEncKeyPasswd(this.cryptoConfig.getEncKeyPasswd());
        soft.setKeyPath(this.cryptoConfig.getKeyPath());
        return soft;
    }

    private CryptoAppKitProperties.UsbKey usbConfig() {
        CryptoAppKitProperties.UsbKey usbKey = new CryptoAppKitProperties.UsbKey();
        usbKey.setContainerNum(this.cryptoConfig.getContainerNum());
        usbKey.setUsbPin(this.cryptoConfig.getUsbPin());
        usbKey.setUsbRole(this.cryptoConfig.getUsbRole());
        return usbKey;
    }

    private CryptoAppKitProperties.Hsm hsmConfig() {
        CryptoAppKitProperties.Hsm hsm = new CryptoAppKitProperties.Hsm();
        hsm.setAppName(this.cryptoConfig.getAppName());
        hsm.setYunHsmSdkConfPath(this.cryptoConfig.getHsmSdkConf());
        hsm.setExchangeKeyIndex(this.cryptoConfig.getExchangeKeyIndex());
        hsm.setSignKeyIndex(this.cryptoConfig.getSignKeyIndex());
        return hsm;
    }

    private void certConfig(CryptoAppKitProperties.CertInfo certInfo) {
        certInfo.setCrlFileCachePath(this.cryptoConfig.getCrlFileCachePath());
        certInfo.setLdapIp(this.cryptoConfig.getLdapIp());
        certInfo.setLdapPort(this.cryptoConfig.getLdapPort());
        certInfo.setCrlDn(this.cryptoConfig.getCrlDn());
        certInfo.setRootCertPath(this.cryptoConfig.getRootCertPath());
        certInfo.setCertChainFilePath(this.cryptoConfig.getCertChainFilePath());
    }

    @Bean(name={"cryptOperatorUseCase"})
    @DependsOn(value={"cryptoAppKitProperties"})
    public CryptOperatorUseCase getCryptOperatorUseCase() {
        logger.debug("getCryptOperatorUseCase");
        return new CryptOperatorUseCase();
    }

    @Bean(name={"keyManageUseCase"})
    @DependsOn(value={"cryptOperatorUseCase"})
    public KeyManageUseCase KeyManageUseCase() {
        logger.debug("KeyManageUseCase");
        return new KeyManageUseCase();
    }
}

