/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.sync.dao.imp;

import com.xdja.sync.bean.SyncPersonApp;
import com.xdja.sync.bean.common.Page;
import com.xdja.sync.dao.BasicSyncCommonDao;
import com.xdja.sync.dao.PersonAppSyncDao;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Component
public class PersonAppSyncDaoImpl
implements PersonAppSyncDao {
    private static final Logger logger = LoggerFactory.getLogger(PersonAppSyncDaoImpl.class);
    @Autowired
    private BasicSyncCommonDao basicSyncCommonDao;

    @Override
    public void savePersonApp(List<SyncPersonApp> listPersonApp) {
        String sql = "INSERT INTO t_sync_person_app (PERSON_APP_ID, APP_ID, APP_REGIONALISM_CODE, APP_NETWORK_CODE, PERSON_ID, PERSON_REGIONALISM_CODE, CREATE_TIME, LAST_UPDATE_TIME, status) VALUES (?, ?, ?, ?, ?, ?, ?, ?,?)";
        ArrayList<Object[]> batchArgs = new ArrayList<Object[]>();
        for (SyncPersonApp personApp : listPersonApp) {
            Object[] args = new Object[]{personApp.getPersonAppId(), personApp.getAppId(), personApp.getAppRegionalismCode(), personApp.getAppNetworkCode(), personApp.getPersonId(), personApp.getPersonRegionalismCode(), personApp.getCreateTime(), personApp.getLastUpdateTime(), personApp.getStatus()};
            batchArgs.add(args);
        }
        this.basicSyncCommonDao.batchUpdateBySql(sql, batchArgs);
    }

    @Override
    public void savePersonApp(SyncPersonApp personApp) {
        this.savePersonApp(Arrays.asList(personApp));
    }

    @Override
    public void updatePersonAppStatus(SyncPersonApp syncPersonApp) {
        this.updatePersonAppStatus(Arrays.asList(syncPersonApp));
    }

    @Override
    public void updatePersonAppStatus(List<SyncPersonApp> listPersonApp) {
        String sql = "UPDATE t_sync_person_app SET status = ?, LAST_UPDATE_TIME = ? where app_id = ?  and app_regionalism_Code = ?  and person_id = ?  and person_regionalism_Code = ? ";
        ArrayList<Object[]> batchArgs = new ArrayList<Object[]>();
        for (SyncPersonApp syncPersonApp : listPersonApp) {
            Object[] args = new Object[]{syncPersonApp.getStatus(), syncPersonApp.getLastUpdateTime(), syncPersonApp.getAppId(), syncPersonApp.getAppRegionalismCode(), syncPersonApp.getPersonId(), syncPersonApp.getPersonRegionalismCode()};
            batchArgs.add(args);
        }
        this.basicSyncCommonDao.batchUpdateBySql(sql, batchArgs);
    }

    @Override
    public void deletePersonAppByAppId(String appId, String appRegionalismCode) {
        String sql = "DELETE FROM t_sync_person_app  where app_id = ?  and app_regionalism_Code = ? ";
        this.basicSyncCommonDao.updateBySql(sql, new Object[]{appId, appRegionalismCode});
    }

    @Override
    public Long queryPersonAppCountByAppId(String appId, String appRegionalismCode) {
        String sql = "SELECT count(1) FROM t_sync_person_app WHERE app_id = ?  AND app_regionalism_Code = ? ";
        ArrayList<String> args = new ArrayList<String>();
        args.add(appId);
        args.add(appRegionalismCode);
        Long count = (Long)this.basicSyncCommonDao.selectOne(sql, args.toArray(), Long.class);
        return count;
    }

    @Override
    public List<SyncPersonApp> queryPersonAppByAppId(String appId, String appRegionalismCode) {
        String sql = "SELECT * FROM t_sync_person_app  where app_id = ?  and app_regionalism_Code = ? ";
        return this.basicSyncCommonDao.selectList(sql, new Object[]{appId, appRegionalismCode}, SyncPersonApp.class);
    }

    @Override
    public List<SyncPersonApp> queryPersonAppByAppId(String appId, String appRegionalismCode, Page page) {
        String sql = "SELECT * FROM t_sync_person_app  where app_id = ?  and app_regionalism_Code = ? ";
        return this.basicSyncCommonDao.selectList(sql, new Object[]{appId, appRegionalismCode}, SyncPersonApp.class, page);
    }

    @Override
    public List<SyncPersonApp> querySyncPersonAppListByPersonId(String personId, String personRegionalismCode) {
        String sql = "SELECT * FROM t_sync_person_app  where person_id = ? ";
        Object[] args = new Object[]{personId};
        if (!StringUtils.isEmpty((Object)personRegionalismCode)) {
            sql = sql + " and person_regionalism_Code = ? ";
            args = new Object[]{personId, personRegionalismCode};
        }
        return this.basicSyncCommonDao.selectList(sql, args, SyncPersonApp.class);
    }

    @Override
    public boolean existPersonAppPower(String personId, String personRegionalismCode, String appId, String appRegionalismCode) {
        Long count;
        String sql = "SELECT count(1) FROM t_sync_person_app WHERE person_id = ?  AND app_id = ?  AND status = ? ";
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(personId);
        args.add(appId);
        args.add(SyncPersonApp.status_grant_1);
        if (!StringUtils.isEmpty((Object)personRegionalismCode)) {
            sql = sql + " AND person_regionalism_Code = ? ";
            args.add(personRegionalismCode);
        }
        if (!StringUtils.isEmpty((Object)appRegionalismCode)) {
            sql = sql + " AND app_regionalism_Code = ? ";
            args.add(appRegionalismCode);
        }
        return null != (count = (Long)this.basicSyncCommonDao.selectOne(sql, args.toArray(), Long.class)) && count > 0L;
    }

    @Override
    public boolean existPersonAppPower(String personId, String appId) {
        return this.existPersonAppPower(personId, appId);
    }

    @Override
    public void deletePersonAppById(List<Long> listPersonId) {
        if (!CollectionUtils.isEmpty(listPersonId)) {
            for (Long id : listPersonId) {
                this.deletePersonAppById(id);
            }
        }
    }

    @Override
    public void deletePersonAppById(Long personAppId) {
        String sql = "DELETE FROM t_sync_person_app  WHERE PERSON_APP_ID = ? ";
        this.basicSyncCommonDao.updateBySql(sql, new Object[]{personAppId});
    }

    @Override
    public List<SyncPersonApp> queryPersonAppMaxTime() {
        String sql = "select APP_REGIONALISM_CODE appRegionalismCode,max(LAST_UPDATE_TIME) lastUpdateTime from t_sync_person_app group by APP_REGIONALISM_CODE";
        return this.basicSyncCommonDao.selectList(sql, null, SyncPersonApp.class);
    }

    @Override
    public List<String> queryPersonAppByAppId(List<SyncPersonApp> list) {
        if (CollectionUtils.isEmpty(list)) {
            return Collections.emptyList();
        }
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT CONCAT(app_id,person_id) FROM t_sync_person_app WHERE app_regionalism_Code = ?  AND (app_id,person_id) IN (");
        ArrayList<String> params = new ArrayList<String>();
        params.add(list.get(0).getAppRegionalismCode());
        for (int i = 0; i < list.size(); ++i) {
            SyncPersonApp item = list.get(i);
            params.add(item.getAppId());
            params.add(item.getPersonId());
            if (i < list.size() - 1) {
                sql.append("(?, ?), ");
                continue;
            }
            sql.append("(?, ?)");
        }
        sql.append(")");
        List<String> result = this.basicSyncCommonDao.selectList(sql.toString(), params.toArray(), String.class);
        return result;
    }
}

