/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.task;

import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.springframework.util.StringUtils;

public class ThreadManager {
    private static AtomicInteger atomicInteger = new AtomicInteger();
    private static Map<String, ExecutorService> mapExecutorService = new ConcurrentHashMap<String, ExecutorService>();
    public static final String POOL_NAME_DEFAULT = "default";
    public static final String POOL_NAME_PERSON_APP = "personApp";
    public static final String POOL_NAME_TABLE_DATA = "tableData";

    private ThreadManager() {
    }

    public static ThreadManager getInstance() {
        return ThreadManagerInstance.instance;
    }

    private ExecutorService initExecutorService(String poolName) {
        return this.initExecutorService(poolName, 2, 4, 1024);
    }

    private ExecutorService initExecutorService(String poolName, int corePoolSize, int maximumPoolSize, int capacity) {
        if (StringUtils.isEmpty((Object)poolName)) {
            poolName = POOL_NAME_DEFAULT;
        }
        final String finalPoolName = poolName;
        ThreadPoolExecutor executorService = new ThreadPoolExecutor(corePoolSize, maximumPoolSize, 2L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(capacity), new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = new Thread(r);
                thread.setDaemon(true);
                thread.setName("sync-pool-" + finalPoolName + "-" + atomicInteger.getAndIncrement());
                return thread;
            }
        }, new ThreadPoolExecutor.CallerRunsPolicy());
        return executorService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecutorService getExecutorService(String poolName) {
        String string = poolName;
        synchronized (string) {
            ExecutorService executorService1 = mapExecutorService.get(poolName);
            if (null == executorService1) {
                executorService1 = POOL_NAME_DEFAULT.equalsIgnoreCase(poolName) ? this.initExecutorService(POOL_NAME_DEFAULT, 2, 8, 1024) : (POOL_NAME_TABLE_DATA.equalsIgnoreCase(poolName) ? this.initExecutorService(POOL_NAME_TABLE_DATA, 2, 8, 16) : (POOL_NAME_PERSON_APP.equalsIgnoreCase(poolName) ? this.initExecutorService(POOL_NAME_PERSON_APP, 2, 8, 1024) : this.initExecutorService(poolName)));
                mapExecutorService.put(poolName, executorService1);
            }
            return executorService1;
        }
    }

    public Future submit(Callable runnable) {
        return this.submit(runnable, POOL_NAME_DEFAULT);
    }

    public void submit(Runnable runnable) {
        this.submit(runnable, POOL_NAME_DEFAULT);
    }

    public Future submit(Callable runnable, String poolName) {
        return this.getExecutorService(poolName).submit(runnable);
    }

    public void submit(Runnable runnable, String poolName) {
        this.getExecutorService(poolName).submit(runnable);
    }

    private static class ThreadManagerInstance {
        public static ThreadManager instance = new ThreadManager();

        private ThreadManagerInstance() {
        }
    }
}

