/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.card.api.bean;

import java.io.Serializable;
import java.util.Arrays;

public class EccCipher
implements Serializable {
    private static final long serialVersionUID = 1L;
    private byte[] x = new byte[64];
    private byte[] y = new byte[64];
    private byte[] m = new byte[32];
    private int l;
    private byte[] c = new byte[1];

    public EccCipher() {
    }

    public EccCipher(byte[] x, byte[] y, byte[] m, int l, byte[] c) {
        this.x = x;
        this.y = y;
        this.m = m;
        this.l = l;
        this.c = c;
    }

    public byte[] getX() {
        return this.x;
    }

    public void setX(byte[] x) {
        this.x = x;
    }

    public byte[] getY() {
        return this.y;
    }

    public void setY(byte[] y) {
        this.y = y;
    }

    public byte[] getM() {
        return this.m;
    }

    public void setM(byte[] m) {
        this.m = m;
    }

    public int getL() {
        return this.l;
    }

    public void setL(int l) {
        this.l = l;
    }

    public byte[] getC() {
        return this.c;
    }

    public void setC(byte[] c) {
        this.c = c;
    }

    public String toString() {
        return "EccCipher [x=" + Arrays.toString(this.x) + ", y=" + Arrays.toString(this.y) + ", m=" + Arrays.toString(this.m) + ", l=" + this.l + ", c=" + Arrays.toString(this.c) + "]";
    }

    public byte[] getObjectByteArray() {
        byte[] result = new byte[164 + this.getL()];
        Arrays.fill(result, (byte)0);
        System.arraycopy(this.getX(), 0, result, 0, 32);
        System.arraycopy(this.getY(), 0, result, 32, 32);
        System.arraycopy(this.getM(), 0, result, 64, 32);
        result[99] = (byte)(this.getL() >> 24 & 0xFF);
        result[98] = (byte)(this.getL() >> 16 & 0xFF);
        result[97] = (byte)(this.getL() >> 8 & 0xFF);
        result[96] = (byte)(this.getL() & 0xFF);
        System.arraycopy(this.getC(), 0, result, 100, this.getL());
        return result;
    }

    public static EccCipher getEccCipher(byte[] buf) {
        EccCipher cipher = new EccCipher();
        byte[] tx = new byte[64];
        byte[] ty = new byte[64];
        byte[] tm = new byte[32];
        byte[] tc = new byte[buf.length - 100];
        int len = 0;
        System.arraycopy(buf, 0, tx, 0, 32);
        cipher.setX(tx);
        System.arraycopy(buf, 32, ty, 0, 32);
        cipher.setY(ty);
        System.arraycopy(buf, 64, tm, 0, 32);
        cipher.setM(tm);
        int i = 99;
        int j = 0;
        while (i >= 96) {
            int shift = (3 - j) * 8;
            len += (buf[i] & 0xFF) << shift;
            --i;
            ++j;
        }
        cipher.setL(len);
        System.arraycopy(buf, 100, tc, 0, len);
        cipher.setC(tc);
        return cipher;
    }
}

