/*
 * Decompiled with CFR 0.152.
 */
package com.xjda.framework.agreement.central.listener;

import com.xjda.framework.agreement.central.listener.event.ConfigChangeEvent;
import com.xjda.framework.agreement.central.util.SystemConfig;
import java.io.File;
import java.io.FileFilter;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.io.monitor.FileAlterationListener;
import org.apache.commons.io.monitor.FileAlterationListenerAdaptor;
import org.apache.commons.io.monitor.FileAlterationMonitor;
import org.apache.commons.io.monitor.FileAlterationObserver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.util.StringUtils;

public class FileConfigChangeListener
extends FileAlterationListenerAdaptor {
    private static final Logger log = LoggerFactory.getLogger(FileConfigChangeListener.class);
    private String watchDir;
    private long interval;
    private FileFilter fileFilter;
    private AtomicBoolean isStart = new AtomicBoolean(false);
    private ConfigurableApplicationContext applicationContext;

    public FileConfigChangeListener(String watchDirs, FileFilter fileFilter, long interval, ConfigurableApplicationContext applicationContext) {
        this.watchDir = watchDirs;
        this.interval = TimeUnit.SECONDS.toMillis(interval);
        this.fileFilter = fileFilter;
        this.applicationContext = applicationContext;
    }

    public void start() throws Exception {
        if (!this.isStart.get()) {
            String[] refreshPaths = StringUtils.trimArrayElements((String[])StringUtils.commaDelimitedListToStringArray((String)this.watchDir));
            FileAlterationObserver[] fileAlterationObservers = new FileAlterationObserver[refreshPaths.length];
            for (int i = 0; i < fileAlterationObservers.length; ++i) {
                FileAlterationObserver fileAlterationObserver = new FileAlterationObserver(refreshPaths[i], this.fileFilter);
                fileAlterationObserver.addListener((FileAlterationListener)this);
                fileAlterationObservers[i] = fileAlterationObserver;
            }
            FileAlterationMonitor monitor = new FileAlterationMonitor(this.interval, fileAlterationObservers);
            monitor.start();
            this.isStart.compareAndSet(false, true);
        }
    }

    public void onFileChange(File file) {
        log.info("\u914d\u7f6e\u6587\u4ef6 [{}] \u53d1\u751f\u66f4\u65b0", (Object)file.getName());
        String absolutePath = file.getAbsolutePath();
        SystemConfig.getInstance().initSystemProperties(absolutePath, false);
        this.applicationContext.publishEvent((ApplicationEvent)new ConfigChangeEvent(file));
    }
}

