/*
 * Decompiled with CFR 0.152.
 */
package com.xjda.framework.agreement.central.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;

public class ConfigUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigUtil.class);
    public static Environment environment;

    public static boolean getFlag(String key) {
        return "true".equalsIgnoreCase(ConfigUtil.getString(key));
    }

    public static boolean getSwitch(String key) {
        return "on".equalsIgnoreCase(ConfigUtil.getString(key));
    }

    public static double getDoubleValue(String key) {
        Number number = ConfigUtil.getNumber(key);
        return number.doubleValue();
    }

    public static int getIntValue(String key) {
        Number number = ConfigUtil.getNumber(key);
        return number.intValue();
    }

    public static String getString(String key) {
        return ConfigUtil.getStringSafe(key, null);
    }

    private static Number getNumber(String key) {
        try {
            return (Number)environment.getProperty(key, Number.class);
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6 number \u7c7b\u578b\u914d\u7f6e[{}]\u5f02\u5e38", (Object)key);
            throw new RuntimeException(e);
        }
    }

    public static String getStringSafe(String key, String defaultVale) {
        return environment.getProperty(key, defaultVale == null ? "" : defaultVale);
    }
}

