/*
 * Decompiled with CFR 0.152.
 */
package com.xjda.framework.agreement.central.util;

import com.xjda.framework.agreement.central.environment.PropertiesLoadHelper;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.PropertySource;

public class SystemConfig {
    private static Logger log = LoggerFactory.getLogger(SystemConfig.class);
    private Map<String, Map<String, Object>> mapProperties = new HashMap<String, Map<String, Object>>();
    private Map<String, Object> mapSystemProperties = new HashMap<String, Object>();
    private static SystemConfig instance = new SystemConfig();

    private SystemConfig() {
        String fileNames = System.getProperty("config.enable-refresh-file-name");
        for (String fileName : fileNames.split(",")) {
            String filePath = System.getProperty(fileName);
            this.initSystemProperties(filePath, true);
        }
    }

    public static SystemConfig getInstance() {
        return instance;
    }

    private static Map<String, Object> getMapSystemProperties() {
        return SystemConfig.instance.mapSystemProperties;
    }

    private static Map<String, Map<String, Object>> getMapProperties() {
        return SystemConfig.instance.mapProperties;
    }

    private static Map<String, Object> getPrefixSystemProperties(String prefix) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : SystemConfig.instance.mapSystemProperties.entrySet()) {
            boolean flag = entry.getKey().startsWith(prefix);
            if (!flag) continue;
            map.put(entry.getKey(), entry.getValue());
        }
        return map;
    }

    public synchronized void initSystemProperties(String absolutePath, boolean init) {
        try {
            List<PropertySource<?>> propertySources = PropertiesLoadHelper.INSTANCE.loadProperties(new File(absolutePath));
            PropertySource<?> propertySource = propertySources.get(0);
            HashMap<String, Object> mapNewSystemPropertiesConfig = new HashMap<String, Object>((Map)propertySource.getSource());
            boolean propertyChangedFlag = false;
            if (!init) {
                propertyChangedFlag = this.publishSystemPropertiesChanged(absolutePath, mapNewSystemPropertiesConfig);
            }
            if (init || propertyChangedFlag) {
                this.mapSystemProperties.putAll(mapNewSystemPropertiesConfig);
            }
        }
        catch (Exception e) {
            log.error("\u52a0\u8f7dsystem.properties\u6587\u4ef6\u5931\u8d25:", (Throwable)e);
        }
    }

    private boolean publishSystemPropertiesChanged(String absolutePath, Map<String, Object> mapNewSystemPropertiesConfig) {
        Map<String, Object> mapCache = this.mapProperties.get(absolutePath);
        if (null == mapCache) {
            this.mapProperties.put(absolutePath, mapNewSystemPropertiesConfig);
            return false;
        }
        HashMap mapSystemPropertiesFileChanged = new HashMap();
        if (mapNewSystemPropertiesConfig.size() > mapCache.size()) {
            mapNewSystemPropertiesConfig.forEach((k, v) -> {
                if (!v.equals(mapCache.get(k))) {
                    mapSystemPropertiesFileChanged.put(k, mapNewSystemPropertiesConfig.get(k));
                }
            });
        } else {
            mapCache.forEach((k, v) -> {
                if (!v.equals(mapNewSystemPropertiesConfig.get(k))) {
                    mapSystemPropertiesFileChanged.put(k, mapNewSystemPropertiesConfig.get(k));
                }
            });
        }
        return mapSystemPropertiesFileChanged.size() > 0;
    }

    public List getList(String key) {
        Object o = this.mapSystemProperties.get(key);
        if (!Objects.isNull(o)) {
            return (List)o;
        }
        return null;
    }

    public Map getMap(String key) {
        Object o = this.mapSystemProperties.get(key);
        if (!Objects.isNull(o)) {
            return (Map)o;
        }
        return null;
    }

    public String getString(String key) {
        return null != this.mapSystemProperties.get(key) ? this.mapSystemProperties.get(key).toString() : null;
    }

    public String getString(String key, String defaultValue) {
        String string = this.getString(key);
        if (null == string) {
            return defaultValue;
        }
        return string;
    }

    public int getInt(String key) {
        String value = this.getString(key);
        return Integer.parseInt(value);
    }

    public int getInt(String key, int defaultValue) {
        String value = this.getString(key);
        if (null == value || "".equals(value)) {
            return defaultValue;
        }
        return Integer.parseInt(value);
    }

    public long getLong(String key) {
        String value = this.getString(key);
        return Long.parseLong(value);
    }

    public long getLong(String key, long defaultValue) {
        String value = this.getString(key);
        if (null == value || "".equals(value)) {
            return defaultValue;
        }
        return Long.parseLong(value);
    }

    public boolean getBoolean(String key) {
        String value = this.getString(key);
        return Boolean.parseBoolean(value);
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        String value = this.getString(key);
        if (null == value || "".equals(value)) {
            return defaultValue;
        }
        return Boolean.parseBoolean(value);
    }

    public double getDouble(String key) {
        String value = this.getString(key);
        return Double.parseDouble(value);
    }

    public double getDouble(String key, double defaultValue) {
        String value = this.getString(key);
        if (null == value || "".equals(value)) {
            return defaultValue;
        }
        return Double.parseDouble(value);
    }
}

