/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cias.vsmp.base.bean;

import com.xdja.cias.vsmp.util.DateUtil;
import com.xdja.platform.util.DateTimeUtil;
import java.io.Serializable;
import java.util.Calendar;
import org.apache.commons.lang3.StringUtils;

public class BaseSearchCondition
implements Serializable {
    private static final long serialVersionUID = 4016436556694310246L;
    public static final int TIMETYPE_TODAY = 1;
    public static final int TIMETYPE_THREE_DAY = 2;
    public static final int TIMETYPE_WEEK = 3;
    public static final int TIMETYPE_MONTH = 4;
    public static final int TIMETYPE_CUSTOM = 5;
    public static final int TIMETYPE_PREDAY = 6;
    private int timeType = 1;
    private String startTime;
    private String endTime;
    private String searchKey;
    private Long start;

    public int getTimeType() {
        return this.timeType;
    }

    public void setTimeType(int timeType) {
        this.timeType = timeType;
    }

    public String getStartTime() {
        return this.startTime;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public String getEndTime() {
        return this.endTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public String getSearchKey() {
        return this.searchKey;
    }

    public void setSearchKey(String searchKey) {
        this.searchKey = searchKey;
    }

    public Long getStart() {
        if (null != this.start) {
            return this.start;
        }
        Calendar c = Calendar.getInstance();
        DateUtil.resetTime(c);
        switch (this.timeType) {
            case 1: {
                this.start = c.getTimeInMillis();
                break;
            }
            case 2: {
                c.add(5, -2);
                this.start = c.getTimeInMillis();
                break;
            }
            case 3: {
                c.add(5, -6);
                this.start = c.getTimeInMillis();
                break;
            }
            case 4: {
                c.add(5, -29);
                this.start = c.getTimeInMillis();
                break;
            }
            case 5: {
                if (!StringUtils.isNotBlank((CharSequence)this.startTime) || this.startTime.equals("0")) break;
                this.start = DateTimeUtil.getStartTime((String)this.startTime.trim());
                break;
            }
            case 6: {
                this.start = DateUtil.getPreDay();
                break;
            }
        }
        return this.start;
    }

    public void setStart(Long start) {
        this.start = start;
    }

    public Long getEnd() {
        if (this.timeType == 5 && StringUtils.isNotBlank((CharSequence)this.endTime) && !this.endTime.equals("0")) {
            return DateTimeUtil.getEndTime((String)this.endTime.trim());
        }
        return null;
    }

    public String getDateFormat() {
        String dateFormat = "";
        switch (this.timeType) {
            case 1: {
                dateFormat = "hh:mm";
                break;
            }
            case 2: {
                dateFormat = "MM-dd hh:mm";
                break;
            }
            case 3: {
                dateFormat = "MM-dd";
                break;
            }
            case 4: {
                dateFormat = "yyyy-MM-dd";
                break;
            }
            case 5: {
                if (!StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.startTime, this.endTime})) break;
                int dDay = (int)((DateTimeUtil.getStartTime((String)this.endTime) - DateTimeUtil.getStartTime((String)this.startTime)) / 86400000L);
                if (dDay <= 1) {
                    dateFormat = "hh:mm";
                    break;
                }
                if (dDay <= 3) {
                    dateFormat = "MM-dd hh:mm";
                    break;
                }
                dateFormat = "yyyy-MM-dd";
                break;
            }
        }
        return dateFormat;
    }
}

