/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cias.vsmp.util;

import java.util.Arrays;

public class ByteUtils {
    public static byte[] int2bytes(int i) {
        byte[] abyte0 = new byte[4];
        abyte0[3] = (byte)(0xFF & i);
        abyte0[2] = (byte)((0xFF00 & i) >> 8);
        abyte0[1] = (byte)((0xFF0000 & i) >> 16);
        abyte0[0] = (byte)((0xFF000000 & i) >> 24);
        return abyte0;
    }

    public static int bytes2int(byte[] b) {
        int res = 0;
        res <<= 8;
        res |= b[0] & 0xFF;
        res <<= 8;
        res |= b[1] & 0xFF;
        res <<= 8;
        res |= b[2] & 0xFF;
        res <<= 8;
        return res |= b[3] & 0xFF;
    }

    public static String getBinaryStrFromByteArr(byte[] bArr) {
        String result = "";
        for (byte b : bArr) {
            result = result + ByteUtils.getBinaryStrFromByte(b);
        }
        return result;
    }

    public static String getBinaryStrFromByte(byte b) {
        String result = "";
        byte a = b;
        for (int i = 0; i < 8; ++i) {
            result = a % 2 + result;
            a = (byte)(a / 2);
        }
        return result;
    }

    public static String byte2hex(byte b) {
        char[] digit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        char[] c = new char[]{digit[b >>> 4 & 0xF], digit[b & 0xF]};
        String s = new String(c);
        return s;
    }

    public static String bytes2Hex(byte[] b) {
        StringBuilder ret = new StringBuilder();
        for (int i = 0; i < b.length; ++i) {
            String hex = Integer.toHexString(b[i] & 0xFF);
            if (hex.length() == 1) {
                hex = '0' + hex;
            }
            ret.append(hex.toUpperCase());
        }
        return ret.toString();
    }

    public static byte[] hex2bytes(String hex) {
        if (hex.length() % 2 != 0) {
            hex = "0" + hex;
        }
        int len = hex.length() / 2;
        byte[] result = new byte[len];
        char[] achar = hex.toCharArray();
        for (int i = 0; i < len; ++i) {
            String item = new String(achar, i * 2, 2);
            result[i] = (byte)Integer.parseInt(item, 16);
        }
        return result;
    }

    public static byte[] join(byte[] arr1, byte[] arr2) {
        byte[] result = new byte[arr1.length + arr2.length];
        System.arraycopy(arr1, 0, result, 0, arr1.length);
        System.arraycopy(arr2, 0, result, arr1.length, arr2.length);
        return result;
    }

    public static byte[] join(byte[] ... arr) {
        int len = 0;
        for (int i = 0; i < arr.length; ++i) {
            len += arr[i].length;
        }
        byte[] result = new byte[len];
        int startPos = 0;
        for (int i = 0; i < arr.length; ++i) {
            System.arraycopy(arr[i], 0, result, startPos, arr[i].length);
            startPos += arr[i].length;
        }
        return result;
    }

    public static byte[] intToTwoByte(int i) {
        byte[] result = new byte[]{(byte)(i >> 8 & 0xFF), (byte)(i & 0xFF)};
        return result;
    }

    public static byte[] warpAndFill(byte[] source, int length) {
        int len = length - source.length;
        if (len > 0) {
            byte[] result = new byte[len];
            Arrays.fill(result, (byte)49);
            return ByteUtils.join(source, result);
        }
        return source;
    }

    public static void main(String[] args) {
        byte[] source = new byte[]{1, 2, 3, 4};
        byte[] result = ByteUtils.warpAndFill(source, 10);
        System.out.println(ByteUtils.bytes2Hex(result));
    }
}

